<?php
/**
 * Description of DatosFacturacionForm
 *
 * @author carlos
 */

class SucursalForm extends Form {

    public function __construct() {
        $this->setActionForm('Store.php');
        $this->setName('sucursal');
        $this->setClass('sucursal');
        $this->setMethod('post');
        $this->setEnctype('multipart/form-data');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=> true
        ));        
        
        $this->addElement(array(
            'type' => 'file',
            'name' => 'logo_file',
            'label' => 'Logo',
            'class' => 'upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Logo para factura'
            ),
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'direccion',
            'label'=>'Direccion',
            'required'=> false
        ));          
                
        $this->addElement(array(
            'type' => 'select',
            'name' => 'pais',
            'label'=>'Pais',
            'multiOptions'=>array('USA'=>'USA'),
            'required'=>true
        ));
                
        $this->addElement(array(
            'type' => 'text',
            'name' => 'estado',
            'label'=>'Estado',
            'required'=>false
        ));   
                        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'ciudad',
            'label'=>'Ciudad',
            'required'=>false
        ));
                
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigopostal',
            'label'=>'Codigo postal',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre_contacto',
            'label'=>'Nombre contacto',
            'required'=> false
        )); 
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'telefono',
            'label'=>'Telefono',
            'required'=> false
        )); 
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fax',
            'label'=>'Fax',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'email',
            'label'=>'E-mail',
            'required'=> false
        )); 
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'paginaweb',
            'label'=>'Web',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions'=>array('1'=>'Activa','2'=>'Inactiva'),
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Store.php'"),
            'class'=>'btn btn-danger m-t-1'
        ));
        
        /*Se utiliza para consulta si existe en la tabla de requisitions_details_X, si existe se actualiza registro.*/
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        )); 
         
         $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
         $this->addElement(array(
            'type' => 'select',
            'name' => 'product',
            'label'=>'Producto',
            'multiOptions'=>$this->getListProducts(),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
            'append'=>$append

         ));
        
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'days',
            'label'=>'Dias',
            'multiOptions'=>$this->getListDays(),
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'min',
            'label'=>'Minimo',
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'max',
            'label'=>'Maximo',
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-default',
            'optionals'=>array('onClick'=>'setStoreDetails()')
        ));          
    }    
    
    public function getListProducts(){
        $repository = new ProductoRepository();
        #1 = status activo
        $productos = $repository->getListaProductos('Producto');
        
        $array = array('0'=>'Seleccionar una opcion..');        
        foreach($productos as $producto){      
            $array[$producto['id']] = $producto['codigo']." - ".$producto['descripcion']." ".$producto['tamano'];
        }
        
        $list= array();
        foreach ($array as $key => $value) {
            $list[$key] = $value;
        }
        return $list;
    }
    
    public function getListDays(){
        $repository = new SucursalRepository();
        $result = $repository->getListDays();
        
        $array = array(''=>'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }

    public function populate($data){
        unset($data['logo']);     
        parent::populate($data);
    }
}