<?php
/**
 * Description of ClienteForm
 *
 * @author carlos
 */
class LoadLineForm extends Form {

    public function __construct() {
        $this->setActionForm('Load-line.php');
        $this->setName('loadLine');
        $this->setMethod('post');
        $this->setClass('loadline');     
        parent::__construct();
        $this->init();
    }

    public function init() {
         $this->addElement(array(
            'type' => 'text',
            'name' => 'statusName',
            'label'=>'Status',
            'optionals'=>array('readOnly'=>'readOnly'),
            'required'=>false,
        ));         
         
        $attributes_wrapper_append_date = array('id'=>'dateDatePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'validators'=>array('date'),
            'required'=>true,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date,
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'req_number',
            'label'=>'Num de orden',
            'multiOptions'=>$this->getListRequisitionOpen(),
            'optionals'=>array('onclick'=>'setTypeRequisition(this.value)'),
            'required'=>true,        
        ));          
        
       $this->addElement(array(
            'type' => 'select',
            'name' => 'id_line',
            'label'=>'Linea',
            'multiOptions' => $this->getListLines(),
            'required'=> true,
        ));
       
        #Para guardar tipo de requisicion "Line" o "Special"
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'type',
            'required'=>false
        ));
       
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments',
            'label'=>'Notas',
            'required'=>false,
        ));          
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Load-line.php'"),
            'class'=>'btn btn-danger m-t-1'
        ));
    }
    
    public function getListLines(){
        $repository = new LoadLineRepository();
        $result = $repository->getListSelectLines();
         
       if(count($result)>1){ $array = array(''=>'Seleccionar una opcion...');}
        if ($result) {               
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function getListRequisitionOpen(){
        $repository = new LoadLineRepository();
        $result = $repository->getRequisitions();
        
        if(count($result)>1){ $array = array(''=>'Seleccionar una opcion...');}
        if ($result) {               
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }        
    }
    
    public function populate($data) {
        $tools = new Tools();
        if(isset($data['date']) && $tools->isValidaDateYYYMMDD($data['date'])){
            $data['date'] = $tools->setFormatDateToForm($data['date']);
        }
        parent::populate($data);
    }
}