<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class DenominacionesForm extends Form {

    public function __construct() {
        $this->setName('denominaciones');
        $this->setClass('denominaciones form-horizontal');
        $this->setDefaultFormElementsColSize('7');
        $this->setDefaultFormLabelsColSize('5');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'elementId'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '1c',
            'label'=>'1 c',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '5c',
            'label'=>'5 c',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '10c',
            'label'=>'10 c',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '25c',
            'label'=>'25 c',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '50c',
            'label'=>'50 c',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '1dollar',
            'label'=>'1 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '2dollar',
            'label'=>'2 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '5dollar',
            'label'=>'5 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '10dollar',
            'label'=>'10 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '20dollar',
            'label'=>'20 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '50dollar',
            'label'=>'50 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => '100dollar',
            'label'=>'100 Dollar',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'terminar',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"sumDenominaciones()"),
            'class'=>'btn btn-success m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'clear',
            'value'=> $this->_getTranslation('Limpiar'),
            'optionals'=>array(
                'onclick'=>"clearForm('{$this->getName()}')"),
            'class'=>'btn btn-default m-t-1 m-b-1'
        ));

    }
    
    public function populate($data){
        parent::populate($data);
    }
    
    
    public function getSumDenominaciones(){
        $valueDenominaciones = array(    
            '1c'=>.01,
            '5c'=>.05,
            '10c'=>.10,
            '25c'=>.25,
            '50c'=>.50,
            '1dollar'=>1,
            '2dollar'=>2,
            '5dollar'=>5,
            '10dollar'=>10,
            '20dollar'=>20,
            '50dollar'=>50,
            '100dollar'=>100
        );
        
        $sumMonto = 0;
        $elements = $this->getElements();
        
        foreach($elements as $element){
            if(isset($valueDenominaciones[$element['name']])){
                $sumMonto += $element['value'] * $valueDenominaciones[$element['name']];
            }            
        }
        return $sumMonto;        
    }
}