<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class UsuarioRepository extends EntityRepository {

    private $table = 'usuarios';

    public function save(array $data, $table = null) {        
        $data['contrasena'] = MD5($data['contrasena']);
        if(is_array($data['sucursal']) && count($data['sucursal']) > 0){
            $sucursal = implode(',', $data['sucursal']);
            $data['sucursal'] = trim($sucursal,',');
        }        
        
        $rs = parent::save($data, $this->table);
        /*
        if($rs  && $data['acceso_movil']==='1'){
            $this->saveMobileUser($this->getInsertId(),$data);
        }*/
        
        return $rs;
    }
    
    public function delete($id, $table = null) {
        $data = $this->getById($id);
        $this->startTransaction();
        $rs =  parent::delete($id, $this->table);
        
        /*
        if($rs && $data['acceso_movil'] === '1'){
            if($this->deleteMobileUser($id)){
                $this->commit();
                return true;
            }
        }else{
            return $rs;
        }*/
        
        return $rs;
        
        $this->rollback();
        throw new Exception('Error al eliminar usuario.');
    }

    public function update($id, $data, $table = null) {                   
        $options = $data;
        $dataOrigin = $this->getById($id);
        
        if(trim($data['contrasena'])!='' && (trim($data['contrasena']))!== null){
            $data['contrasena'] = MD5($data['contrasena']);
            $options['contrasena'] = $data['contrasena'];
        }else{
            unset($data['contrasena']);
            $options['contrasena'] = $dataOrigin['contrasena'];
        }
        
        if(trim($data['nip'])=='' || (trim($data['nip'])) == null){
            unset($data['nip']);
        }

        if(is_array($data['sucursal']) && count($data['sucursal']) > 0){
            $sucursal = implode(',', $data['sucursal']);
            $data['sucursal'] = trim($sucursal,',');
        }
        
        $rs = parent::update($id, $data, $this->table);
        
        /*
        if($rs){            
            if($dataOrigin['acceso_movil'] === '0' && $data['acceso_movil']==='1'){
                 $this->saveMobileUser($id,$options);
            }elseif($dataOrigin['acceso_movil'] === '1' && $data['acceso_movil']==='1'){
                $this->updateMobileUser($id,$options);
            }elseif($dataOrigin['acceso_movil'] === '1' && $data['acceso_movil']==='0'){
                $this->deleteMobileUser($id,$options);
            }           
        }
        */
        return $rs;
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array(
            //'compras' => 'creado_por',
            'ventas'=>'creado_por',
            'apertura_cierre_cajas'=>'creado_por',
            'cobros'=>'creado_por',
            'devoluciones'=>'creado_por',
            'estaciones'=>'creado_por',
            'impuestos'=>'creado_por',
            //'mermas'=>'creado_por',
            //'pagos'=>'creado_por',
            'presentaciones'=>'creado_por',
            //'proveedores'=>'creado_por',
            'unidades_de_medida'=>'creado_por',
            'ventas_suspendidas'=>'creado_por'));
    }

    public function getListRoles() {
        $select = "SELECT id,role FROM acl_roles";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['role'];
            }
            return $array;
        }
        return null;
    }
    
    public function getUsersByIds($ids){
        $select = "SELECT *,CONCAT(nombre,' ',apellido)as nombreCompleto FROM usuarios WHERE id IN($ids)";
        $result = $this->query($select);
        
        if($result){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getListaSelectUsuarios() {
        $select = "SELECT * FROM usuarios ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre'];
            }
            return $array;
        }
        return null;
    }
    
     public function getListaUsuarios() {
        $select = "SELECT *,"
                . "fxGetStatusName(status,'status','usuario') as statusNombre, "
                . "fxGetRoleName(role) as roleNombre "
                . "FROM usuarios ";
        
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getListStatus(){
        $query = "SELECT * FROM codigo_status WHERE tipo = 'User'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            foreach($result as $status){
                $array[$status['codigo']] = $status['descripcion'];
            }
            return $array;
        }
        return null;
    }
    
    public function getUserByNIP($nip){
        $query = "SELECT * FROM $this->table where nip = '$nip' AND status = '1' LIMIT 1 ";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function sucursalesStringToArray($sucursales){
        $arraySucursales = array();
        $sucursales = explode(',', $sucursales);
        foreach($sucursales as $key => $sucursal){
            $arraySucursales[$sucursal] = $sucursal;
        }
        return $arraySucursales;
    }
    
    public function saveMobileUser($user_id,$data){
        $settings = new SettingsEntity();
        $customer_code = $settings->_get('customer_code');
        
        $db = new MobileServerEntityRepository();
        $options = array(
            'usuario'=>$customer_code.'-'.$data['usuario'],
            'contrasena'=>$data['contrasena'],
            'nombre'=>$data['nombre'],
            'apellido'=>$data['apellido'],
            'role'=>$data['role'],
            'status'=>$data['status'],
            'customer_code'=>$settings->_get('customer_code'),
            'user_id'=>$user_id,
            'dbHostName'=>DB_HOSTNAME,
            'dbName'=>DB_NAME,
            'dbUserName'=>DB_USERNAME,
            'dbPassword'=>DB_PASSWORD,
            'creado_fecha'=>date('Y-m-d')
        );
        
        if(trim($options['contrasena'])!='' && (trim($options['contrasena']))!== null){
            $options['contrasena'] = MD5($data['contrasena']);
        }else{
            unset($options['contrasena']);
        }
        
        return $db->save($options, 'usuarios');        
    }
    
    public function updateMobileUser($id,$data){        
        $settings = new SettingsEntity();
        $customer_code = $settings->_get('customer_code');
        
        $db = new MobileServerEntityRepository();
        $options = array(
            'usuario'=>$customer_code.'-'.$data['usuario'],
            'contrasena'=>$data['contrasena'],
            'nombre'=>$data['nombre'],
            'apellido'=>$data['apellido'],
            'role'=>$data['role'],
            'status'=>$data['status'],
            'dbHostName'=>DB_HOSTNAME,
            'dbName'=>DB_NAME,
            'dbUserName'=>DB_USERNAME,
            'dbPassword'=>DB_PASSWORD,
            'creado_fecha'=>date('Y-m-d')
        );
        
        if(trim($options['contrasena'])==='' && (trim($options['contrasena']))=== null){
            unset($options['contrasena']);
        }
        return $db->updateString($options, " customer_code = '$customer_code' AND user_id = '$id'", 'usuarios');
    }
    
     public function deleteMobileUser($id){
         $settings = new SettingsEntity();
         $customer_code = $settings->_get('customer_code');
          
         $db = new MobileServerEntityRepository();
         $query = "DELETE FROM usuarios WHERE customer_code = '{$customer_code}' AND user_id = '{$id}}'";
         $result = $db->query($query);
         
         if($result){
             return true;
         }
         
         throw new Exception('Error al eliminar acceso movil de usuario.');
     }
     
         
    public function existNIP($options){
        $query = "SELECT id FROM $this->table WHERE nip = '{$options['nip']}' AND id != '{$options['id']}'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return true;
        }
        return null;
    }
}