<?php
class StoreOutDetailsTempRepository extends EntityRepository {

    private $table = 'store_out_details_';
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {
        $tools = new Tools();        
        
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                return parent::update($id,$data,$this->table);
            }
         }
        
        unset($data['idDetailTemp']);           
        
        $query = "SELECT id,quantity FROM ".$this->table.
                " WHERE idProduct = ".$data['idProduct'].
                " AND location = '".$data['location']."'";
        
        $result = $this->query($query);       

        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['quantity'] = $data['quantity'] + $result->quantity;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            return parent::save($data, $this->table);
        }
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idStoreOut){
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        if($result->num_rows > 0){           
            $result = $this->resultToArray($result);
            $repoInventorySupplie = new InventorySupplieRepository();
            
            foreach($result as $data){
                unset($data['id']);
                unset($data['id_detail']); 
                $data['id_store_out'] = $idStoreOut;
                
                if(parent::save($data, 'store_out_details')){
                   if(!$repoInventorySupplie->subInventory($data)){
                       return null;
                   }
                }
            }            
        }
        return true;
    } 
    
    public function updateDetalles($idStoreOut){
        $repoInventorySupplie = new InventorySupplieRepository();
        
        $query = "SELECT id,idProduct,quantity,location FROM store_out_details WHERE id_store_out = '$idStoreOut'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            $repoStoreOut = new StoreOutRepository();
            foreach($result as $data){
                $idDetalle = $data['id_detail'];
                unset($data['id']);
                unset($data['id_detail']);            
                $data['id_store_out'] = $idStoreOut;
              
                if(!$idDetalle){
                    if(parent::save($data, 'store_out_details')){
                        if(!$repoInventorySupplie->subInventory($data)){
                            return null;
                        }                    
                    }else{
                        return null;
                    }     
                }else{                    
                    #contiene los idDetalles de la salida original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    $currenData = $repoStoreOut->getStoreOutDetailSaved($idDetalle);
                    if(parent::update($idDetalle,$data, 'store_out_details')){
                        $data['current_quantity'] = $currenData['quantity'];
                        $data['current_location'] = $currenData['location'];
                        if(!$repoInventorySupplie->editSubInventory($data)){
                            return null;
                        }                    
                    }else{
                        return null;
                    }
                }  
            }
        }

        #Se eliminan ids de tabla store_out_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    if(parent::delete($detalle['id'], 'store_out_details')){
                        $repoInventorySupplie->addInventory($detalle);
                    }
                }
            }
        }  
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    
    public function truncateIfIsEditInfo(){
        $query = "SELECT id_store_out FROM .".$this->table." LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            if($result->id_store_out !=NULL || $result->id_store_out != ''){
                $this->truncate();
                return true;
            }
        }
        
        return null;
    }
    
    public function truncate(){
        $query = "TRUNCATE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function drop(){
        $query = "DROP TABLE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }        
        return null;
    }
    
    public function setStoreOutDetailsById($idStoreOut){
        $this->query("TRUNCATE ".$this->table);
        $query = "INSERT INTO ".$this->table." (id_detail,id_store_out,idProduct,quantity,location)
                    SELECT id,id_store_out,idProduct,quantity,location
                    FROM store_out_details 
                    WHERE id_store_out = '$idStoreOut'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}