<?php
class RequisitionDetailsTempRepository extends EntityRepository {

    private $table = 'requisitions_details_';
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                return parent::update($id, $data,$this->table);
            }
         }

        unset($data['idDetailTemp']);        
        $query = "SELECT id,quantity FROM ".$this->table.
                " WHERE id_product = '".$data['id_product']."' ";
        
        $result = $this->query($query);      
         
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['quantity'] = $data['quantity'] + $result->quantity;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            return parent::save($data, $this->table);
        }
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idRequisition,$reqNumber){
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        if($result->num_rows > 0){
           
            $result = $this->resultToArray($result);
            
            foreach($result as $data){
                unset($data['id']);
                unset($data['id_detail'],$data['produced']); 
                $data['id_requisition'] = $idRequisition;
                
                parent::save($data, 'requisitions_details');
            }  
            
            /*if(!$this->saveSupplies($idRequisition,$reqNumber)){return null;}*/
        }      
        
        return true;
    } 
    
    public function updateDetalles($idRequisition,$reqNumber){
        $query = "SELECT id FROM requisitions_details WHERE id_requisition = '$idRequisition'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $idDetalle = $data['id_detail'];
                unset($data['id'],$data['id_detail'],$data['produced']);
                $data['id_requisition'] = $idRequisition;
              
                if(!$idDetalle){
                    parent::save($data, 'requisitions_details');
                }else{
                    #contiene los idDetalles de la requisicion original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle,$data, 'requisitions_details');         
                }  
            }
        }

        #Se eliminan ids de tabla requisition_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la requisicion despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    parent::delete($detalle['id'], 'requisitions_details');
                }
            }
        }  
        
        /*if(!$this->updateSupplies($idRequisition,$reqNumber)){return null;}*/
            
        return true;
    }
    
    public function saveSupplies($idRequisition,$reqNumber){        
	 /*Para registros de insumos requeridos*/
         $query = "select 
                    sd.id_supplie, 
                    SUM(rd.quantity * pd.quantity * sd.quantity) as quantity,s.category
                    from requisitions_details rd, products_details pd, slices_details sd, slices s
                    where rd.id_product = pd.id_product
                    and pd.id_slice = sd.id_slice
                    and sd.id_slice = s.id
                    and rd.id_requisition = '$idRequisition'
                    group by sd.id_supplie,s.category";
        $result = $this->query($query);
        
        if($result->num_rows >0){
            $result = $this->resultToArray($result);
            foreach($result as $row){
                $data = array(
                    'req_number'=>$reqNumber,
                    'type'=>'Line',
                    'id_supplie'=>$row['id_supplie'],
                    'slice_category'=>$row['category'],
                    'quantity'=>$row['quantity']
                );
                
                $rs = parent::save($data, 'requisitions_details_supplies');
                if(!$rs){
                    return null;
                }
            }
        }
        return true;
    }    
        
    public function updateSupplies($idRequisition,$reqNumber){
        $query = "SELECT *,CONCAT(id_supplie,'-',slice_category)as idsupplie_idcategory "
                . "FROM requisitions_details_supplies "
                . "WHERE req_number = '$reqNumber'";
        $result = $this->query($query);
        $suppliesOrigin = array();    
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            foreach($result as $row){
                $key = $row['idsupplie_idcategory'];
                unset($row['idsupplie_idcategory']);
                $suppliesOrigin[$key] = $row;
            }
        }
        
        $query = "select CONCAT(sd.id_supplie,'-',s.category)as idsupplie_idcategory, '$reqNumber'as req_number, SUM(rd.quantity * pd.quantity * sd.quantity) as quantity,s.category as slice_category
                    from requisitions_details rd, products_details pd, slices_details sd, slices s
                    where rd.id_product = pd.id_product
                    and pd.id_slice = sd.id_slice
                    and sd.id_slice = s.id
                    and rd.id_requisition = '$idRequisition'
                    group by s.category,sd.id_supplie";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $idSupplie = $data['idsupplie_idcategory'];
                unset($data['id'],$data['idsupplie_idcategory'],$data['delivery'],$data['returned']);
              
                if(!key_exists($idSupplie, $suppliesOrigin)){
                    $data['type'] = 'Line'; 
                    parent::save($data, 'requisitions_details_supplies');
                }else{
                    #contiene los idDetalles de la requisicion original que se mantendran, lo que no esten aqui se eliminaran.                    
                    $idDetalle = $suppliesOrigin[$idSupplie]['id'];
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle,$data, 'requisitions_details_supplies');         
                }  
            }
        }

        #Se eliminan ids de tabla requisition_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la requisicion despues del update)                
        if(count($suppliesOrigin) > 0){
            foreach ($suppliesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    parent::delete($detalle['id'], 'requisitions_details_supplies');
                }
            }
        }
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    
    public function truncate(){
        $query = "TRUNCATE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function drop(){
        $query = "DROP TABLE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }        
        return null;
    }
    
    public function setRequisitionDetailsById($idRequisition){
        $this->query("TRUNCATE ".$this->table);
        $query = "INSERT INTO ".$this->table." (id_detail,id_requisition,id_product,quantity,produced)
                    SELECT id,id_requisition,id_product,quantity,produced
                    FROM requisitions_details WHERE id_requisition = '$idRequisition'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null) {
        if(isset($data['id_requisition'])){
            if($data['id_requisition']=='' || !$data['id_requisition']){
                unset($data['id_requisition']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}