<?php
class ReceivingDetailsTempRepository extends EntityRepository {

    private $table = 'receivings_details_';
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                return parent::update($id, $data,$this->table);
            }
         }

        unset($data['idDetailTemp']);        
        $query = "SELECT id,received FROM ".$this->table.
                " WHERE id_product = '".$data['id_product']."' AND token_form = '{$data['token_form']}' ";
        
        $result = $this->query($query);      
         
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['received'] = $data['received'] + $result->received;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            #No se pueden agregar productos que no hayan sido agredados desde Almacen
            return parent::save($data, $this->table);
            //return true;
        }
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idReceiving,$idSucursal, $tokenForm){
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        if($result->num_rows > 0){  
            $repoInventarory = new InventarioRepository();
            $result = $this->resultToArray($result); 
            
            foreach($result as $data){
                unset($data['id_detail'],$data['quantity'], $data['token_form'], $data['id']); 
                $data['id_receiving'] = $idReceiving;
                
                if(parent::save($data, 'receivings_details')){
                    if(!$repoInventarory->addInventory(array(
                        'id_product'=>$data['id_product'],
                        'quantity'=>$data['received'],
                        'sucursal'=>$idSucursal,
                        'controller'=>'Recibos-agregar '.$idReceiving))){
                        return null;
                    }
                }
            }  
        }
        return true;
    } 
    
    public function updateDetalles($idReceiving,$idSucursal, $tokenForm){
        $idsDetalles = array();
        $repoInventarory = new InventarioRepository();      
            
        $query = "SELECT id,received FROM receivings_details WHERE id_receiving = '$idReceiving'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOriginTemp = $this->resultToArray($result);
            foreach($detallesOriginTemp as $detalle){
                $detallesOrigin[$detalle['id']] = $detalle;
            }
        } 
        
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
       
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);              
            
            foreach($result as $data){
                $idDetalle = $data['id_detail'];
                unset($data['id'],$data['id_detail'],$data['quantity'], $data['token_form']);
                $data['id_receiving'] = $idReceiving;
                if($data['received']==''){$data['received'] = '0';}
              
                if(!$idDetalle){
                    
                    if(parent::save($data, 'receivings_details')){  
                        //var_dump($data);exit;
                        if(!$repoInventarory->addInventory(array(
                            'id_product'=>$data['id_product'],
                            'quantity'=>$data['received'],
                            'sucursal'=>$idSucursal,
                            'controller'=>'Recibos-editar '.$idReceiving))){
                            
                            return null;
                        }
                    }
                    
                }else{
                    #contiene los idDetalles de la requisicion original que se mantendran, lo que no esten aqui se eliminaran.
                    $currentData = $detallesOrigin[$idDetalle];
                    $idsDetalles[] = $idDetalle;                   
                       
                    if(parent::update($idDetalle,$data, 'receivings_details')){
                         if(!$repoInventarory->updateAddInventory(array(
                                        'id_product'=>$data['id_product'],
                                        'current_quantity'=>$currentData['received'],
                                        'new_quantity'=>$data['received'],
                                        'current_sucursal'=>$idSucursal,
                                        'new_sucursal'=>$idSucursal,
                                        'controller'=>'Recibos-editar '.$idReceiving
                                ))){
                             
                             return null;
                         }
                    }                    
                }  
            }
        }
        
        #Se eliminan ids de tabla requisition_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la requisicion despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){   
                    if(parent::delete($detalle['id'], 'receivings_details')){     
                        if(!$repoInventarory->subInventory(array(
                                'id_product'=>$detalle['id_product'],
                                'quantity'=>$detalle['received'],
                                'sucursal'=>$idSucursal,
                                'controller'=>'Recibos-editar '.$idReceiving))){
                            return null;
                        }
                    }
                }
            }
        }              
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    
    public function truncate($tokenForm){
        $query = "DELETE FROM ".$this->table." WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function setReceivingDetailsById($idReceiving, $tokenForm){
        $query = "INSERT INTO ".$this->table." (id_detail,token_form,id_receiving,id_product,quantity,received)
                    SELECT id,'$tokenForm',id_receiving,id_product,quantity,received
                    FROM receivings_details WHERE id_receiving = '$idReceiving'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null) {
        if(isset($data['id_receiving'])){
            if($data['id_receiving']=='' || !$data['id_receiving']){
                unset($data['id_receiving']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}