<?php

class ProveedorRepository extends EntityRepository {
    
    private $table = 'proveedores';

    public function save(array $data, $table = null) {
        $login = new Login();
        $data['creado_fecha'] = date('Y-m-d');
        $data['creado_por'] = $login->getId();
        unset($data['modificaciones']);
        
        if($data['diasCredito'] == '' || $data['diasCredito'] == null){$data['diasCredito']= '0';}
        if($data['metodoPago'] == '' || $data['metodoPago'] == null){unset($data['metodoPago']);}
        return parent::save($data, $this->table);
    }

    public function update($id, $data, $table = null) {
        unset($data['creado_fecha']);
        unset($data['creado_por']);
        unset($data['modificaciones']);
        
        if(!isset($data['diasCredito'])){$data['diasCredito']= '0';}
        if($data['metodoPago'] == '' || $data['metodoPago'] == null){unset($data['metodoPago']);}
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,if(diasCredito = 0,'',diasCredito)as diasCredito "
                 . "FROM $this->table WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }
        return false;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere= null) {
        return null;
        return parent::isUsedInRecord($id, array('compras'=>'proveedor'));   
    }
    
    public function getListaSelectProveedores(){
        $query = "SELECT id,nombre FROM $this->table ORDER BY nombre ASC";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->nombre;
            }
            
            return $array;
        }
        
        return null;
    }
    
     public function getListaProveedores(){
        $query = "SELECT * FROM $this->table ORDER BY nombre ASC";
        $result = $this->query($query);
        
        if($result){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getSaldoPendiente(array $options = null,$onlyInvoices = null){
        $andCliente = null;
        if(isset($options['idProveedor']) && trim($options['idProveedor']) !=='' && $options['idProveedor'] != null){
            $andCliente = "AND proveedor = '{$options['idCliente']}'";
        }  
        $fecha = null;
        if(isset($options['fi'])){
            $fecha = $this->createFilterFecha(array('fechaInicio'=>$options['fi'],'fechaFin'=>$options['ff']), 'fecha'); 
        }
        
        $query = "SELECT SUM(saldoPendiente)as saldo "
                . "FROM view_saldo_pendientes_compras "
                . "WHERE 1=1 $andCliente $fecha";
        $result = $this->query($query);
        
         $saldoFacturas = 0;
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $saldoFacturas = $result->saldo;
        }
        
        return $saldoFacturas;
    }
    
    public function getOpenInvoices($proveedor = null,$options = null){
        
        $fecha = null;
        if(isset($options['fi'])){$fecha = $this->createFilterFecha(array('fechaInicio'=>$options['fi'],'fechaFin'=>$options['ff']), 'fecha'); }
        if($proveedor){$proveedor = " AND proveedor = '$proveedor'";}
        
        $query = "SELECT *,fxGetProveedorNombre(proveedor)as clienteName FROM view_saldo_pendientes_compras WHERE 1=1 $proveedor $fecha";
        $result = $this->query($query);
                
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        $fechaInicio = $options['fechaInicio'];
        $fechaFin = $options['fechaFin'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
}