<?php
class StoreRequestAjax extends StoreRequestRepository {    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }  
    
    public function listStoreRequestDetalles($detalles){
        $listDetalles = "";
        $totalProductos = 0;
        $tokenForm = null;
        
        foreach($detalles as $detalle){
            $tokenForm = $detalle['token_form'];
            $totalProductos += $detalle['quantity'];          
            
            $listDetalles .= "<tr>"             
                ."<td class='text-center'>".$detalle['descripcion']."</td>"
                ."<td class='text-center'>".$detalle['sizeName']."</td>"
                ."<td class='text-center'><input name='{$detalle['id']}' type='text' value='{$detalle['quantity']}' class='_storeRequestQuantity' /></td>"                
                ."</tr>";
        }
        
        return array('listDetalles'=>$listDetalles,
                     'totalProductos'=>$totalProductos);
    }
    
    public function getListStoreRequestDetalles($tokenForm){
        $manifestDetalles = $this->getStoreRequestDetalles($tokenForm);
        $detalles = $this->listStoreRequestDetalles($manifestDetalles);

            $json = array(
                'response' => true,
                'storeRequestDetalles' => $detalles['listDetalles'],
                'totalProductos'=>$detalles['totalProductos']
            );       
            return $json;
    }
    
    public function updateStoreRequestQty($options){
        if(!isset($options['storage_request_quantity'])){return array('response'=>true);}
        $tokenForm = $options['token_form'];
        $data = array();
        foreach($options['storage_request_quantity'] as $row){
            $data[$row['name']] = $row['value'];
        }   
       
        $repository = new StoreRequestDetailsTempRepository();    
        foreach ($data as $id => $quantity){
            if($quantity === '' OR $quantity == '0' OR is_null($quantity)){$quantity = 0;}
            parent::query("UPDATE ".$repository->getTableName()." SET quantity = '$quantity' WHERE id = '$id'");
        }       
        
        return array(
            'response'=>true
        );
    }
    
    public function generateShipment($options) {
        return parent::_generateShipment($options['id_store_request']);
    }
}