<?php
class SpecialRequisitionAjax extends SpecialRequisitionRepository {
    public $formProduct = null;
    public $formRequisition = null;
    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setRequisitionDetails(array $options) {
        
        $data = array();
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }
        
        $options = $data;
        $type = $data['type'];
        $producto = $this->getProductById($options['product'],$type);
        
        if($producto){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'type'=>$options['type'],
                'id_product'=>$producto['id'],
                'quantity'=>$options['quantity'],
                'price'=>$options['price'],
                'multiple'=>$options['multiple'],
                'token_form'=>$options["token_form"]); /*Para cuenta de inventario*/
                
            $this->insertDetalle($data);
            $requisitionDetails = $this->getRequisitionDetails($type,$data['token_form']);
            $detalles = $this->listRequisitionDetails($requisitionDetails,$type);
            
            $json = array(
                'response' => true,
                'requisitionDetails' => $detalles['requisitionDetails'],
                'grandTotal'=>$detalles['total'],
            );
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listRequisitionDetails($detalles,$type){
        $listDetalles = "";
        $totalTotal = 0;
        
        foreach($detalles as $detalle){
            
            $total = $detalle['quantity'] * $detalle['price'];
            $totalTotal += $total;
            $prefix = '';
            
            if($detalle['type']=='Line'){$prefix = "l_"; $detalle['l_categoria'] = "";}
            elseif($detalle['type']=='Special'){$prefix = "s_";}
            $id = $detalle['id'];
            unset($detalle['id']);
            
            $array = htmlentities(json_encode($detalle), ENT_QUOTES, 'UTF-8');
            $listDetalles .= "<tr>  
                <td class='text-left'>                       
                    <a class='btn btn-sm btn-primary' onclick='setDetailSpecialRequisitionToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteSpecialRequisitionDetails($id);' data-type='{$detalle['type']}'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['multiple']."</td>
                <td>".$detalle[$prefix.'category']."</td>
                <td>".$detalle[$prefix.'description']."</td>
                <td>".$detalle[$prefix.'size']."</td>
                <td class='text-right'>".number_format($detalle['quantity'],2)."</td>
                <td class='text-right'>".number_format($detalle['price'],2)."</td>
                <td class='text-right'>".number_format($total,2)."</td>
                </tr>";
        }
        
        return array('requisitionDetails'=>$listDetalles,
                    'total'=>$totalTotal,
            );
    }
    
    public function getListRequisitionDetails($type, $tokenForm){
        $requisitionDetails = $this->getRequisitionDetails($type, $tokenForm);
        $detalles = $this->listRequisitionDetails($requisitionDetails,$type);
        
            $json = array(
                'response' => true,
                'requisitionDetails' => $detalles['requisitionDetails'],
                'grandTotal'=>$detalles['total'],
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $type = $options['type'];
        $repository = new SpecialRequisitionDetailsTempRepository();
        
        $current_data = $repository->getById($id);
        if($repository->delete($id)){
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        }else{
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        $requisitionDetails = $this->getRequisitionDetails($type, $current_data['token_form']);
        $detalles = $this->listRequisitionDetails($requisitionDetails,$type);
        
        $json = array(
                'response' => true,
                'requisitionDetails' => $detalles['requisitionDetails'],
                'grandTotal'=>$detalles['total']
            ); 
            return $json;
    }
    
    public function setSliceFlavor($options){
        $categoria = $options['category'];
        
        $repoSlices = new SliceRepository();
        $result = $repoSlices->getListSelectSlice($categoria);   
        
        $list = "<option value=''>".$this->_getTranslation('Seleccionar una opcion...')."</value>";        
        if($result){
            foreach($result as $key => $value){
                $list .= "<option value='$key'>". htmlentities($value)."</option>";
            }
        }        
        
        return array(
            'response'=>true,
            'listSlices'=>$list
        );
    }
    
    public function clearSpecialRequisitionDetails(){
        $repo = new SpecialRequisitionDetailsTempRepository();
        $repo->truncate();  
        
        return array('response'=>true);
    }
    
    public function getListProducts($options){
        $list = "<option value=''>Seleccionar una opcion...</value>";
        if($options['type'] == 'Line'){
            $repo = new ProductoRepository();
            $result = $repo->getListSelectProductos();
            foreach($result as $key => $value){
                $list .= "<option value='$key'>".utf8_encode($value)."</option>";
            }
        }
        
        /* IF type = special se regresa $list vacia porque esta se carga al momento de seleccionar categoria*/
        
        return array(
            'response'=>true,
            'listProducts'=>$list
        );
    }
    
    public function addPaymentToSpecialReq($options){
        $idReq = $options['idReq'];
        $repoSpecialReq = new SpecialRequisitionRepository();
        $dataSpecialReq = $repoSpecialReq->getById($idReq);
        $repoSpecialReq->setOptions($dataSpecialReq);
        
        $ventaRepo = new VentaRepository();
        $ventaRepo->crearTablaDetallesForUser();       
        $ventaRepo->crearTablaCobrosForUser();
        
        $ventaRepoTemp = new VentaDetallesTempRepository();
        $ventaRepoTemp->clearDetalles();
        
        $impuestosRepo = new ImpuestosRepository();
        $idImpuesto = 1;
        $dataImpuestos = $impuestosRepo->getById($idImpuesto);
        
        $ventaRepoTemp->save(array(
            'idProducto'=>'0',
            'descripcion'=>'Pago de orden especial: #'.$dataSpecialReq['req_number'], # Siemmpre debe llevar signo '#' porque lo uso en function isSpecialRequisition en PosAjax.php
            'cantidad'=>'1',
            'precio'=>$repoSpecialReq->getBalance(),
            'descuento_orden_tipo'=>'',
            'descuento_orden_valor'=>'',
            'descuento_orden_monto'=>'0',
            'descuento_item_tipo'=>'',
            'descuento_item_valor'=>'',
            'impuestos_incluidos'=>'no',
            'impuestos'=>$idImpuesto,
            'impuestos_tasa'=>$dataImpuestos['impuestos_tasa']
        ));
        
        return array(
            'response'=>true
        );       
    }
    
   public function changeStatus($options){
        $idReq = $options['id'];       
        $status = $options['status'];
        $field = $options['field'];
        
        $rs = $this->updateString(array($field=>$status), " id = '$idReq'");
        
        if($field == 'status_production'){
             $reqNumber = $options['req_number'];
            if($rs && $status == '1'){
                $btnStatus = "<span class='btn btn-sm btn-default' onclick='changeStatusForSR(this)' data-id='$idReq' data-reqnumber='$reqNumber' data-statusfield='status_production' data-status='2' data-statusname='Terminada'><i class='fa fa-star'></i> Pendiente</span>";
            }

            if($rs && $status == '2'){
                $btnStatus = "<span href='#' class='btn btn-sm btn-primary' onclick='changeStatusForSR(this)' data-id='$idReq' data-reqnumber='$reqNumber' data-statusfield='status_production' data-status='1' data-statusname='Pendiente'><i class='fa fa-star'></i> Terminada</span>";
            }   

            return array(
                'response'=>true,
                'btnStatus'=>$btnStatus
            );
        }
        
        if($field == 'status_delivery'){
            if($rs && $status == '2'){
                $this->descontarInventarioBySRId($idReq);
                $string = 'Entregada';
            }elseif($rs && $status == '1'){
                $this->agregarInventarioBySRId($idReq);
                 $string = 'Pendiente';
            }
            
            return array(
                'response'=>true,
                'string'=>$string
            );
        }       
        
        if($field == 'status_baked'){
            return array(
                'response'=>true
            );
        }
    }
    
    public function getCustomerData($options){
        $customerId = $options['id'];
        
        $repo = new ClienteRepository();
        $data = $repo->getById($customerId);
        $customerData = array(
            'customer'=>$data['id'],
            'company_name'=>$data['nombre_empresa'],
            'phone'=>$data['telefono'],
            'email'=>$data['correo'],
            'address'=>$data['calle'],
            'city'=>$data['ciudad'],
            
            'nombre'=>$data['nombre'],
            'nombre_empresa'=>$data['nombre_empresa'],
            'telefono'=>$data['telefono'],
            'correo'=>$data['correo'],
            'calle'=>$data['calle'],
            'ciudad'=>$data['ciudad'],
            
        );
        return array(
            'response'=>true,
            'customerData'=>$customerData
        );
    }
    
    public function getProductPrice($options){
        $type = $options['type'];
        $product = $options['product'];
        
        switch($type){
            case 'Line':
                $repo = new ProductoRepository();
                $data = $repo->getById($product);
                $price = $data['punitarioventa'];
                break;
            
            case 'Special':
                $repo = new SliceRepository;
                $data = $repo->getById($product);
                 $price = $data['price'];
                break;            
        }
        
        return array(
            'response'=>true,
            'price'=>$price
        );
    }
    
    public function deleteImage($options){
        $repo = new EntityRepository();
        $rs = $repo->delete($options['id'], 'images');
        
        if($rs){
            return array(
                'response'=>true
            );
        }
    }
    
     public function getImages($options) {
        $idReq = $options['idReq'];
        $entity = new SpecialRequisitionRepository();
        $entity->setOptions($entity->getById($idReq));
        $stringImages = $entity->showImagesForProductionAndBakedPlan();
        
        if($stringImages == null){$stringImages = "<h3 class='text-center'>No existen imagenes para esta Orden Especial</h3>";}
         
        return array(
            'response'=>true,
            'images'=>$stringImages
        );
    }
    
    public function getTotalSales($options){
        $salesRecord = new SpecialRequisitionRepository();
        $salesData = $salesRecord->getSpecialOrderByDateRange($options['start'],$options['end'],'store_id');
        
        $string = '';
        $totalSales = 0;
        $totalOrders = 0;
        $chartDataSales = array();
        $chartDataOrders = array();
        if($salesData){
            foreach($salesData as $sale){
                $totalSales += $sale['total_sales'];
                $totalOrders += $sale['total_orders'];
                $chartDataSales[$sale['store_name']] = number_format($sale['total_sales'],2,'.','');
                $chartDataOrders[$sale['store_name']] = number_format($sale['total_orders'],2,'.','');
                $string .= "<tr>";
                $string .= "<td class='text-center'>{$sale['store_name']}</td>";
                $string .= "<td class='text-center'>".number_format($sale['total_orders'],2)."</td>";
                $string .= "<td class='text-right'>$".number_format($sale['total_sales'],2)."</td>";
                $string .= "</tr>";
            }

            return array(
                'response'=>true,
                'salesData'=>$string,
                'caption'=>$this->_getTranslation('Pedidos')." ".$this->_getTranslation('de')." ".$options['start']." ".$this->_getTranslation('a')." ".$options['end'],
                'totalSales'=>number_format($totalSales,2,'.',''),
                'totalOrders'=>number_format($totalOrders,2,'.',''),
                'chartDataSales'=>$chartDataSales,
                'chartDataOrders'=>$chartDataOrders
            );
        }   
        
        return array('response'=>false);
    }
}