<?php
class ShipmentAjax extends ShipmentRepository {
    public $formShipment = null;
    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setShipmentDetails(array $options) {
        $data = array();
        foreach($options['options'] as $row){
            if(isset($row['value'])){
                $data[$row['name']] = $row['value'];
            }else{
                $data[$row['name']] = null;
            }
            
        }
       
        $options = $data;
        #Cuando se da enter en el campo producto del Shipment, el producto se busca por codigo, 
        #el valor del codigo ingresado se almacena en idProducto
        if(isset($data['byCode'])){            
            $result = $this->getProductoByCode($options['idProduct']);
            if($result){
                $options['idProduct'] = $result['id'];
            }else{
                $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
                return $json = array(
                    'response'=>null,
                    'message'=>$this->flashmessenger->getRawMessage());
            }            
        }
       
        $producto = $this->getProductById($options['idProduct']);
        if($producto){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_product'=>$producto['id'],
                'quantity'=>$options['quantity'],
                'token_form'=>$options['token_form']); /*Para cuenta de inventario*/
            
            $this->insertDetalle($data);
            $shipmentDetails = $this->getShipmentDetails($data['token_form']);
            $detalles = $this->listShipmentDetails($shipmentDetails);
            $json = array(
                'response' => true,
                'token_form'=>$data['token_form'],
                'shipmentDetails' => $detalles['shipmentDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
                'receivedItems'=>number_format($detalles['receivedItems'],2),
                'requiredItems'=>number_format($detalles['requiredItems'],2)
            );
            
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listShipmentDetails($detalles,$status = null){
        $disabled = null;
        $listDetalles = "";
        $cantidadItems = 0;
        $receivedItems = 0;
        $requiredItems = 0;
        
        if($status == '4'){$disabled = 'disabled';}
        
        foreach($detalles as $detalle){
            $cantidadItems += $detalle['quantity'];
            $receivedItems += $detalle['received'];
            
            $required = $detalle['min_stock'] - $detalle['real_stock_in_store'];
            if($required > 0){$requiredItems += $required;} 
            
            $id = $detalle['id'];
            unset($detalle['id']);
            
            $array = json_encode($detalle);
            $listDetalles .= "<tr>  
                <td class='text-left'>                       
                    <a class='btn btn-sm btn-primary $disabled' onclick='setDetailShipmentToEdit($array);'><i class='fa fa-pencil'></i></a>
                </td>
                <td class='text-center'>".$detalle['code']."</td>
                <td>".$detalle['description']."</td>
                <td>".$detalle['size']."</td>
                <td class='text-right'>".number_format($detalle['min_stock'],2)."</td> 
                <td class='text-right'>".number_format($detalle['real_stock_in_store'],2)."</td> 
                <td class='text-right'>".number_format($required,2)."</td>
                <td class='text-right'>".number_format($detalle['quantity'],2)."</td> 
                <td class='text-right'>".number_format($detalle['received'],2)."</td>
                </tr>";
        }
        
        return array('shipmentDetails'=>$listDetalles,
                    'totalItems'=>$cantidadItems,
                    'receivedItems'=>$receivedItems,
                    'requiredItems'=>$requiredItems
            );
    }
    
    public function getListShipmentDetails($status = null, $tokenForm){
        $shipmentDetails = $this->getShipmentDetails($tokenForm);
        $detalles = $this->listShipmentDetails($shipmentDetails,$status);
            $json = array(
                'response' => true,
                'shipmentDetails' => $detalles['shipmentDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
                'receivedItems'=>number_format($detalles['receivedItems'],2),
                'requiredItems'=>number_format($detalles['requiredItems'],2)
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $repository = new ShipmentDetailsTempRepository();
        $current_data = $repository->getById($id);
        
        if($repository->delete($id)){
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        }else{
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        
        $shipmentDetails = $this->getShipmentDetails($current_data['token_form']);
        $detalles = $this->listShipmentDetails($shipmentDetails);

        $json = array(
                'response' => true,
                'shipmentDetails' => $detalles['shipmentDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
                'receivedItems'=>number_format($detalles['receivedItems'],2),
                'requiredItems'=>number_format($detalles['requiredItems'],2)
            ); 
            return $json;
    }
}