<?php
class RequisitionAjax extends RequisitionRepository {
    public $formProduct = null;
    public $formRequisition = null;
    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setRequisitionDetails(array $options) {
        $data = array();
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }

        $options = $data;
        
        $producto = $this->getProductById($options['product']);
        if($producto){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_product'=>$producto['id'],
                'quantity'=>$options['quantity']); /*Para cuenta de inventario*/

            $this->insertDetalle($data);
            $requisitionDetails = $this->getRequisitionDetails();
            $detalles = $this->listRequisitionDetails($requisitionDetails);

            $json = array(
                'response' => true,
                'requisitionDetails' => $detalles['requisitionDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2)
            );
            
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listRequisitionDetails($detalles){
        $listDetalles = "";
        $cantidadItems = 0;
        
        foreach($detalles as $detalle){
            $cantidadItems += $detalle['quantity'];

            $id = $detalle['id'];
            unset($detalle['id']);
            $array = json_encode($detalle);
            $listDetalles .= "<tr>  
                <td class='text-center'>                       
                    <a class='btn btn-sm btn-primary' onclick='setDetailRequisitionToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteRequisitionDetails($id);'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['code']."</td>
                <td class='text-center'>".$detalle['description']."</td>
                <td class='text-center'>".$detalle['size']."</td>
                <td class='text-right'>".number_format($detalle['quantity'],2)."</td> 
                </tr>";
        }
        
        return array('requisitionDetails'=>$listDetalles,
                     'totalItems'=>$cantidadItems
            );
    }
    
    public function getListRequisitionDetails(){
        $requisitionDetails = $this->getRequisitionDetails();
        $detalles = $this->listRequisitionDetails($requisitionDetails);

            $json = array(
                'response' => true,
                'requisitionDetails' => $detalles['requisitionDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2)
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $repository = new RequisitionDetailsTempRepository();
        
        if($repository->delete($id)){
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        }else{
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        
        $requisitionDetails = $this->getRequisitionDetails();
        $detalles = $this->listRequisitionDetails($requisitionDetails);

        $json = array(
                'response' => true,
                'requisitionDetails' => $detalles['requisitionDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2)
            ); 
            return $json;
    }
    
    public function changeStatus($options){
        $idReq = $options['id'];
        $status = $options['status'];
        $field = $options['field'];
        
        $this->updateString(array($field=>$status), " id = '$idReq'");
        
        return array(
            'response'=>true
        );
    }
    
    public function createWorkOrderFromInventoryReport($options){
        $workOrder = $options['wordOrder'];
        if(trim($workOrder) != ''){                        
            $entityRepository = new EntityRepository();
            
            #Save Requisition
            $login = new Login();
            $repoRequisition = new RequisitionRepository();
            $data = array(
                'date'=>date('Y-m-d'),
                'status'=>'1',
                'status_baked'=>'1',
                'comments'=>'Creado desde reporte de inventarios por sucursal',
                'creado_por'=>$login->getId(),
                'creado_fecha'=>date('Y-m-d H:i:s')
                );
            
            $entityRepository->startTransaction();
            $result = $entityRepository->save($data,'requisitions');    
            if($result){
                $idRequisition = $entityRepository->getInsertId();
                $reqNumber = $repoRequisition->createReqNumber($idRequisition);
                $entityRepository->update($idRequisition, array('req_number'=>$reqNumber), 'requisitions');            

                #Save requisition details
                $settings = new SettingsEntity();
                $store_id = $settings->_get('store_default_production');
                
                $inventory = new InventarioEntity();         
                $workOrder = unserialize($workOrder);   
                
                foreach($workOrder as $idProduct => $quantity){
                    #Obtenemos es stock en Almacen para $idProduct
                    $stock = $inventory->getInventorySucursalByIdProduct($idProduct,$store_id); /*$store_id = sucursal que funciona como almacen */
                    
                    #Si el stock es menor a la cantidad solicitada, se tiene que producir la diferencia $quantity - $stock
                    #Si el stock es mayor a la cantidad solicitada, no se debe producir mas producto.
                    if($stock != null && $stock['stock'] < $quantity){                        
                        //$quantity = $quantity - $stock; /*Fabiola pidio que no se debe restar inventaio en stock; lo pidio el 20/may/2021 */
                        $data = array(
                        'id_requisition'=>$idRequisition,
                        'id_product'=>$idProduct,
                        'quantity'=>$quantity
                        );

                        if(!$entityRepository->save($data, 'requisitions_details')){
                            $entityRepository->rollback();
                            return array(
                                'response'=>null
                            );
                        }
                    }                  
                }
                $entityRepository->commit();
                return array(
                    'response'=>true,
                    'idRequisition'=>$idRequisition
                );
            }else{
                $entityRepository->rollback();
                 return array(
                    'response'=>null
                );
            }            
        }else{
            return array(
                'response'=>null
            );
        }       
    }
}