<?php

    #Para listar total de ventas agrupado por forma de pago
    $ventasPorFormaDePagoTemp = $data['ventasPorFormaDePago'];
    foreach($ventasPorFormaDePagoTemp as $row){
        $impuestos = $row['impuestos'];
        $newArray = $row;
        foreach($impuestos as $key => $impuesto){            
            $newArray[$key.'-subtotal'] = $impuesto['subTotal'];
            $newArray[$key] = $impuesto['montoImpuesto'];
        }
        $ventasPorFormaDePago[] = $newArray;
    }
    //echo "<pre>";var_dump($ventasPorFormaDePago);echo "</pre>";exit;
    $fieldsToPrint_ventasPorFormaDePago = array(
        'formaPago'=>'Forma de pago',
        'total'=>'Total'
    );
    
    foreach($impuestos as $key => $impuesto){        
        $fieldsToPrint_ventasPorFormaDePago[$key.'-subtotal'] = "Subtotal\n sujeto a ".$impuesto['nombre'];
        $fieldsToPrint_ventasPorFormaDePago[$key] = $impuesto['nombre'];
    }
    
    $colTitulosTemp = $ventasPorFormaDePago[0];     
    foreach($fieldsToPrint_ventasPorFormaDePago as $titulo => $value){
        if(key_exists($titulo, $colTitulosTemp)){            
            $colTitulos[] = $fieldsToPrint_ventasPorFormaDePago[$titulo];
        }
    }     
    
    #Para listar ventas
    $arrayData = $data['data']['data'];  
    $ventaInicio = $arrayData[0]['idVenta'];
    $lastElement = count($arrayData);
    $ventaFin = $arrayData[$lastElement-1]['idVenta'];
    
    $colTitulosVentasTemp = $arrayData[0];    
    $fieldsToPrint_ventas = array(
        'idVenta'=>'Venta',
        'fecha'=>'Fecha',
        'formaPagoConcat'=>'Forma de pago',
        'subTotal'=>'Subtotal',
        'descuento'=>'Descuento');
    
    foreach($impuestos as $key => $impuesto){
        $fieldsToPrint_ventas[$key] = $impuesto['nombre'];
    }
    
    $fieldsToPrint_ventas['devoluciones'] = 'Devoluciones';
    $fieldsToPrint_ventas['total'] = 'Total';
    $fieldsToPrint_ventas['statusName'] = 'Status';
    $fieldsToPrint_ventas['usuarioName'] = 'Cajero';
    
    foreach($fieldsToPrint_ventas as $titulo => $value){
        if(key_exists($titulo, $colTitulosVentasTemp)){            
            $colTitulosVentas[] = $fieldsToPrint_ventas[$titulo];
        }
    }
    
    $colParaVentas = count($colTitulosVentas);  
    
    $objPHPExcel = new PHPExcel();
    $objPHPExcel->getActiveSheet()->freezePane('A2');
    $col = count($colTitulos);
    $lastCol = $this->getColLetter($col-1);
    $lastColParaMerge = $this->getColLetter($colParaVentas - 1);
    
    $objPHPExcel->getActiveSheet()->mergeCells("A1:".$lastColParaMerge."1");            
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(50);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue("A1", $this->headerExcelReport);
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    
    $objPHPExcel->getActiveSheet()->getStyle("A2:B2")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
    $objPHPExcel->getActiveSheet()->getStyle("A2:B2")->getFill()->getStartColor()->setARGB('E0E0E0');      
    $objPHPExcel->getActiveSheet()->getStyle("A2:B2")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    
    $objPHPExcel->getActiveSheet()->setCellValue("A2",'Venta inicio');
    $objPHPExcel->getActiveSheet()->setCellValue("B2", 'Venta fin'); 
    $objPHPExcel->getActiveSheet()->setCellValue("A3",$ventaInicio);
    $objPHPExcel->getActiveSheet()->setCellValue("B3", $ventaFin); 
    
    $objPHPExcel->getActiveSheet()->getStyle("A5:".$lastCol."5")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
    $objPHPExcel->getActiveSheet()->getStyle("A5:".$lastCol."5")->getFill()->getStartColor()->setARGB('E0E0E0');      
    $objPHPExcel->getActiveSheet()->getStyle("A5:".$lastCol."5")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->fromArray($colTitulos,NULL,'A5');    
    
    $row=6;
    foreach ($ventasPorFormaDePago as $key => $data) {
        $i=0;     
        foreach ($data as $col => $value) {             
            if(key_exists($col, $fieldsToPrint_ventasPorFormaDePago)){ 
                $col = $this->getColLetter($i);
                $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $value);
                $objPHPExcel->getActiveSheet()->getStyle("B$row:F$row")->getNumberFormat()->setFormatCode('$#,##0.00_ ;[Red]-$#,##0.00');
                $i++;
            }
        }
        $row++;
    }
    
    $row++;
    $lastCol = $this->getColLetter($colParaVentas - 1);
    $objPHPExcel->getActiveSheet()->getStyle("A$row:".$lastCol."$row")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
    $objPHPExcel->getActiveSheet()->getStyle("A$row:".$lastCol."$row")->getFill()->getStartColor()->setARGB('E0E0E0');      
    $objPHPExcel->getActiveSheet()->getStyle("A$row:".$lastCol."$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->fromArray($colTitulosVentas,NULL,"A$row");    
    
    $row++;
    $rowVenta = 1;
    $countVentas = count($arrayData);
    
    foreach ($arrayData as $key => $data) {
        $i=0;                     
        foreach ($fieldsToPrint_ventas as $col => $value) {              
            if(key_exists($col, $data)){ 
                $value = $data[$col];
                $col = $this->getColLetter($i);
                $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $value);
                $objPHPExcel->getActiveSheet()->getStyle("C$row:H$row")->getNumberFormat()->setFormatCode('$#,##0.00_ ;[Red]-$#,##0.00');
                $objPHPExcel->getActiveSheet()->getStyle("A$row:B$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $objPHPExcel->getActiveSheet()->getStyle("I$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                $i++;
            }
        }
        $row++;
    }  

    foreach(range('A',$lastCol) as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
            ->setAutoSize(true);
    }

    $objPHPExcel->setActiveSheetIndex(0);   
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    
    if($this->saveFile == true){
        $objWriter->save($this->getTempFolder()."/".$this->getNombreArchivo().".xlsx");
    }else{                
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment;filename=".$this->getNombreArchivo().".xlsx");
        header('Cache-Control: max-age=0');
        $objWriter->save('php://output');
        exit;
    }
    unset($objWriter);