<?php
/**
 * Description of ClienteForm
 *
 * @author carlos
 */
class ProductionForm extends Form {

    public function __construct() {
        $this->setActionForm('Production.php');
        $this->setName('production');
        $this->setMethod('post');
        $this->setClass('production');     
        $this->setDefaultFormLabelsColSize('4');
        $this->setDefaultFormElementsColSize('8');
        parent::__construct();
        $this->init();
    }

    public function init() {    
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'id_load_line',
            'label'=>'Linea / Orden de trabajo',
            'multiOptions'=>$this->getListLoadLines(),
            'optionals'=>array('onchange'=>"submit('production')"),
            'required'=>false,        
            'col-size-label'=>'5',
            'col-size-element'=>'7'
        ));          
        
       $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'required'=> false,
            'col-size-element'=>'12',
            'optionals'=>array('style'=>'height:50px;text-align:center;font-size:24px'),
            'class'=>'numPad'
        ));      
       
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_product',
        ));   
        
        /*Para editar registro de produccion*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_detail',
        )); 
        
         /*Para editar registro en requisitions o special_requisitions depende de type para seleccionar la tbl*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_requisition',
        )); 
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'type',
        ));
        
         /*Para editar registro en production */
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'req_number',
        ));
        
        
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'btnSaveProduction',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-primary',
            'optionals'=>array('onClick'=>'saveProduction()')
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'close',
            'value'=>$this->_getTranslation('Cerrar'),
            'class'=>'btn btn-default',
            'optionals'=>array(
                'data-dismiss'=>'modal',
                'aria-label'=>'Close'
            )
        ));
    }
    
    public function getListLoadLines(){
        $repository = new LoadLineRepository();
        $result = $repository->getListSelectLoadLines();
       
       if(count($result)>0){ $array = array(''=>'Seleccionar una opcion...');}
        if ($result) {               
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }   
    
    public function populate($data) {
        parent::populate($data);
    }
}