<?php
class VentaEntity extends VentaRepository{
    private $options = array (
        'id'=>null,
        'num_venta'=>0,
        'fecha' => null,
        'telefono'=>null,
        'cliente' => null,
        'importe'=>null,
        'descuento_orden_tipo'=>null,
        'descuento_orden_valor'=>null,
        'descuento_orden_monto'=>null,
        'descuento_items_monto'=>null,
        'subtotal'=>null,
        'total_impuestos'=>null,
        'total_venta'=>null,
        'total_recibido'=>null,
        'status'=>null,        
        'metodo_pago'=>null,
        'id_special_requisition'=>null,
        'comentarios'=>null,
        'idCaja'=>null,
        'idSucursal'=>null,
        'status'=>null,        
        'creado_fecha'=>null,
        'creado_por'=>null,
        'modificaciones'=>null,        
        'cambio'=>null #lo utilizo como auxiliar, lo elimino en repository para no inertalo en la tabla, no lo pongo en options_aux porque lo necesito tener en getOptions para enviarlo a savePos en repository
     );
    
    private $options_aux = array(
        'clienteName'=>null,
        'usuarioName'=>null,
        'FormaPagoName'=>null
    );
    private $comentariosTemp = null; //comentario nuevo que se agrega
    private $optionsInfoPago = array(
        'cuenta_contable'=>null,
        'metodo_pago'=>null,
        'fecha_pago'=>null
    );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }

        #$this->setComentarios($data);
    }

    public function getOptions(){
        return $this->options;
    }    
    
    public function getNumVenta(){
        return $this->options['num_venta'];
    }    
    
    public function setComentariosTemp($comentariosTemp){
        $this->comentariosTemp = $comentariosTemp;
    }
    
    public function setUsuario(){
        $login = new Login();
        $this->options['usuario'] = $login->getId();
    }
    
    public function getNombreCliente(){        
        return $this->options_aux['clienteName'];
    }
    
    public function getUsuarioName(){        
        return $this->options_aux['usuarioName'];
    }
    
    public function getFormaPagoName(){
        return $this->options_aux['FormaPagoName'];
    }
    
    public function getFecha(){
        return $this->options['fecha'];
    }
    
    public function getFechaPago(){
        return $this->optionsInfoPago['fecha_pago'];
    }
    
    public function getMetodoPago(){
        return $this->optionsInfoPago['metodo_pago'];
    }
    
    public function getId() {
       return $this->options['id'];
    }
    
    public function getStatus() {
       return $this->options['status'];
    }
    
    public function getCliente() {
       return $this->options['cliente'];
    }
    
    public function getTotalRecibido(){
        return $this->options['total_recibido'];
    }
    
     public function getFechaCreacion() {
       return $this->options['creado_fecha'];
    }
    
    public function getSpecialRequisitionId(){
        return $this->options['id_special_requisition'];
    }
    
    public function getClienteInfoComplete(){
        $cliente = new ClienteRepository();
        
        return $cliente->getById($this->options['cliente']);
    }
    
    public function getListaFormaPago(){
        $repo = new FormaMetodoPagoRepository();
        return $repo->getListFormasPago();
    }
}