<?php
class StoreInEntity extends StoreInRepository{
    private $options = array (
        'id'=>null,
        'date' => null,
        'requested_by'=>null,
        'approved_by'=>null,
        'vendor'=>null,
        'reference' => null,
        'lot' => null,
        'method_payment'=>null,
        'credit_days'=>null,
        'due_date'=>null,
        'credit_note'=>null,
        'credit_note_amount'=>null,
        'compra_descuento'=>null,
        'compra_subtotal'=>null,
        'compra_iva'=>null,
        'compra_ieps'=>null,
        'total'=>null,
        'payments'=>null,
        'comments'=>null,
        'status'=>null,
        'invoice_file'=>null);
    
    private $options_aux = array(
        'vendorName'=>null,
        'userName'=>null,
        'statusName'=>null,
        'methodPaymentName'=>null,
        'formatedDueDate'=>null,
        'formatedDate'=>null
    );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }
    
    public function getVendorName(){        
        return $this->options_aux['vendorName'];
    }
    
    public function getMethodPaymentName(){        
        return $this->options_aux['methodPaymentName'];
    }
    
    public function getRequestedBy(){        
        return $this->options['requested_by'];
    }
    
     public function getApprovedBy(){        
        return $this->options['approved_by'];
    }
    
    public function getCreditDays(){        
        return $this->options['credit_days'];
    }
    
    public function getUserName(){        
        return $this->options_aux['userName'];
    }
    
    public function getStatusName(){        
        return $this->options_aux['statusName'];
    }
    
    public function getDate(){
        return $this->options['date'];
    }
    
    public function getFormatedDate(){
        return $this->options_aux['formatedDate'];
    }
    
    public function getFormatedDueDate(){
        return $this->options_aux['formatedDueDate'];
    }
    
    public function getVendor(){
        return $this->options['vendor'];
    }
    
    public function getReference(){
        return $this->options['reference'];
    }
    
    public function getLot(){
        return $this->options['lot'];
    }
    
    public function getCompraDescuento(){
        return $this->options['compra_descuento'];
    }
    
    public function getCompraSubtotal(){
        return $this->options['compra_subtotal'];
    }
    
    public function getCompraIVA(){
        return $this->options['compra_iva'];
    }
    
    public function getCompraIEPS(){
        return $this->options['compra_ieps'];
    }
    
    public function getTotal(){
        return $this->options['total'];
    }
    
    public function getComments(){
        return $this->options['comments'];
    }
    
    public function getStatus(){
        return $this->options['status'];
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getId() {
       return $this->options['id'];
    }
    
    public function getVendorInfoComplete(){
        $proveedor = new VendorRepository();        
        return $proveedor->getById($this->options['vendor']);
    }
    
    public function getSaldoPendiente(){
        return $this->options['total'] - $this->options['payments'];
    }
    
  
    public function paginationExcel($options){
      $proveedor = null;
      $reference = null;
      $status = "";
      $fecha= $this->createFilterFecha($options, 'c.date');
      
      if(isset($options['vendor'])!='' && $options['vendor']!= null ){$proveedor = " AND c.vendor = '".$options['vendor']."'";}
      if(isset($options['id_store_in']) && $options['id_store_in']!='' && $options['id_store_in']!= null ){$reference = "AND c.id = '".$options['id_store_in']."'";}
      if(isset($options['showCancel'])){$status = null;}
          
      $query = "SELECT c.id as '".$this->_getTranslation('#Entrada')."',
                DATE_FORMAT(c.date,'%b-%d-%Y')as '".$this->_getTranslation('fecha')."',                    
                fxGetVendorName(c.vendor) as '".$this->_getTranslation('proveedor')."',
                c.reference as '".$this->_getTranslation('Referencia')."',
                fxGetStatusName(c.`status`,'status','storeIn')as '".$this->_getTranslation('status')."'               
                FROM store_in c
                LEFT JOIN store_in_detalle d ON c.id = d.id_store_in
                WHERE  1=1
                $proveedor  
                $reference
                $fecha
                $status" 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";

      $result = $this->query($query);
      if($result->num_rows > 0){
          return $this->resultToArray($result);
      }

      return null;   
  }
}