<?php
class SpecialRequisitionDetailsTempRepository extends EntityRepository {

    private $table = 'special_requisitions_details_';
    public $flashmessenger = null;
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
        
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                return parent::update($id, $data,$this->table);
            }
         }
        
        unset($data['idDetailTemp']);        
        $query = "SELECT id,quantity FROM ".$this->table.
                 " WHERE id_product = '".$data['id_product']."' AND price = '".$data['price']."' AND token_form = '{$data['token_form']}' "
              . " AND type = '{$data['type']}' "
              . " AND multiple = '{$data['multiple']}' " ;
        
        $result = $this->query($query); 
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['quantity'] = $data['quantity'] + $result->quantity;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            return parent::save($data, $this->table);
        }
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idRequisition,$reqNumber, $tokenForm){
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            
            foreach($result as $data){
                unset($data['id'], $data['id_detail'], $data['token_form']);
                
                $data['id_requisition'] = $idRequisition;
                $data['req_number'] = $reqNumber;
                
                parent::save($data, 'special_requisitions_details');
            }   
            /*
            if(!$this->saveSupplies($idRequisition,$reqNumber)){
                return null;
            }*/
            return true;
        }else{
            $this->flashmessenger->addMessage(array('danger'=>'Debes ingresar almenos un producto para guardar la Requisicion.'));
            return null;
        }
        
    } 
    
    public function updateDetalles($idRequisition,$reqNumber, $tokenForm){
        $query = "SELECT id FROM special_requisitions_details WHERE id_requisition = '$idRequisition'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        $idsDetalles = array();

        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $idDetalle = $data['id_detail'];
                unset($data['id'],$data['id_detail'],$data['token_form']);
                $data['id_requisition'] = $idRequisition;
                $data['req_number'] = $reqNumber;
              
                if(!$idDetalle){
                    parent::save($data, 'special_requisitions_details');
                }else{
                    #contiene los idDetalles de la requisicion original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle,$data, 'special_requisitions_details');         
                }  
            }
        }

        #Se eliminan ids de tabla requisition_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la requisicion despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    parent::delete($detalle['id'], 'special_requisitions_details');
                }
            }
        }  
        /*
        if(!$this->updateSupplies($idRequisition,$reqNumber)){
            return null;
        }*/
        
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    public function saveSupplies($idRequisition,$reqNumber){        
	 /*Para registros de insumos requeridos*/
          #cuando es de linea se multiplica qty de product_details
          #cuando es special no se multiplica slices_details
        $query = "SELECT t.id_supplie,SUM(quantity)as quantity,t.category FROM(
                    select sd.id_supplie, rd.quantity * pd.quantity * sd.quantity as quantity,s.category
                            from special_requisitions_details rd, products_details pd, slices_details sd, slices s
                            where rd.id_product = pd.id_product
                            and pd.id_slice = sd.id_slice
                            and sd.id_slice = s.id
                            and rd.id_requisition = '$idRequisition'
                            and rd.`type` = 'Line'
                            group by sd.id_supplie,s.category
                    UNION
                    select sd.id_supplie, rd.quantity * sd.quantity as quantity,s.category
                            from special_requisitions_details rd, slices_details sd, slices s
                            where s.id = rd.id_product
                            and sd.id_slice = s.id
                            and rd.id_requisition = '$idRequisition'
                            and rd.`type` = 'Special'
                            group by sd.id_supplie,s.category 
                    ) as t
                  group by t.id_supplie,t.category 
            ";
        $result = $this->query($query);
        
        if($result->num_rows >0){
            $result = $this->resultToArray($result);
            foreach($result as $row){
                $data = array(
                    'req_number'=>$reqNumber,
                    'type'=>'Line',
                    'id_supplie'=>$row['id_supplie'],
                    'slice_category'=>$row['category'],
                    'quantity'=>$row['quantity']
                );
                
                $rs = parent::save($data, 'requisitions_details_supplies');
                if(!$rs){
                    return null;
                }
            }
        }
        return true;
    }
    
    public function updateSupplies($idRequisition,$reqNumber){       
        $query = "SELECT *,CONCAT(id_supplie,slice_category)as idsupplie_idcategory "
                . "FROM requisitions_details_supplies "
                . "WHERE req_number = '$reqNumber'";
        $result = $this->query($query);
        $suppliesOrigin = null;    
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            foreach($result as $row){
                $key = $row['idsupplie_idcategory'];
                unset($row['idsupplie_idcategory']);
                $suppliesOrigin[$key] = $row;
            }
        }
        
        $query = "SELECT t.id_supplie,t.idsupplie_idcategory,t.req_number,SUM(quantity)as quantity,t.slice_category FROM(
                    select sd.id_supplie,CONCAT(sd.id_supplie,'-',s.category)as idsupplie_idcategory, '$reqNumber'as req_number, SUM(rd.quantity * pd.quantity * sd.quantity) as quantity,s.category as slice_category
                            from special_requisitions_details rd, products_details pd, slices_details sd, slices s
                            where rd.id_product = pd.id_product
                            and pd.id_slice = sd.id_slice
                            and sd.id_slice = s.id
                            and rd.id_requisition = '$idRequisition'
                            and rd.`type` = 'Line'
                            group by sd.id_supplie,s.category
                    UNION
                    select sd.id_supplie,CONCAT(sd.id_supplie,'-',s.category)as idsupplie_idcategory, '$reqNumber'as req_number, SUM(rd.quantity * sd.quantity) as quantity,s.category as slice_category
                            from special_requisitions_details rd, slices_details sd, slices s
                            where s.id = rd.id_product
                            and sd.id_slice = s.id
                            and rd.id_requisition = '$idRequisition'
                            and rd.`type` = 'Special'
                            group by sd.id_supplie,s.category 
                    ) as t
                  group by t.idsupplie_idcategory ";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $idSupplie = $data['idsupplie_idcategory'];
                unset($data['id'],$data['idsupplie_idcategory'],$data['delivery'],$data['returned']);
              
                if(!key_exists($idSupplie, $suppliesOrigin)){
                    $data['type'] = 'Special';
                    parent::save($data, 'requisitions_details_supplies');
                }else{
                    #contiene los idDetalles de la requisicion original que se mantendran, lo que no esten aqui se eliminaran.                    
                    $idDetalle = $suppliesOrigin[$idSupplie]['id'];
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle,$data, 'requisitions_details_supplies');         
                }  
            }
        }

        #Se eliminan ids de tabla requisition_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la requisicion despues del update)                
        if($suppliesOrigin){
            foreach ($suppliesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    parent::delete($detalle['id'], 'requisitions_details_supplies');
                }
            }
        }
        return true;
    }
    
    
    public function truncate($tokenForm){
        $query = "DELETE FROM ".$this->table." WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function setRequisitionDetailsById($idRequisition, $tokenForm){
        $query = "INSERT INTO ".$this->table." (id_detail,token_form,id_requisition,type,id_product,quantity,multiple,price)
                    SELECT id,'$tokenForm',id_requisition,type,id_product,quantity,multiple,price
                    FROM special_requisitions_details WHERE id_requisition = '$idRequisition'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null) {
        if(isset($data['id_requisition'])){
            if($data['id_requisition']=='' || !$data['id_requisition']){
                unset($data['id_requisition']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}