<?php
class ShipmentRepository extends EntityRepository {

    private $table = 'stores_shipments';
    public $flashmessenger = null;
    
    private $options = array (
        'id_store_request'=>null,
        'num_shipment'=>null,
        'date'=>null,
        'to_store' => null,
        'from_store' => null,
        'comments'=>null,
        'status'=>null,
        'receiving_date'=>null,
        'receiving_comments'=>null,
        'last_sinc'=>null);
    
    private $options_aux = array(
        'dateReceivingFormated'=>null,
        'dateFormated'=>null,
        'statusName'=>null,
        'userName'=>null,
        'token_form'=>null
    );
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
  
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getTokenForm(){
        return $this->options_aux['token_form'];
    }
    
     public function getNumShipment() {
       return $this->options['num_shipment'];
    }
    
    public function getTableName(){
        return $this->table;
    }
    
    public function getStatus() {
       return $this->options['status'];
    }
    
    public function getUserName(){
        return $this->options_aux['userName'];
    }
    
    public function getStatusName(){
        return $this->options_aux['statusName'];
    }
    
    public function getDate() {
       return $this->options['date'];
    }
    
    public function getToStore() {
       return $this->options['to_store'];
    }
    
    public function getFromStore() {
       return $this->options['from_store'];
    }
    
    public function getReceivingDateFormated() {
       return $this->options_aux['dateReceivingFormated'];
    }
    
    public function getDateFormated() {
       return $this->options_aux['dateFormated'];
    }
    
    public function getComments(){
        return $this->options['comments'];
    }
    
    public function getReceivingComments(){
        return $this->options['receiving_comments'];
    }
    
    public function getFormatDate(){
        $date = substr($this->getDate(), 0, 10);
        $date = strftime('%d/%m/%Y',  strtotime($date));
        return $date;
    }
    
    public function save(array $data, $table = null) {             
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateTimeToDB($data['date']);       
        $data['status'] = '1';
        unset($data['receiving_date']);    
       
        try{
            $this->startTransaction(); 
            unset($data['num_shipment'],$data['last_sinc']);
            parent::save($data, $this->table);        

            $storeInDetailsTemp = new ShipmentDetailsTempRepository();
            $idShipment = $this->getInsertId();
            $this->setLastInsertId($idShipment);//Para utilizarlo en el Controller action insert

            $numShipment = $this->getPrefixNumberShipment().str_pad($idShipment, 7, '0', STR_PAD_LEFT);
            $this->updateString(array('num_shipment'=>$numShipment), " id = '$idShipment' ");

            if($storeInDetailsTemp->saveDetalles($idShipment,$data['from_store'], $this->getTokenForm())){
                $this->commit();
                $storeInDetailsTemp->truncate($this->getTokenForm());

                return true;
            }
        } catch (Exception $ex) {
            $this->rollback();    
            $this->flashmessenger->addMessage(array(
                'danger'=>$ex->getMessage()));
            return null;   
        }           
    }  
    
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status']== '4'){return true;}
        
        $this->startTransaction();
        $rs = parent::update($id, array('status'=>'4'), $this->table);
        if($rs){
            $detallesAfectados = $this->getShipmentDetailsSaved($id);
            if(!$this->addInventoryFromShipmentDetalles($detallesAfectados,$currentData['from_store'])){
                $this->rollback();
                return null;
            }      
            
            $this->commit();
            return true;
        }
        $this->rollback();
        return null;
    }
    
    public function update($id, $data, $table = null) {              
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateTimeToDB($data['date']);       
        unset($data['status'],$data['receiving_date'],$data['last_sinc']);
        
        $this->startTransaction();
        $result = parent::update($id, $data, $this->table);
 
        if($result){
            $repository = new ShipmentDetailsTempRepository();
            if($repository->updateDetalles($id,$data['from_store'], $this->getTokenForm())){
                $this->updateStatus($id);
                $this->commit();
                $repository->truncate($this->getTokenForm());
                return true;               
            }
        }        
        $this->rollback();
        return null;
    }
    
    public function updateStatus($id){
        $query = "SELECT SUM(quantity)as quantity, SUM(received)as received "
                . "FROM stores_shipments_details "
                . "WHERE id_shipment = '$id' ";
        
        $result = $this->query($query);
      
        if($result){           
           $result = $result->fetch_object();
           
           if($result->received === NULL || $result->received == '0'){              
               $status = '1';
           }elseif($result->received >= $result->quantity){
               $status = '2';
           }elseif($result->received < $result->quantity){
               $status = '3'; 
           }
           
           return $this->updateString(array('status'=>$status), " id = '$id' ");
        } 
        return true;        
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%d/%m/%Y %r')as dateFormated,"
                . "DATE_FORMAT(receiving_date,'%d/%m/%Y %r')as dateReceivingFormated,"
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetStatusName(status,'status','Shipment')as statusName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('store-out' => 'requisition'));
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        
        $query = "CREATE TABLE IF NOT EXISTS stores_shipments_details_".$login->getId()." 
                 (  
                    `token_form` char(50) NOT NULL,
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_shipment` int(11) NULL,
                    `id_product` int(11) NOT NULL,
                    `min_stock` double  NULL,
                    `real_stock_in_store` double NULL,
                    `quantity` double NOT NULL,
                    `received` double  NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $storeInDetailsTemp = new ShipmentDetailsTempRepository();
        return $storeInDetailsTemp->save($data);
    }
    
      public function getShipmentDetails($token_form){
        $login = new Login();
        $query = "SELECT 
                v.*, 
                v.id AS idDetailTemp, 
                p.id AS product, 
                p.codigo AS code, 
                p.descripcion AS description, 
                fxGetCategoriaDescripcion(p.categoria) AS category, 
                fxGetTamanoDescripcion(p.tamano) AS size
                FROM stores_shipments_details_".$login->getId()." v LEFT JOIN productos p ON v.id_product = p.id
                WHERE v.token_form = '$token_form' ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }        
        return null;
    }
    
    public function getShipmentDetailsSaved($id){
        $query = "SELECT c.*,
                    p.codigo as code,
                    p.descripcion as description,
                    fxGetTamanoDescripcion(p.tamano)as size
                    FROM stores_shipments_details c LEFT JOIN productos p ON c.id_product = p.id
                    WHERE c.id_shipment = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getProductoByCode($code){
        $repo = new ProductoRepository();
        return $repo->getByCode($code);
    }
    
    public function setShipmentDetailsById($idCompra, $tokenForm){
        $repository = new ShipmentDetailsTempRepository();
        
        return $repository->setShipmentDetailsById($idCompra, $tokenForm);
    }
    
    public function truncateIfIsEditInfo(){
        $repository = new ShipmentDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
        
    }
    
    public function getProductById($idProducto){
        $query = "SELECT * FROM productos WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    public function getListShipments($options = null){  
        $limit = " LIMIT 100 ";
        $query = "SELECT r.*,
                fxGetStoreName(r.to_store) as toName,
                SUM(d.quantity)as quantity,
                IFNULL(SUM(d.received),'0')as received,
                DATE_FORMAT(r.date,'%d/%m/%Y')as date,
                fxGetStatusName(r.`status`,'status','Shipment')as statusName,
                fxGetUserName(r.creado_por) as user
                FROM stores_shipments r LEFT JOIN stores_shipments_details d ON r.id = d.id_shipment "
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC $limit ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
  public function getPrefixNumberShipment(){
      $settings = new SettingsEntity();
      $prefix = $settings->_get('prefix_for_shipments');
      if($prefix){
          return $prefix;
      }
      return '';
  }
  
    /*PARA CONTROL DE INVENTARIOS*/
    public function addInventoryFromShipmentDetalles($detallesAfectados,$idSucursal){
        $repoInventario = new InventarioRepository();         

        $array = array();
        foreach($detallesAfectados as $detalle){         
            $row = array(
                        'id_product'=>$detalle['id_product'],
                        'quantity'=>$detalle['quantity'],
                        'idSucursal'=>$idSucursal
                    );
            $array[] = $row;
        }

        return $repoInventario->deleteSubInventory($array);
    }
    
    /* CUANDO SE RECIBE EN SUCURSAL A LA QUE SE ENVIO */
    public function getDataShipment($numShipment){        
        try {
            $query = "SELECT * FROM stores_shipments WHERE num_shipment = '$numShipment'";
            $result = $this->query($query);
            
            if($result->num_rows > 0 ){
                $data = $this->resultToArray($result);
                $data = $data[0];

                $query = "SELECT * FROM stores_shipments_details WHERE id_shipment = '{$data['id']}' ";
                $result = $this->query($query);
                $details = $this->resultToArray($result);
                
                return array(
                    'response'=>true,
                    'data'=>$data,
                    'details'=>$details
                );              
            }       
            
            return array('response'=>null,'msg'=>"No se ha generado Envio #{$numShipment}.");         
            
        } catch (Exception $exc) {
            return array(
                'response'=>null,
                'msg'=>$exc->getMessage()
            ); 
        } 
    }
    
    /*Update tbl Shipment de MainServer desde sucursal*/
    public function updateShipment($options){        
        $data = $options['data'];
        $details = $options['details'];
        $numShipment = $data['num_shipment'];
        
        $options = array(
            'receiving_date'=>$data['date'],
            'receiving_comments'=>$data['comments'],
            'status'=>$data['status'],
            'last_sinc'=>date('Y-m-d H:i:s')
        );
        
        try{
            $this->updateString($options, " num_shipment = '{$numShipment}'", 'stores_shipments');
            foreach($details as $detail){
                $query = "UPDATE $this->table s,stores_shipments_details d "
                        . "SET received = {$detail['received']} "
                        . "WHERE s.id = d.id_shipment "
                        . "AND s.num_shipment = '{$numShipment}' "
                        . "AND d.id_product = '{$detail['id_product']}'";
                
                $this->query($query);
            }
            
        } catch (Exception $ex) {
            return true;
        }
        return true;
    }
    
    public function existShipmentForStoreRequest($idStoreRequest){
        $query = "SELECT * FROM $this->table WHERE id_store_request = $idStoreRequest AND status = '1'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result)[0];
        }
        return null;
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
    
    
}