<?php
class ReceivingRepository extends EntityRepository {

    private $table = 'receivings';
    public $flashmessenger = null;
    
    private $options = array (
        'num_shipment'=>null,
        'date'=>null,
        'from_store'=>null,
        'to_store'=>null,
        'comments'=>null,
        'shipment_date'=>null,
        'shipment_comments'=>null,        
        'last_sinc'=>null,
        'status'=>null);
    
    private $options_aux = array(
        'dateShipmentFormated'=>null,
        'dateFormated'=>null,
        'statusName'=>null,
        'userName'=>null,
        'token_form'=>null
    );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getTokenForm(){
        return $this->options_aux['token_form'];
    }
    
    public function getNumShipment() {
       return $this->options['num_shipment'];
    }
    
    public function getStatus() {
       return $this->options['status'];
    }
    
    public function getUserName(){
        return $this->options_aux['userName'];
    }
    
    public function getStatusName(){
        return $this->options_aux['statusName'];
    }
    
    public function getDate() {
       return $this->options['date'];
    }
    
    public function getFromStore() {
       return $this->options['from_store'];
    }
    
     public function getToStore() {
       return $this->options['to_store'];
    }
    
    public function getShipmentDateFormated() {
       return $this->options_aux['dateShipmentFormated'];
    }
    
    public function getDateFormated() {
       return $this->options_aux['dateFormated'];
    }
    
    public function getShipmentComments(){
        return $this->options['shipment_comments'];
    }
    
     public function getComments(){
        return $this->options['comments'];
    }
    
    public function getFormatDate(){
        $date = substr($this->getDate(), 0, 10);
        $date = strftime('%m/%d/%Y',  strtotime($date));
        return $date;
    }
   
    public function resultSearchToExcel($options){
    $result = $this->paginationExcel($options);

    $reporte = new ReportFinanzasEntity();
    $reporte->setReporte($result);
    $reporte->setNombreReporteManual($this->_getTranslation('Recibos'));
    $startDate = $options['startDate'];
    $endDate = $options['endDate'];
    if(trim($startDate)=='' && trim($endDate)==''){
            $startDate = $this->_getTranslation("Desde el inicio de los tiempos");
            $endDate = strftime('%B %d, %Y',strtotime('now'));
        }elseif(trim($startDate)=='' && trim($endDate)!=''){
            $startDate = $endDate;
        }elseif(trim($startDate)!='' && trim($endDate)==''){
            $endDate = $startDate;
        }
    $empresa = new EmpresaEntity();
    $empresa = $empresa->getById(1);
    $reporte->setHeaderExcelReportManual($empresa['name']."\n".$this->_getTranslation('Recibos')."\n".$startDate." - ".$endDate);
    $reporte->getReporteOnFile();
  }

    
  
      public function paginationExcel($options){
      $reference = null;
      $status = "";
      $fecha= $this->createFilterFecha($options, 'c.date');
      
      if(isset($options['id_receiving']) && $options['id_receiving']!='' && $options['id_receiving']!= null ){$reference = "AND c.id = '".$options['id_receiving']."'";}
      if(isset($options['showCancel'])){$status = null;}
          
      $query = "SELECT c.id as '".$this->_getTranslation('# Envio')."',
                DATE_FORMAT(c.date,'%b-%d-%Y')as '".$this->_getTranslation('fecha')."', 
                fxGetStatusName(c.`status`,'status','receiving')as '".$this->_getTranslation('status')."'               
                FROM receivings c
                LEFT JOIN receivings_details d ON c.id = d.id_receiving
                WHERE  1=1 
                $reference
                $fecha
                $status" 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";

      $result = $this->query($query);
      if($result->num_rows > 0){
          return $this->resultToArray($result);
      }

      return null;   
  }
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
  
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }

    public function save(array $data, $table = null) {             
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateTimeToDB($data['date']);
        $data['status'] = '1';
        
        $this->startTransaction(); 
        unset($data['shipment_date'],$data['shipment_comments'],$data['last_sinc']); 
        parent::save($data, $this->table);        

        $storeInDetailsTemp = new ReceivingDetailsTempRepository();
        $idReceiving = $this->getInsertId();
        $this->setLastInsertId($idReceiving);//Para utilizarlo en el Controller action insert
        
        if($storeInDetailsTemp->saveDetalles($idReceiving,$data['to_store'], $this->getTokenForm())){  
            $this->commit();
            $storeInDetailsTemp->truncate($this->getTokenForm());

            return true;
        }
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }
    
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status'] == '4'){return true;}
        
        $this->startTransaction();
        $rs = parent::update($id, array('status'=>'4'), $this->table);
        if($rs){
            $detallesAfectados = $this->getReceivingDetailsSaved($id);
            if(!$this->subInventoryFromReceivingDetalles($detallesAfectados, $currentData['to_store'])){
                $this->rollback();
                return null;
            }    
        }
        $this->commit();
        
        $repoMainServer = new MainServerRepository();
        $repoMainServer->updateShipment(array(
                            'data'=>$this->getById($id),
                            'details'=>array()));   
        
        return true;
    }
    
    public function update($id, $data, $table = null) {              
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateTimeToDB($data['date']);
    
        unset($data['status'],$data['shipment_date'],$data['shipment_comments'],$data['last_sinc']); 
        $this->startTransaction();
        
        //Actualizo tabla compras
        $result = parent::update($id, $data, $this->table);
        
        if($result){
            $repository = new ReceivingDetailsTempRepository();
            if($repository->updateDetalles($id,$data['to_store'], $this->getTokenForm())){  
                $this->updateStatus($id);
                $this->commit();              
                $repository->truncate($this->getTokenForm());               
                                
                $repoShipment = new ShipmentRepository();
                $repoShipment->updateShipment(array(
                                    'data'=>$this->getById($id),
                                    'details'=>$this->getReceivingDetailsSaved($id)));    
                
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }
    
    public function updateStatus($id){
        $query = "SELECT SUM(quantity)as quantity, SUM(received)as received "
                . "FROM receivings_details "
                . "WHERE id_receiving= '$id' ";
        
        $result = $this->query($query);
        
        if($result){           
           $result = $result->fetch_object();
           
         if($result->received === NULL || $result->received == '0'){              
               $status = '1';
           }elseif($result->received >= $result->quantity){
               $status = '2';
           }elseif($result->received < $result->quantity){
               $status = '3'; 
           }
           return $this->updateString(array('status'=>$status), " id = '$id' ");
        }
        return true;        
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%m/%d/%Y %r')as dateFormated,"
                . "DATE_FORMAT(shipment_date,'%m/%d/%Y %r')as dateShipmentFormated,"
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetStatusName(status,'status','Receiving')as statusName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
    public function getByNumShipment($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%m/%d/%Y %h:%i %p ')as dateFormated,"
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetStatusName(status,'status','Receiving')as statusName "
                . "FROM $this->table "
                . "WHERE num_shipment = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
    public function existProductInReceiving($idReceiving,$idProduct){
        $query = "SELECT r.id FROM receivings r,receivings_details d "
                . "WHERE r.id = d.id_receiving "
                . "AND r.id = '$idReceiving' "
                . "AND d.id_product = '$idProduct' "
                . "AND r.status != '4'";
        
        $result = $this->query($query);
        if($result->num_rows > 0){
            return true;
        }
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('store-out' => 'requisition'));
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        
        $query = "CREATE TABLE IF NOT EXISTS receivings_details_".$login->getId()." 
                 (  
                    `token_form` char(50) NOT NULL,
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_receiving` int(11) NULL,
                    `id_product` int(11) NOT NULL,
                    `quantity` double NULL,
                    `received` double  NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $storeInDetailsTemp = new ReceivingDetailsTempRepository();
        
        return $storeInDetailsTemp->save($data);
    }
    
      public function getReceivingDetails($token_form){
        $login = new Login();
        $query = "SELECT v.*,
                    v.id as idDetailTemp,
                    p.id as product,
                    p.codigo as code,
                    p.descripcion as description,
                    fxGetCategoriaDescripcion(p.categoria)as category,
                    fxGetTamanoDescripcion(p.tamano)as size
                  FROM receivings_details_".$login->getId()." v LEFT JOIN productos p ON v.id_product = p.id
                  WHERE v.token_form = '$token_form' ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }        
        return null;
    }
    
    public function getReceivingDetailsSaved($id){
        $query = "SELECT c.*,
                    p.codigo as code,
                    p.descripcion as description,
                     fxGetTamanoDescripcion(p.tamano)as size
                    FROM receivings_details c LEFT JOIN productos p ON c.id_product = p.id
                    WHERE c.id_receiving = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getProductoByCode($code){
        $repo = new ProductoRepository();
        return $repo->getByCode($code);
    }
    
    public function setReceivingDetailsById($idCompra, $tokenForm){
        $repository = new ReceivingDetailsTempRepository();
        
        return $repository->setReceivingDetailsById($idCompra, $tokenForm);
    }
    
    public function truncateIfIsEditInfo(){
        $repository = new ReceivingDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
        
    }
    
    public function getProductById($idProducto){
        $query = "SELECT * FROM productos WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    public function getListReceivings($options = null){          
        $limit = " LIMIT 100";
        
        $query = "SELECT r.*,
                SUM(d.quantity)as quantity,
                IFNULL(SUM(d.received),'0')as received,
                DATE_FORMAT(r.date,'%m/%d/%Y %h:%i %p ')as date,
                fxGetStatusName(r.`status`,'status','Receiving')as statusName,
                fxGetStoreName(r.to_store) as store_name,
                fxGetUserName(r.creado_por) as user
                FROM receivings r, receivings_details d
                WHERE r.id = d.id_receiving " 
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC $limit ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
      public function saveUsingDataFromMainServer($data){
       $receiving = $data['data'];
       $details = $data['details'];
       
        try {
           $this->startTransaction();
           $options = array(
               'num_shipment'=>$receiving['num_shipment'],
               'shipment_date'=>$receiving['date'],
               'from_store'=>$receiving['from_store'],
               'to_store'=>$receiving['to_store'],
               'shipment_comments'=>$receiving['comments'],
               'status'=>$receiving['status']
           );
           
           parent::save($options,'receivings');       
           $idReceiving = parent::getInsertId();
           
           foreach($details as $detail){
               $options = array(
                   'id_receiving'=>$idReceiving,
                   'id_product'=>$detail['id_product'],
                   'quantity'=>$detail['quantity'],
               );
               parent::save($options,'receivings_details'); 
           }           
           parent::commit();        
           
           return $idReceiving;

        } catch (Exception $exc) {
            parent::rollback();    
            $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));
            return null;
        }   
    }
    
    public function updateFromMainServer($id){
        $receivingData = $this->getById($id);        
        $repo = new ShipmentRepository();
        $options = $repo->getDataShipment($receivingData['num_shipment']);
        
        if(!$options['response']){return null;}
        
        $data = $options['data'];
        $detailsFromServer = $options['details'];
        
        $options = array(
            'shipment_date'=>$data['date'],
            'from_store'=>$data['from_store'],
            'to_store'=>$data['to_store'],
            'shipment_comments'=>$data['comments'],
            'status'=>$data['status'],
        );
        
        parent::startTransaction();
        $rs = parent::updateString($options, " num_shipment = '{$data['num_shipment']}'", $this->table);
        if($rs){
            $idProducts = null;
            foreach($detailsFromServer as $serverDetail){
                $idProducts[] = $serverDetail['id_product'];
                
                if($this->existProductInReceiving($id,$serverDetail['id_product'])){
                    $options = array ('quantity'=>$serverDetail['quantity']);  
                    $rs = parent::updateString($options, " id_receiving = '$id' AND id_product = '{$serverDetail['id_product']}'", 'receivings_details');
                }else{
                    $options = array(
                        'id_receiving'=>$id,
                        'id_product'=>$serverDetail['id_product'],
                        'quantity'=>$serverDetail['quantity'],
                    );
                    $rs = parent::save($options, 'receivings_details');                    
                }
                
                if(!$rs){parent::rollback();return null;}
            }
            
            /*$detailsFromLocal = $this->getReceivingDetailsSaved($id);            
            foreach ($detailsFromLocal as $localDetail){
                if(!in_array($localDetail['id_product'], $idProducts) && ($localDetail['received'] != '0') && $localDetail['received'] != null ){
                   $query = "DELETE FROM receivings_details WHERE id_receiving = '$id' AND id_product = '{$localDetail['id_product']}' ";
                   if(!$this->query($query)){
                       parent::rollback();
                       return null;
                   }
                }
            }*/
            
            parent::commit();
            return true;
            
        }else{
            parent::rollback();
            return null;
        }            
    }
    
     /*PARA CONTROL DE INVENTARIOS*/
  public function subInventoryFromReceivingDetalles($detallesAfectados, $idSucursal){        
        $repoInventario = new InventarioRepository();         
        $array = array();
        
        foreach($detallesAfectados as $detalle){         
            $row = array(                        
                        'id_product'=>$detalle['id_product'],
                        'quantity'=>$detalle['received'],
                        'sucursal'=>$idSucursal,
                        'controller'=>'Recibos-eliminar '.$detalle['id_receiving']
                    );
            $array[] = $row;
        }

        return $repoInventario->deleteAddInventory($array);
        
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
}