<?php
class ProductDetailsTempRepository extends EntityRepository {

    private $table = 'products_details_';
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {        
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                 parent::delete($id,$this->table);
            }
         }
        
        unset($data['idDetailTemp']);           
        $query = "SELECT id,quantity FROM ".$this->table.
                " WHERE id_slice = '".$data['id_slice']."'";
        
        $result = $this->query($query);       

        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['quantity'] = $data['quantity'] + $result->quantity;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            return parent::save($data, $this->table);
        }
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idProduct){
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        if($result->num_rows > 0){
           
            $result = $this->resultToArray($result);
            
            foreach($result as $data){
                unset($data['id']);
                unset($data['id_detail']); 
                $data['id_product'] = $idProduct;
                
                parent::save($data, 'products_details');
            }            
        }

        return true;
    } 
    
    public function updateDetalles($idProduct){
        $query = "SELECT id FROM products_details WHERE id_product = '$idProduct'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $idDetalle = $data['id_detail'];
                unset($data['id']);
                unset($data['id_detail']);            
                $data['id_product'] = $idProduct;
              
                if(!$idDetalle){
                    parent::save($data, 'products_details');
                }else{
                    #contiene los idDetalles de la salida original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle,$data, 'products_details');         
                }  
            }
        }

        #Se eliminan ids de tabla store_out_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    parent::delete($detalle['id'], 'products_details');
                }
            }
        }  
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    
    public function truncateIfIsEditInfo(){
        $query = "SELECT id_product FROM .".$this->table." LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            if($result->id_product !=NULL || $result->id_product != ''){
                $this->truncate();
                return true;
            }
        }
        
        return null;
    }
    
    public function truncate(){
        $query = "TRUNCATE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function drop(){
        $query = "DROP TABLE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }        
        return null;
    }
    
    public function setProductDetailsById($idProduct){
        $this->query("TRUNCATE ".$this->table);
        $query = "INSERT INTO ".$this->table." (id_detail,id_product,id_slice,quantity)
                    SELECT id,id_product,id_slice,quantity
                    FROM products_details 
                    WHERE id_product = '$idProduct'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null) {
        if(isset($data['id_product'])){
            if($data['id_product']=='' || !$data['id_product']){
                unset($data['id_product']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}