<?php 
$controller = 'Shipment';
$action = '';
if(isset($_POST['action'])){
    $action = $_POST['action'];
    if (isset($_POST['id'])) {$id = $_POST['id'];}
}elseif(isset($_GET['action'])){
    $action = $_GET['action'];
    if (isset($_GET['id'])) {$id = $_GET['id'];}
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new ShipmentForm();
$shipment = new ShipmentRepository();

switch($action){
    case 'insert':
        $form->populate($_POST);  
        $form->setTokenForm($_POST['token_form']);
        if ($form->isValid()) {
            $shipment->setOptions($_POST); 
            if ($shipment->save($shipment->getOptions())) {                
                $shipmentNo = $shipment->getLastInsertId();
                $printShipment = "<a href=\"\" onclick=\"javascript: void window.open('/Controller/Shipment.php?action=import&flag=pdf&id=$shipmentNo','','width=700,height=500,status=1,scrollbars=1,resizable=1')\">".$_translator->_getTranslation('Imprimir')."</a>";  
                $flashmessenger->addMessage(array(
                    "success"=>$_translator->_getTranslation("Envio")." #$shipmentNo ".$_translator->_getTranslation("registrado exitosamente.")." $printShipment"));
                
                header("Location: Shipment.php?action=edit&id=$shipmentNo");
            }else{                
                $vista = 'Shipment.php';
                include $root . '/View/Template.php';                
            }
        } else {
            $vista = 'Shipment.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'list':
        $_listShipments = $shipment->getListShipments();
        
        $vista = 'ShipmentList.php';
        include $root . '/View/Template.php';
        break;
        
    case 'import':
        switch($_GET['flag']){
            case 'pdf':
                $pdf = new ShipmentPDF($_GET['id']);
                break;
        }        
        break;
    
    case 'edit':   
        #Para usar status y statusName
        $shipment->setOptions($shipment->getById($id));
        
        if($_GET){
            $shipmentData = $shipment->getById($id);
            $shipment->crearTablaDetallesForUser();
            $shipment->setShipmentDetailsById($id, $form->getTokenForm());
        }
        if($_POST){
            $shipmentData = $_POST;
            $form->setTokenForm($_POST['token_form']);
        }

        $form->setActionController('edit');
        $form->setId($id);
        $form->populate($shipmentData);
        
        if($shipmentData['status'] == '4'){
            $form->disabledAllElements();
        }
        
        if(isset($_POST['id'])){
            if($form->isValid()){
                $shipment->setOptions($shipmentData);
                $result = $shipment->update($id,$shipment->getOptions()); //no tengo id porque viene de post
                if($result){
                    $flashmessenger->addMessage(array('success'=>'Envio actualizado exitosamente.'));
                    header("Location: Shipment.php?action=edit&id=$id");
                }else{
                     $vista = 'Shipment.php';
                    include $root . '/View/Template.php';                    
                }       
            }else{
                $vista = 'Shipment.php';
                include $root . '/View/Template.php';
            }
        }else{
            $vista = 'Shipment.php';
            include $root . '/View/Template.php';
        }        
        break;
    
    case 'delete':
        if($shipment->delete($id)){
            $flashmessenger->addMessage(array('success'=>'Envio eliminado satisfactoriamente.'));
        }        
        header("Location: Shipment.php?action=list");
        break;
        
    case 'ajax':
        $ajaxShipment = new ShipmentAjax();
        $json = $ajaxShipment->getResponse($_POST['request'],$_POST);
        
        echo json_encode($json);
        break;       
    
    default:      
        $shipment->crearTablaDetallesForUser();
        $vista = 'Shipment.php';
        include $root.'/View/Template.php';
        break;
}