<?php 
$controller = 'Sale';
$action = '';
if(isset($_POST['action'])){
    $action = $_POST['action'];
    if (isset($_POST['id'])) {$id = $_POST['id'];}
}elseif(isset($_GET['action'])){
    $action = $_GET['action'];
    if (isset($_GET['id'])) {$id = $_GET['id'];}
}
include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new VentaForm();
$venta = new VentaEntity();

switch($action){
    case 'insert':
        $form->listChoferesByTransportista($_POST['truck_trailer']);
        $form->populate($_POST);
        $venta->setOptions($_POST);
        if ($form->isValid()){           
            if ($venta->save($venta->getOptions())) {
                $ventaNo = $venta->getLastInsertId();
                $printVenta = "<a href=\"\" onclick=\"javascript: void window.open('/Controller/Venta.php?action=pdf&invoice&id=$ventaNo','','width=700,height=500,status=1,scrollbars=1,resizable=1')\">".$_translator->_getTranslation('Imprimir')."</a>";
                $flashmessenger->addMessage(array("success"=>$_translator->_getTranslation('Venta')." #$ventaNo ".$_translator->_getTranslation('registrada exitosamente.')." $printVenta"));
                header("Location: Venta.php?action=edit&id=$ventaNo");
            }else{                
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                $vista = 'Sale.php';
                include $root . '/View/Template.php';                     
            }
        } else {
            $vista = 'Sale.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'pagination':
        if(!isset($_GET['pag'])){$_GET['pag'] = null;}
        $pagObj = $venta->pagination($_GET['pag']);
        $ventaPag = $pagObj->getResultSet();
        
        $vista = 'VentaPagination.php';
        include $root . '/View/Template.php';
        break;   
        
    case 'buscarv':
        $form = new VentaBuscarForm();
        $form->setActionForm('Venta.php');
        if(isset($_GET['send'])){
            $venta->setBackButton('Venta');
            if(!isset($_GET['pag'])){$_GET['pag'] = null;}
            $pagObj = $venta->paginationBuscarVenta($_GET['pag'],$_GET);
            $ventaPag = $pagObj->getResultSetQueryString();
            
            $vista = 'VentaBuscarPagination.php';
            include $root . '/View/Template.php';
            
        }else{
            $vista = 'VentaBuscar.php';
            include $root.'/View/Template.php';
        }
        break;
    
    case 'edit':             
        if($_GET){
            $ventaData = $venta->getById($id);
            $venta->crearTablaDetallesForUser();
            $venta->setVentaDetallesById($id);
}
        if($_POST){$ventaData = $_POST;}
        
        $form->setActionController('edit');
        $form->setId($id);
        $form->listChoferesByTransportista($ventaData['truck_trailer']);
        $form->populate($ventaData);
        
        $venta->setOptions($ventaData);        
        if(isset($_POST['id'])){
            if($form->isValid()){
                $result = $venta->update($id,$venta->getOptions()); //no tengo id porque viene de post
                if($result){
                    $flashmessenger->addMessage(array('success'=>'Venta actualizada exitosamente.'));
                    header("Location: Venta.php?action=edit&id=$id");
                }else{
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                    $vista = 'Sale.php';
                    include $root . '/View/Template.php';                    
                }       
            }else{
                $vista = 'Sale.php';
                include $root . '/View/Template.php';
            }
        }else{
            $vista = 'Sale.php';
            include $root . '/View/Template.php';
        }        
        break;
    
    case 'delete':       
            if($venta->delete($id)){
                $flashmessenger->addMessage(array('success'=>'Venta eliminada satisfactoriamente.'));
                echo "<script>parent.location.reload(true);</script>";
            }
        
        break;
        
    case 'pdf':       
        switch($_GET['flag']){
            case 'shipventa':
                 $shipmentVentaPDF = new VentaShipmentPDF($_GET['id']);
                break;
            case 'invoice':
                 $invoicePDF = new InvoicePDF($_GET['id']);
                break;
            case 'pickticket':
                $pickTicketPDF = new PickTicketPDF($_GET['id']);
                break;
        }
        break;
    
    case 'excel':
        switch($_GET['flag']){
            case 'search':
                $venta->resultSearchToExport($_GET);
                break;
        }
        
        break;
        
    case 'mail':        
        $invoicePDF = new InvoicePDF($_POST['idVenta'],true);
       
        $_POST['attachment'] = $invoicePDF->getFileInvoiceCreated();
        $_POST['msg-success'] = $_translator->_getTranslation("Factura enviada exitosamente");
        
        $emailer = new Emailer();
        $emailer->sendEmail($_POST);
        header('Location: Venta.php?action=edit&id='.$_POST['idVenta']);
        
        break;
            
    case 'ajax':
        $ajaxVenta = new VentaAjax();
        $json = $ajaxVenta->getResponse($_POST['request'],$_POST);
        
        echo json_encode($json);
        break;       
    
    default:
        $venta->crearTablaDetallesForUser();
        $venta->truncateIfIsEditInfo();
        
        $vista = 'Sale.php';
        include $root.'/View/Template.php';
}