<?php 
$controller = 'Receiving';
$action = '';
if(isset($_POST['action'])){
    $action = $_POST['action'];
    if (isset($_POST['id'])) {$id = $_POST['id'];}
}elseif(isset($_GET['action'])){
    $action = $_GET['action'];
    if (isset($_GET['id'])) {$id = $_GET['id'];}
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$form = new ReceivingForm();
$receiving = new ReceivingRepository();

switch($action){
    case 'insert':
        $form->populate($_POST); 
        $form->setTokenForm($_POST['token_form']);
        if ($form->isValid()) {
            $receiving->setOptions($_POST); 
            if ($receiving->save($receiving->getOptions())) {                
                $receivingNo = $receiving->getLastInsertId();
                $printReceiving = "<a href=\"\" onclick=\"javascript: void window.open('/Controller/Receiving.php?action=import&flag=pdf&id=$receivingNo','','width=700,height=500,status=1,scrollbars=1,resizable=1')\">".$_translator->_getTranslation('Imprimir')."</a>";  
                $flashmessenger->addMessage(array(
                    "success"=>$_translator->_getTranslation("Recibo")." #$receivingNo ".$_translator->_getTranslation("registrado exitosamente.")." $printReceiving"));
                
                header("Location: Receiving.php?action=edit&id=$receivingNo");
            }else{                
                $vista = 'Receiving.php';
                include $root . '/View/Template.php';                
            }
        } else {
            $vista = 'Receiving.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'list':
        $_listReceivings = $receiving->getListReceivings();
        
        $vista = 'ReceivingList.php';
        include $root . '/View/Template.php';
        break;
        
    case 'import':
        switch($_GET['flag']){
            case 'pdf':
                $pdf = new ReceivingPDF($_GET['id']);
                break;
        }        
        break;
    
    case 'edit':   
        $receivingData = $receiving->getById($id);
        if($receivingData['status'] != '4'){
             #Primero actualizamos informacion de receiving con informacion de MainServer
            $receiving->updateFromMainServer($id);
            $receiving->updateStatus($id);
        }       
        
        #Para usar status y statusName
        $receiving->setOptions($receiving->getById($id));
        
        if($_GET){
            $receivingData = $receiving->getById($id);
            $receiving->crearTablaDetallesForUser();
            $receiving->setReceivingDetailsById($id, $form->getTokenForm());
        }
        if($_POST){
            $receivingData = $_POST;
            $form->setTokenForm($_POST['token_form']);
        }

        $form->setActionController('edit');
        $form->setId($id);
        $form->populate($receivingData);
        
        $form->setReadOnlydElements(array('num_shipment'));
        
        if($receivingData['status'] == '4'){
            $form->disabledAllElements();
        }
      
        if(isset($_POST['id'])){
            if($form->isValid()){   
                $receiving->setOptions($receivingData);
                $result = $receiving->update($id,$receiving->getOptions());
                if($result){ 
                    $flashmessenger->addMessage(array('success'=>'Recibo actualizado exitosamente.'));
                    header("Location: Receiving.php?action=edit&id=$id");
                }else{
                     $vista = 'Receiving.php';
                    include $root . '/View/Template.php';                    
                }       
            }else{
                $vista = 'Receiving.php';
                include $root . '/View/Template.php';
            }
        }else{
            $vista = 'Receiving.php';
            include $root . '/View/Template.php';
        }        
        break;
    
    case 'delete':
        if($receiving->delete($id)){
            $flashmessenger->addMessage(array('success'=>'Recibo eliminado satisfactoriamente.'));
        }        
        header("Location: Receiving.php?action=list");
        break;
        
    case 'ajax':
        $ajaxReceiving = new ReceivingAjax();
        $json = $ajaxReceiving->getResponse($_POST['request'],$_POST);
        
        echo json_encode($json);
        break;       
    
    default:      
        $receiving->crearTablaDetallesForUser();
        $vista = 'Receiving.php';
        include $root.'/View/Template.php';
        break;
}