<?php  
class SlicePDF {
    private $pathfFileCreated = null; 
    public function __construct($idSlice,$createFile = null) {
        $slice = new SliceEntity();
        $slice->setOptions($slice->getById($idSlice));
        $slice->setId($idSlice);
        
        $empresa = new CompanyEntity();
        $empresa->setOptions($empresa->getById(1));        
        
        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php 
        $pdf = new PDF();
        if($slice->getStatus() == '3'){
            $pdf->AddPage('','','  Cancelada');
        }else{
            $pdf->AddPage('','');
        }

        //$pdf->Image(ROOT."/public/img/logo.png",10,10,80,0);
        //$pdf->Image(ROOT."/public/img/logo.png",170,275,30,0);
        
        $pdf->SetFont('Arial','','18');
        $pdf->SetTextColor(255);
        $pdf->SetFillColor(51,153,255);
        $pdf->SetX(0);
        $pdf->Cell(90,10, "PARTES DEL PASTEL No: ".$slice->getId(), '0', 0, 'R',true);   
        $pdf->Cell(15, 10, "", '', 0, 'C'); //<== margin left 
        $pdf->SetTextColor(0);
        $pdf->Cell(95, 10, $empresa->getName(), 'L', 1, 'R');          
        
        $pdf->SetFont('Arial','','12');    
        $pdf->Cell(95, 7, "", '', 0, 'C'); //<== margin left 
        $pdf->SetFont('Arial','','16');
        $pdf->cell(95,3,$empresa->getWebPage(),'L',1,'R');
        $pdf->Cell(80, 7,'', '', 0);
        
        $pdf->Ln(1);
        $pdf->SetFont('Arial','','10');
        $pdf->SetTextColor(0);
        
        $direccion  ="\n".$empresa->getAddress();
        $direccion .= "\n".$empresa->getCity().', '.$empresa->getState().' '.$empresa->getZipCode();
        $direccion .= "\n".$empresa->getPhone();
        $pdf->Cell(190, 28, $direccion, '0', 1, 'R');
       
        $pdf->SetFont('Arial','B','14');         
        $pdf->cell(100,10,'INFORMACION:','',1,'L'); 
        
        $pdf->SetFont('Arial','','10');         
        $pdf->Cell(20, 5, "Categoria:", '0', 0, 'R');
        $pdf->Cell(50, 5, $slice->getCategoryName(), '0', 1, 'L');
        $pdf->Cell(20, 5, "Nombre:", '0', 0, 'R');
        $pdf->Cell(50, 5, $slice->getFlavor(), '0', 1, 'L');
        $pdf->Cell(20, 5, utf8_decode("Tamaño:"), '0', 0, 'R');
        $pdf->Cell(50, 5, $slice->getSizeName(), '0', 1, 'L');
        $pdf->Cell(20, 5, "Creado por:", '0', 0, 'R');
        $pdf->Cell(50, 5, $slice->getUserName(), '0', 1, 'L');
       
        $pdf->Ln(5);        
        $pdf->SetFont('Arial','B','10');
        $pdf->Cell(15, 7, "Codigo", 'B', 0, 'C');
        $pdf->Cell(75, 7, "Descripcion", 'B', 0, 'L');
        $pdf->Cell(15, 7, "Cantidad", 'B', 0, 'R');
        $pdf->Cell(20, 7, "UM", 'B', 1, 'C');   
       
        $pdf->SetFont('Arial','','8');
        $detalles = $slice->getSliceDetailsSaved($idSlice);
        $totalQuantity = 0;
        
        foreach($detalles as $detalle){      
            $totalQuantity += $detalle['quantity'];
            
            $pdf->Cell(15, 5, htmlentities($detalle['code']), 'B', 0, 'C');
            $pdf->Cell(75, 5, utf8_decode($detalle['description']), 'B', 0, 'L');
            $pdf->Cell(15, 5, number_format($detalle['quantity'],2), 'B', 0, 'R');
            $pdf->Cell(20, 5, $detalle['unitMeasureName'], 'B', 1, 'R');
        }      
        
        if($createFile){
            if(!is_dir(PATH_TEMP_DOCS."slices/")){
                mkdir(PATH_TEMP_DOCS."slices/",0777,true);
            }
            $pdf->Output(PATH_TEMP_DOCS."slices/PARTES_DEL_PASTEL-".$idSlice.".pdf","F");
            $this->pathfFileCreated = PATH_TEMP_DOCS."slices/PARTES_DEL_PASTEL-".$idSlice.".pdf";
        }else{
            $pdf->Output();
        }
    }
    
    public function getPathFileCreated(){
        return $this->pathfFileCreated;
    }
}