<?php  
class ShipmentPDF {
    private $pathfFileCreated = null; 
    public function __construct($idShipment,$createFile = null) {
        $shipment = new ShipmentRepository();
        $shipment->setOptions($shipment->getById($idShipment));
        $shipment->setId($idShipment);
        
        $empresa = new CompanyEntity();
        $empresa->setOptions($empresa->getById(1));        
        
        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php 
        $pdf = new PDF();
        if($shipment->getStatus() == '3'){
            $pdf->AddPage('','','  Cancelada');
        }else{
            $pdf->AddPage('','');
        }
        
        $pdf->SetFont('Arial','','14');
        $pdf->SetTextColor(255);
        $pdf->SetFillColor(51,153,255);
        $pdf->SetX(0);
        $pdf->Cell(90,10, "ENVIO No: ".$shipment->getNumShipment(), '0', 0, 'R',true);   
        $pdf->Cell(15, 10, "", '', 0, 'C'); //<== margin left 
        $pdf->SetTextColor(0);
        $pdf->Cell(95, 10, $empresa->getName(), 'L', 1, 'R');             

        $pdf->SetFont('Arial','','9');        
        $pdf->Cell(40, 15, "CODIGO DE BARRAS: ", '',0, 'R');
        $pdf->Cell(40, 15, '', '', 0, 'R');  
        //include ROOT_HOST.'/class/BarCode/barcode.php?filepath='.PATH_TEMP_DOCS.'/barcodes/'.$shipment->getNumShipment().'.png&text='.$shipment->getNumShipment();
        $barCode = new BarCode();
        $barCode->setBarCode(array(
            'filepath'=>PATH_TEMP_DOCS.'/barcodes/'.$shipment->getNumShipment().'.png',
            'text'=>$shipment->getNumShipment(),
            'print'=>false));
        $pdf->Image(ROOT.'app/resources/docs/temp/barcodes/'.$shipment->getNumShipment().'.png',52,21,40,0);
        
        $direccion  ="\n".$empresa->getAddress();
        $direccion .= "\n".$empresa->getCity().', '.$empresa->getState().' '.$empresa->getZipCode();
        $direccion .= "\n".$empresa->getPhone();
        $pdf->Cell(15, 15, '', '', 0, 'C'); //<== margin left 
        $pdf->Cell(95, 15, $direccion, '', 1, 'R');      
        
        $pdf->Cell(40, 6, "STATUS: ", '', 0, 'R');
        $pdf->Cell(40, 6, $shipment->getStatusName(), '', 1, 'R');              

        $pdf->SetFont('Arial','','9');
        $pdf->Cell(40, 5, 'FECHA Y HORA DE ENVIO: ', '', 0, 'R');
        $pdf->Cell(40, 5, $shipment->getDateFormated(), '', 1, 'R');  
        $pdf->Cell(40, 5, 'FECHA Y HORA DE RECIBO: ', '', 0, 'R');
        $pdf->Cell(40, 5, $shipment->getReceivingDateFormated(), '', 1, 'R');
        
        $pdf->Ln(5);
        $pdf->SetTextColor(0);       
        $pdf->SetFont('Arial','B','8');         
        $pdf->cell(100,4,'ENVIO DESDE:','',0,'L'); 
        $pdf->cell(105,4,'ENVIO PARA:','',1,'L');    
        
        $sucursal = new SucursalRepository();
        $sucursal->setOptions($sucursal->getById($shipment->getFromStore()));
        $fromStore = "\nSucursal: ".$sucursal->getNombre();
        $fromStore .= "\n".$sucursal->getDireccion();
        $fromStore .= "\n".$sucursal->getCiudad().", ".$sucursal->getEstado()." ".$sucursal->getCodigoPostal();
        $fromStore .= "\n".$sucursal->getTelefono();
        
        $sucursal->setOptions($sucursal->getById($shipment->getToStore()));
        $toStore = "\nSucursal: ".$sucursal->getNombre();
        $toStore .= "\n".$sucursal->getDireccion();
        $toStore .= "\n".$sucursal->getCiudad().", ".$sucursal->getEstado()." ".$sucursal->getCodigoPostal();
        $toStore .= "\n".$sucursal->getTelefono();
        
        $pdf->SetFont('Arial','','8'); 
        $pdf->Cell(100, 12, $fromStore, '0', 0, 'L');
        $pdf->cell(105,12,$toStore,'0',1,'L');       
       
        $pdf->Ln(5);        
        $pdf->SetFont('Arial','B','8');
        
        $pdf->Cell(55, 7, "Descripcion", 'B', 0, 'L');
        $pdf->Cell(30, 7, utf8_decode("Tamaño"), 'B', 0, 'L');
        $pdf->Cell(25, 7, "Requerido", 'B', 0, 'R'); 
        $pdf->Cell(25, 7, "Enviado", 'B', 0, 'R'); 
        $pdf->Cell(25, 7, "Recibido", 'B', 0, 'R'); 
        $pdf->Cell(25, 7, "Diferencia", 'B', 1, 'R'); 
               
        $pdf->SetFont('Arial','','8');
        $detalles = $shipment->getShipmentDetailsSaved($idShipment,true);
        $totalRequerido = 0;
        $totalEnviado = 0;
        $totalRecibido = 0;
        
        foreach($detalles as $detalle){
            $totalRequerido += $detalle['min_stock'] - $detalle['real_stock_in_store'];
            $totalEnviado += $detalle['quantity'];
            $totalRecibido += $detalle['received'];
            
            $pdf->Cell(55, 5, utf8_decode($detalle['description']), 'B', 0, 'L');
            $pdf->Cell(30, 5, utf8_decode($detalle['size']), 'B', 0, 'L');
            $pdf->Cell(25, 5, number_format($detalle['min_stock'] - $detalle['real_stock_in_store']), 'B', 0, 'R');
            $pdf->Cell(25, 5, number_format($detalle['quantity']), 'B', 0, 'R');
            $pdf->Cell(25, 5, number_format($detalle['received']), 'B', 0, 'R');
            $signo = '';
            if($detalle['received'] > $detalle['quantity']){$signo = '+';}
            elseif($detalle['received'] < $detalle['quantity']){$signo = '-';}
            $pdf->Cell(25, 5, $signo.number_format($detalle['received'] - $detalle['quantity']), 'B', 1, 'R');
        }      
        
        $pdf->Cell(85, 7, "Total", 'B', 0, 'R');
        $pdf->Cell(25, 7, $totalRequerido, 'B', 0, 'R'); 
        $pdf->Cell(25, 7, $totalEnviado, 'B', 0, 'R'); 
        $pdf->Cell(25, 7, $totalRecibido, 'B', 0, 'R'); 
        $signo = '';
        if($totalRecibido > $totalEnviado){$signo = '+';}
        elseif($totalRecibido < $totalEnviado){$signo = '-';}
        $pdf->Cell(25, 7, $signo.number_format($totalRecibido - $totalEnviado), 'B', 1, 'R'); 
        
                      
        $pdf->Ln(2);
        $msgArray = explode("<br />",nl2br($shipment->getComments()));
        $comments = "";
        foreach($msgArray as $line){
            $comments .= $line."\n";
        }
        
        $pdf->SetFont('Arial','B','8');
        $pdf->Cell(85, 7, "Notas envio", 'B', 1, 'L');
        $pdf->SetFont('Arial','','8');
        $pdf->Cell(85, 25,  $comments, '0', 1, 'L');
        
        $msgArray = explode("<br />",nl2br($shipment->getReceivingComments()));
        $commentsReceiving = "";
        foreach($msgArray as $line){
            $commentsReceiving .= $line."\n";
        }
        
        $pdf->SetFont('Arial','B','8');
        $pdf->Cell(85, 7, "Notas recibo", 'B', 1, 'L');        
        $pdf->SetFont('Arial','','8');
        $pdf->Cell(85, 25,  $commentsReceiving, '0', 1, 'L');    
        
        /*        
        //Crear codigo
        QRcode::png('?re='.$empresa->getRFC().'&rr='.$shipment->getRFC().'&tt='.$shipment->getTotalParaCodigoQR().'&id='.$shipment->getUUID(),PATH_TEMP_DOCS."qrCode".$shipment->getSerie()."-".$shipment->getFolio().".png",'Q',3); // creates file
        $pdf->Image(PATH_TEMP_DOCS."qrCode".$shipment->getSerie()."-".$shipment->getFolio().".png",10,165,30,0);
        
        $pdf->ln(12);
       
        */
        if($createFile){
            if(!is_dir(PATH_TEMP_DOCS."requisitions/")){
                mkdir(PATH_TEMP_DOCS."requisitions/",0777,true);
            }
            $pdf->Output(PATH_TEMP_DOCS."requisitions/REQ-".$idShipment.".pdf","F");
            $this->pathfFileCreated = PATH_TEMP_DOCS."requisitions/REQ-".$idShipment.".pdf";
        }else{
            $pdf->Output();
            unlink(ROOT.'app/resources/docs/temp/barcodes/'.$shipment->getNumShipment().'.png');
        }
    }
    
    public function getPathFileCreated(){
        return $this->pathfFileCreated;
    }
}