<?php  
class RequisitionPDF {
    private $pathfFileCreated = null; 
    public function __construct($idRequisition,$createFile = null) {
        $requisition = new RequisitionEntity();
        $requisition->setOptions($requisition->getById($idRequisition));
        $requisition->setId($idRequisition);
        
        $empresa = new CompanyEntity();
        $empresa->setOptions($empresa->getById(1));        
        
        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php 
        $pdf = new PDF();
        if($requisition->getStatus() == '3'){
            $pdf->AddPage('','','  Cancelada');
        }else{
            $pdf->AddPage('','');
        }

        //$pdf->Image(ROOT."/public/img/logo.png",10,10,80,0);
        //$pdf->Image(ROOT."/public/img/logo.png",170,275,30,0);
        
        $pdf->SetFont('Arial','','16');
        $pdf->SetTextColor(255);
        $pdf->SetFillColor(51,153,255);
        $pdf->SetX(0);
        $pdf->Cell(90,10, "ORDEN DE LINEA No: ".$requisition->getId(), '0', 1, 'R',true);         
        
        $pdf->SetFont('Arial','','12');
        $pdf->Cell(50, 7, 'FECHA: ', '', 0, 'R');
        $pdf->Cell(30, 7, $requisition->getFormatDate(), '', 0, 'R');        
        
        $pdf->Ln(1);
        $pdf->SetFont('Arial','','10');
        $pdf->SetTextColor(0);
       
        $pdf->SetFont('Arial','B','12');         
        $pdf->cell(100,10,'INFORMACION:','',1,'L'); 
        
        $pdf->SetFont('Arial','','10');         
        $pdf->Cell(20, 5, "Requisitor:", '0', 0, 'R');
        $pdf->Cell(50, 5, $requisition->getUserName(), '0', 1, 'L');
        $pdf->Cell(20, 5, "Status:", '0', 0, 'R');
        $pdf->Cell(50, 5, $requisition->getStatusName(), '0', 1, 'L');
       
        $pdf->Ln(5);        
        $pdf->SetFont('Arial','B','10');
        $pdf->Cell(30, 7, "Codigo", 'B', 0, 'C');
        $pdf->Cell(70, 7, "Descripcion", 'B', 0, 'L');
        $pdf->Cell(30, 7, utf8_decode("Tamaño"), 'B', 0, 'L');
        $pdf->Cell(30, 7, "Cantidad", 'B', 0, 'R');
        $pdf->Cell(30, 7, "Producidos", 'B', 1, 'R');      
       
        $pdf->SetFont('Arial','','8');
        $detalles = $requisition->getRequisitionDetailsSaved($idRequisition);
        $totalQuantity = 0;
        $totalDelivery = 0;
        
        foreach($detalles as $detalle){      
            $totalQuantity += $detalle['quantity'];
            $totalDelivery += $detalle['delivery'];
            
            $pdf->Cell(30, 5, htmlentities($detalle['code']), 'B', 0, 'C');
            $pdf->Cell(70, 5, utf8_decode($detalle['description']), 'B', 0, 'L');
            $pdf->Cell(30, 5, utf8_decode($detalle['size']), 'B', 0, 'L');
            $pdf->Cell(30, 5, number_format($detalle['quantity'],2), 'B', 0, 'R');
            $pdf->Cell(30, 5, number_format($detalle['produced'],2), 'B', 1, 'R');
        }      
        
        $pdf->SetFont('Arial','B','10');
        $pdf->Cell(130, 5, 'Total', 'T', 0, 'R');
        $pdf->SetFont('Arial','','8');
        $pdf->Cell(30, 5, number_format($totalQuantity,2), 'T', 0, 'R');
        $pdf->Cell(30, 5, number_format($totalDelivery,2), 'T', 1, 'R');
        /*        
        //Crear codigo
        QRcode::png('?re='.$empresa->getRFC().'&rr='.$requisition->getRFC().'&tt='.$requisition->getTotalParaCodigoQR().'&id='.$requisition->getUUID(),PATH_TEMP_DOCS."qrCode".$requisition->getSerie()."-".$requisition->getFolio().".png",'Q',3); // creates file
        $pdf->Image(PATH_TEMP_DOCS."qrCode".$requisition->getSerie()."-".$requisition->getFolio().".png",10,165,30,0);
        
        $pdf->ln(12);
       
        */
        if($createFile){
            if(!is_dir(PATH_TEMP_DOCS."requisitions/")){
                mkdir(PATH_TEMP_DOCS."requisitions/",0777,true);
            }
            $pdf->Output(PATH_TEMP_DOCS."requisitions/REQ-".$idRequisition.".pdf","F");
            $this->pathfFileCreated = PATH_TEMP_DOCS."requisitions/REQ-".$idRequisition.".pdf";
        }else{
            $pdf->Output();
        }
    }
    
    public function getPathFileCreated(){
        return $this->pathfFileCreated;
    }
}