<?php
class ReceivingAjax extends ReceivingRepository {
    public $formReceiving = null;
    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setReceivingDetails(array $options) {
        $byCode = null;
        $data = array();
        if(isset($options['byCode'])){$byCode = $options['byCode']; }
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }

        $options = $data;
        #Cuando se da enter en el campo producto del Shipment, el producto se busca por codigo, 
        #el valor del codigo ingresado se almacena en idProducto
        if($byCode){    
            $result = $this->getProductoByCode($options['idProduct']);
            if($result){ 
                $options['idProduct'] = $result['id'];
            }            
        }
        
        $producto = $this->getProductById($options['idProduct']);
        if($producto){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_product'=>$producto['id'],
                'received'=>$options['received'],
                'token_form'=>$options['token_form']); 
            
            $this->insertDetalle($data);
            $receivingDetails = $this->getReceivingDetails($data['token_form']);
            $detalles = $this->listReceivingDetails($receivingDetails);
            
            $json = array(
                'response' => true,
                'receivingDetails' => $detalles['receivingDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
                'receivedItems'=>number_format($detalles['receivedItems'],2)
            );
            
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listReceivingDetails($detalles,$status = null){
        $disabled = null;
        $listDetalles = "";
        $cantidadItems = 0;
        $receivedItems = 0;
        
        if($status == '4'){$disabled = 'disabled';}
        
        foreach($detalles as $detalle){
            $cantidadItems += $detalle['quantity'];
            $receivedItems += $detalle['received'];
            
            $id = $detalle['id'];
            unset($detalle['id']);
            
            $array = json_encode($detalle);
            $listDetalles .= "<tr id='_$id'>  
                <td class='text-left'>                       
                    <a class='btn btn-sm btn-primary $disabled' onclick='setDetailReceivingToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger $disabled' onclick='deleteReceivingDetails($id);'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['code']."</td>
                <td>".$detalle['description']."</td>
                <td>".$detalle['size']."</td>
                <td class='text-right'>".number_format($detalle['quantity'],2)."</td> 
                <td class='text-right'>".number_format($detalle['received'],2)."</td>
                </tr>";
        }
        
        return array('receivingDetails'=>$listDetalles,
                     'totalItems'=>$cantidadItems,
                     'receivedItems'=>$receivedItems
            );
    }
    
    public function getListReceivingDetails($status = null, $tokenForm){
        $receivingDetails = $this->getReceivingDetails($tokenForm);
        $detalles = $this->listReceivingDetails($receivingDetails,$status);

            $json = array(
                'response' => true,
                'receivingDetails' => $detalles['receivingDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
                'receivedItems'=>number_format($detalles['receivedItems'],2)
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $login = new Login();
        $repository = new ReceivingDetailsTempRepository();
        $current_data = $repository->getById($id);
        
        if($repository->updateString(array('received'=>'0')," id = '$id' ",'receivings_details_'.$login->getId())){
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        }else{
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        
        $receivingDetails = $this->getReceivingDetails($current_data['token_form']);
        $detalles = $this->listReceivingDetails($receivingDetails);

        $json = array(
                'response' => true,
                'receivingDetails' => $detalles['receivingDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
                'receivedItems'=>number_format($detalles['receivedItems'],2)
            ); 
            return $json;
    }
    
    public function getShipmentData($options){
        $existReceiving = false;
        $idReceiving = null;
        $numShipment = $options['numShipment'];
        
        $repoReceiving = new ReceivingRepository();
        $data = $repoReceiving->getByNumShipment($numShipment);        
        
        $msg = '';
        if($data){
            $existReceiving = true;
            $idReceiving = $data['id'];
        }else{
            $repo = new ShipmentRepository();
            $rs = $repo->getDataShipment($numShipment);
            if($rs['response'] == true){
                $idReceiving = $repoReceiving->saveUsingDataFromMainServer($rs);
                if($idReceiving){
                    $existReceiving = true;
                }else{
                    $msg = $this->flashmessenger->getMessageString();
                }                
            }else{
                $this->flashmessenger->addMessage(array('warning'=>$rs['msg']));
                $msg = $this->flashmessenger->getMessageString();
            }                  
        }           
                        
        return array(
            'response'=>true,
            'existReceiving'=>$existReceiving,
            'idReceiving'=>$idReceiving,
            'message'=>$msg
        );
    }
}