<?php
require('class.phpmailer.php');
require('class.smtp.php');
class Emailer extends PHPMailer{
    private $error = null;
    private $msgSuccess = 'Correo enviado correctamente.';
    
    public function sendEmail($data) {       
        $this->setConfig();
        $this->setAddAddress($data['to']);

        if(isset($data['cc']) && trim($data['cc'])!=''){$this->setAddCC($data['cc']);}  
        $this->setSubject($data['subject']);
        $this->setMsgHTML($data['message']);
        
        if(isset($data['attachment'])){$this->AddAttachment($data['attachment']);}
        
        if(isset($data['msg-success'])){$this->setMsgSuccess($data['msg-success']);}
        $this->AltBody = 'Para ver este mensaje usa un lector que soporte HTML.';

        $flashmessenger = new FlashMessenger();
        if($this->error == null){
            if($this->Send()){
                $flashmessenger->addMessage(array('success'=>$this->msgSuccess));
                return true;
            }else{
                $flashmessenger->addMessage(array('danger'=>"$this->ErrorInfo"));
                return null;
            }
        }       
    }
    
    public function setSubject($subject){
        if($subject == ''){$subject = SET_FROM_TITLE;}
        $this->Subject = $subject;
    }
    
    public function setMsgSuccess($msg){
        $this->msgSuccess = $msg;
    }
    
    public function setAddAddress($to){        
        $flashmessenger = new FlashMessenger();
        $noEsMail = '';
        if(strpos($to, ',')){
            $destinatarios = explode(',', $to);
            foreach ($destinatarios as $destino){
                echo $destino."</br>";
                if(filter_var(trim($destino), FILTER_VALIDATE_EMAIL)){
                    $this->AddAddress($destino); 
                }else{
                    $noEsMail .= "<li>".$destino."</li>";
                }
            }
          
        }else{
            if(filter_var($to, FILTER_VALIDATE_EMAIL)){
                $this->AddAddress($to);
            }else{
                $noEsMail .= $to;
            } 
        }
        if($noEsMail != ''){
            $this->error = true;
            $flashmessenger->addMessage(array('danger'=>'Correo invalido: '.trim($noEsMail,',')));
        }
    }
    
    public function setAddCC($cc){        
        $flashmessenger = new FlashMessenger();
        $noEsMail = '';
        if(strpos($cc, ',')){
            $destinatarios = explode(',', $cc);
            foreach ($destinatarios as $destino){
                if(filter_var(trim($destino), FILTER_VALIDATE_EMAIL)){
                    $this->AddCC($destino); 
                }else{
                    $noEsMail .= "<li>".$destino."</li>";
                }
            }
          
        }else{
            if(filter_var($cc, FILTER_VALIDATE_EMAIL)){
                $this->AddCC($cc);
            }else{
                $noEsMail .= $cc;
            } 
        }
        if($noEsMail != ''){
            $this->error = true;
            $flashmessenger->addMessage(array('danger'=>'Correo invalido: '.trim($noEsMail,',')));
        }
    }
    
    public function setMsgHTML($msg){
        if($msg ==''){$msg = "Revisar archivo adjunto porfavor.";}
        $this->msgHTML($msg);
    }
    
   public function setConfig(){
       $this->IsSMTP();
        $this->SMTPAuth = true;        
        $this->SMTPSecure ='ssl';
        $this->Host = "mail.lunis.mx";
        #$this->Port = 587;
        $this->Port = 465;
        $this->Username = "noreply@mgsoftwaresolutions.com";
        $this->Password = "M1vc300184@";
        
        $repo = new SettingsEntity();        
        $this->SetFrom(SET_FROM_MAIL, 'PCG - '.$repo->_get('store_name'));
    }   
}