<?php
class SpecialRequisitionForm extends Form {    
    public function __construct() {
        $this->setName('special-requisition');
        $this->setEnctype('multipart/form-data');
        $this->setActionForm('Special-requisition.php');
        $this->setClass('special-requisition form-horizontal');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {              
        $this->addElement(array(
            'type' => 'text',
            'name' => 'status'
        ));
        
        $attributes_wrapper_append_select = array('class'=>'select2-bootstrap-append');        
        $attributes_wrapper_append_date = array('id'=>'datePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'validators'=>array('datetime'),
            //'optionals'=>array('disabled'=>true), //Andres <- agreggue esta propiedad
            'optionals'=>array('readOnly'=>'readOnly'),
            'value'=>date('m/d/Y H:i'),
            'required'=>true,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'type',
            'label'=>'Tipo',
            'multiOptions'=>array('Line'=>'Linea','Special'=>'Especial'),
            'value'=>'Special',
            #'optionals'=>array('onclick'=>'alertClearDetails()','onchange'=>'clearSpecialRequisitionDetails();setUnsetCategoryField()'),
            'optionals'=>array('onclick'=>'setUnsetCategoryField()'),
            'required'=>false,
            'col-size-label'=>'12',
            'col-size-element'=>'12',
        )); 
        
        
        $attributes_wrapper_append_date = array();
        $append = "<span class = 'btn input-group-addon' id = 'deliveryDatePicker'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'delivery_date',
            'label'=>'Fecha entrega',
            'validators'=>array('datetime'),
            'optionals'=>array('readOnly'=>'readOnly'),
            'required'=>true,
            'append'=>$append,
            //'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        $append = "<span class = 'btn input-group-addon' data-action='insert' onclick='setModalCliente(this)'><i class='fa fa-plus'></i></span>";
        $append .= "<span class = 'btn input-group-addon' data-action='edit' onclick='setModalCliente(this)'><i class='fa fa-pencil'></i></span>";
         $this->addElement(array(
            'type' => 'select',
            'name' => 'customer',
            'label'=>'Cliente',
            'multiOptions'=>$this->getListCustomers(),
            'optionals'=>array('onclick'=>'setCustomerData()'),
            'append'=>$append,
            'required'=>true
        ));  
         
         $this->addElement(array(
            'type' => 'select',
            'name' => 'discount',
            'label'=>'',
            'multiOptions'=>array(0=>"0%", 15=>"15%"),
            'value'=>'0'
        )); 
         
        $this->addElement(array(
            'type' => 'text',
            'name' => 'phone',
            'label'=>'Telefono',
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'email',
            'label'=>'Correo electronico',
            'required'=>false
        ));
        
         $this->addElement(array(
            'type' => 'select',
            'name' => 'home_service',
            'label'=>'Servicio a domicilio',
            'multiOptions'=>array('No'=>'No','Si'=>'Si'),
            'required'=>true
        )); 
         
        $append = "<span class = 'btn input-group-addon' id = 'paymentDate_datepicker'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'payment_date',
            'label'=>'Fecha de pago',
            'validators'=>array('date'),
            'optionals'=>array('readOnly'=>'readOnly'),
            'required'=>true,
            'append'=>$append,
        ));
         
         $this->addElement(array(
            'type' => 'text',
            'name' => 'company_name',
            'label'=>'Empresa/ Negocio',
            'required'=>false
        ));
         
        $this->addElement(array(
            'type' => 'text',
            'name' => 'address',
            'label'=>'Direccion',
            'required'=>false
        )); 
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'zip_code',
            'label'=>'Codigo postal',
            'required'=>false
        )); 
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'city',
            'label'=>'Ciudad',
            //'multiOptions'=>array('Mcallen'=>'Mcallen','Mission'=>'Mission'),
            'required'=>false
        )); 
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status_delivery',
            'label'=>'Status',
            'multiOptions'=>array('1'=>'Pendiente de entrega','2'=>'Entregada'),
            'required'=>true
        )); 
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status_payment',
            'label'=>'Pago',
            'multiOptions'=>array('1'=>'Pendiente','2'=>'Pagada'),
            'optionals'=>array('disabled'=>true),
            'required'=>true
        ));  
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments',
            'col-size-element'=>'12',
            'required'=>false
        ));   
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments_1',
            'col-size-element'=>'12',
            'required'=>false
        ));   
        
        $this->addElement(array(
            'type' => 'file',
            'name' => "image[]",
            'class' => 'upload imagesInput',
            'required' => false,
            'col-size-element'=>'12',
            'optionals' => array(
                'title' => 'Adjuntar imagen de producto',
                'multiple'=>''
            ),
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'special_quantity',
            'label'=>'Cantidad de especiales',
            'required'=> true,
            'validators'=>array('double'),
            'col-size-label'=>'6',
            'col-size-element'=>'5',
        ));                       
       
         
         /*se utiliza para poder saber si es para maquiladora*/
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        ));  
         /*Num requisicion con prefijo*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'req_number',
            'required'=>false
        )); 
         
        $this->addElement(array(
            'type' => 'select',
            'name' => 'category',
            'label'=>'Categoria',
            'multiOptions'=>$this->listCategories('Partes del pastel'),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
        ));
         
         /*When type = 'specia' THEN key = id_slice  value = flavorName*/
         $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
         $this->addElement(array(
            'type' => 'select',
            'name' => 'product',
            'label'=>'Producto',
            'multiOptions'=>array(''=>'Seleccionar una opcion...'),
            'optionals'=>array('onChange'=>'setProductPrice()'),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
            'append'=>$append

         ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'label'=>'Cantidad',
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'price',
            'label'=>'Precio',
            'required'=>false,
            //'optionals'=>array('readOnly'=>'readonly'),
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'multiple',
            'label'=>'PE #',
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'ammount',
            'value'=>'0',
            //'optionals'=>array('readOnly'=>'readonly'),
            'required'=>true,
            'class'=>'text-right',
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'ammount_payments',
            'value'=>'0',
            'required'=>true,
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-default',
            'optionals'=>array('onClick'=>'setSpecialRequisitionDetails()')
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'terminar',
            'value'=>$this->_getTranslation('Terminar'),
            'class'=>'btn btn-primary',
            'optionals'=>array("onClick"=>"submit('requisition')")
        ));   
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'subTotal',
            'required'=>false
        ));  
    }
    
    public function getListCustomers(){
        $repository = new ClienteRepository();
        $result = $repository->getListaSelectClientes();

         $array = array('' => 'Seleccionar una opcion...');
        if ($result) {           
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function listCategories($type = null){
        $repository = new CategoriaRepository();
        $result = $repository->getListaSelectCategorias($type);
        
        $array = array('0' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function getListProducts(){
        $repository = new SliceRepository();
        #1 = status activo
        $productos = $repository->getListSelectSlice();
        
        $list = array(''=>'Seleccionar una opcion...');
        foreach ($productos as $key => $value) {
            $list[$key] = $value;
        }
        return $list;
    }
    
    
    public function populate($data) { 
        $tools = new Tools();        
        if(isset($data['date']) && substr_count($data['date'], '-') > 0){
           $data['date'] = $tools->setFormatDateTimeToForm($data['date']);
        }
        
        if(isset($data['payment_date']) && $tools->isValidaDateYYYMMDD($data['payment_date'])){
            $data['payment_date'] = $tools->setFormatDateToForm($data['payment_date']);
        }
        
        if(isset($data['delivery_date']) && substr_count($data['delivery_date'], '-') > 0){
            //echo $tools->setFormatDateTimeToForm($data['delivery_date']);exit;
           $data['delivery_date'] = $tools->setFormatDateTimeToForm($data['delivery_date']);
        }
        parent::populate($data);
    } 
}