<?php
class VentaDetallesTempRepository extends EntityRepository {

    private $table = 'ventasdetalles_';
    private $lastIdInsertForSale = null;
    private $options = array(
        
    );
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    
    public function getLastInsertId() {
        return $this->lastIdInsertForSale;
    }
    
    // Guarda en temporal
    public function save(array $data, $table = null) {         
        if(isset($data['idDetalleTemp']) && trim($data['idDetalleTemp'])!= ''){
            $result = $this->getById($data['idDetalleTemp']);
            if($result){
                $id = $data['idDetalleTemp'];
                unset($data['idDetalleTemp']);      
                return $this->updateDetalleTemp($id, $data);
            }
         }
        
        unset($data['idDetalleTemp']);
        $data['status'] = '1';
        $query = "SELECT id,cantidad FROM ".$this->table.
                 " WHERE idProducto = ".$data['idProducto'].
                 " AND precio = '".$data['precio']."'";
        
        $result = $this->query($query);
        if($result->num_rows > 0 && GROUP_ITEMS_ON_SALE === true){
            $result = $result->fetch_object();
            $data['cantidad'] = $data['cantidad'] + $result->cantidad;
            $id = $result->id;
            
            return $this->updateDetalleTemp($id, $data);
        }else{
            return $this->saveDetalleTemp($data);
        }
    }
    
    public function saveDetalleTemp($data){         
        /*OBTENER VALOR DE BASCULA CUANDO ES PAN POR LIBRA*/
        $settings = new SettingsEntity();
        $panPorLibra = $settings->_get('id_pan_por_libra');            
        if(238 == $data['idProducto']){
            $balanceValueQuery = "SELECT `value` FROM scale_value WHERE id = 1";
            $balanceValueResult  = parent::query($balanceValueQuery);
            
            if($balanceValueResult->num_rows > 0){
                $balanceValue = $balanceValueResult->fetch_object();
                $data['cantidad'] = $balanceValue->value;
            }           
        }
        
        #Variables que pueden venir vacias, pero necesitan ser enteros
        if($data['descuento_item_valor']== ''){$data['descuento_item_valor'] = 0;}
        if($data['descuento_orden_valor']== ''){$data['descuento_orden_valor'] = 0;}
        
        #Informacion de impuestos que aplica a producto
        $repoImpuestos = new ImpuestosRepository();
        $dataImpuestos = $repoImpuestos->getById($data['impuestos']);
        $data['impuestos_tasa'] = $dataImpuestos['impuestos_tasa'];
        
        #Precio sin impuestos de producto
        $precioSinImpuestos = $data['precio'];
        $data['precio_sin_impuestos'] =  $precioSinImpuestos;
        
        if($data['impuestos_incluidos'] == 'si'){
            $precioSinImpuestos = round($data['precio']/(1+$dataImpuestos['impuestos_tasa']/100),2); 
            $data['precio_sin_impuestos'] =  round($precioSinImpuestos,2);
        }        
        
        #Descuento por Item y Descuento de Orden
        #Descuento por item
        $descuentoItem = 0;
        if($data['descuento_item_tipo'] == 'porcentaje' && $data['descuento_item_valor'] !== '0'){
            $descuentoItem = $precioSinImpuestos * ($data['descuento_item_valor']/100);      
            
        }elseif($data['descuento_item_tipo'] == 'monto' && $data['descuento_item_valor'] !== '0'){
            $descuentoItem = $data['descuento_item_valor'];
        }
        
        $precioSinImpuestos -= $descuentoItem;
        $data['descuento_item_monto'] = $descuentoItem * $data['cantidad'];      
        
        #Descuento po orden, solo se aplica si es porcentaje
        $descuentoOrden = 0;
        $data['descuento_orden_monto'] = 0;
        if($data['descuento_orden_tipo'] == 'porcentaje' && $data['descuento_orden_valor'] !== '0'){
            $descuentoOrden = $precioSinImpuestos * ($data['descuento_orden_valor']/100);
            $precioSinImpuestos -= $descuentoOrden;
            $data['descuento_orden_monto'] = $descuentoOrden * $data['cantidad'];              
        }   
        
        #subtotal para calcular impuestos
        $precioSinImpuestos = $precioSinImpuestos * $data['cantidad']; 
        
        #Calculo de Impuestos
        $data['impuestos_monto'] = round( ($precioSinImpuestos) * ($dataImpuestos['impuestos_tasa']/100) ,2);      
        
        unset($data['id'],$data['descuento_orden_tipo'],$data['descuento_orden_valor']);
        parent::save($data, $this->table);    
        
        $this->lastIdInsertForSale = parent::getInsertId();
    }
    
    public function updateDetalleTemp($id,$data){           
        #Variables que pueden venir vacias, pero necesitan ser enteros
        if($data['descuento_orden_valor']== ''){$data['descuento_orden_valor'] = 0;}
        if($data['descuento_item_valor']== ''){$data['descuento_item_valor'] = 0;}
        
        #Informacion de impuestos que aplica a producto
        $repoImpuestos = new ImpuestosRepository();
        $dataImpuestos = $repoImpuestos->getById($data['impuestos']);
        $data['impuestos_tasa'] = $dataImpuestos['impuestos_tasa'];
        
        #Precio sin impuestos de producto
        $precioSinImpuestos = $data['precio'];
        $data['precio_sin_impuestos'] =  $precioSinImpuestos;
        
        if($data['impuestos_incluidos'] == 'si'){
            $precioSinImpuestos = round($data['precio']/(1+$dataImpuestos['impuestos_tasa']/100),2); 
            $data['precio_sin_impuestos'] =  round($precioSinImpuestos,2);
        }        
        
        #Descuento por Item y Descuento de Orden
        #Descuento por item
        $descuentoItem = 0;
        if($data['descuento_item_tipo'] == 'porcentaje' && $data['descuento_item_valor'] !== '0'){
            $descuentoItem = $precioSinImpuestos * ($data['descuento_item_valor']/100);      
            
        }elseif($data['descuento_item_tipo'] == 'monto' && $data['descuento_item_valor'] !== '0'){
            $descuentoItem = $data['descuento_item_valor'];
        }
        
        $precioSinImpuestos -= $descuentoItem;
        $data['descuento_item_monto'] = $descuentoItem * $data['cantidad'];           
        
        #Descuento por orden, solo se aplica si es porcentaje
        $descuentoOrden = 0;
        if($data['descuento_orden_tipo'] == 'porcentaje' && $data['descuento_orden_valor'] !== '0'){
            $descuentoOrden = $precioSinImpuestos * ($data['descuento_orden_valor']/100);
            $precioSinImpuestos -= $descuentoOrden;
            $data['descuento_orden_monto'] = $descuentoOrden * $data['cantidad'];                
        }   
        
        #subtotal para calcular impuestos
        $precioSinImpuestos = $precioSinImpuestos * $data['cantidad'];
        
        #Calculo de Impuestos
        $data['impuestos_monto'] = round( ($precioSinImpuestos) * ($dataImpuestos['impuestos_tasa']/100),2); 
       
        unset($data['id'],$data['idVenta'],$data['descuento_orden_tipo'],$data['descuento_orden_valor']); 
        parent::update($id,$data, $this->table);    
    }
    
    public function setDescuentoOrden($options){        
        $query = "SELECT * FROM $this->table WHERE status = '1' ";
        $result = $this->query($query);
        if($result->num_rows > 0){           
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $data['descuento_orden_tipo'] = 'porcentaje';
                $data['descuento_orden_valor'] = $options['descuento_orden_valor'];
                $this->updateDetalleTemp($data['id'], $data);
            }
        }
    }
    
    public function getPorcentajeDescuentoDandoMonto($monto){
        $query = "SELECT IFNULL(SUM(precio_sin_impuestos - descuento_item_monto),0)as subtotal"
                . " FROM $this->table WHERE status = '1'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $subtotal = $result->subtotal;
            
            $porcentaje = ($monto * 100)/$subtotal;
            return $porcentaje;
        }
    }
    
    // Guarda en tabla ventasdetalles
    public function saveDetalles($idVenta,$ticket){
        $login = new Login();
        $fecha= date('Y-m-d H:i:s');
        
        $query = "SELECT * FROM $this->table WHERE status = '1' ";
        $result = $this->query($query);
        if($result->num_rows > 0){           
            $result = $this->resultToArray($result); 
            
            $repoInventario = new InventarioRepository();                  
           
            foreach($result as $data){   
                unset($data['id']);                
                $data['idVenta'] = $idVenta;   
                $data['ticket'] = $ticket;
                $data['creado_por'] = $login->getId();
                $data['creado_fecha'] = $fecha;
          
                if(parent::save($data, 'ventasdetalles')){                   
                    if(!$repoInventario->subInventory(array(
                        'id_product'=>$data['idProducto'],
                        'quantity'=>$data['cantidad'],
                        'sucursal'=>$login->getSucursal(),
                        'controller'=>'Venta-agregar '.$idVenta))){
                        return null;
                    }
                }else{
                    return null;
                }
            }             
        }    
        return true;
    } 
    
    public function saveDetallesVentaSuspendida($idVentaSuspendida){     
        $query ="UPDATE $this->table SET status = '2',idVenta = '$idVentaSuspendida' WHERE status = '1'";
        $result = $this->query($query);
        
        if($result){
            return $result;
        }
        
        return null;
    }
    
    public function activarVentaSuspendida($idVentaSuspendida){
        $this->clearDetalles();
        $query = "UPDATE $this->table SET status = '1' WHERE idVenta = '$idVentaSuspendida' AND status = '2'";
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        return null;
    }
    
    public function delete($id, $table = null) {        
        return parent::delete($id, $this->table);
    }
    
    public function isThereItemsOnSale(){
        $query = "SELECT count(id) as rows FROM ".$this->table." WHERE status = '1'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            if($result->rows <= 0){
                return null;
            }
            return true;
        }
        return null;
    }
    
    public function truncateIfIsEditInfo(){
        $query = "SELECT idVenta FROM .".$this->table." LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            if($result->idVenta !=NULL || $result->idVenta != ''){
                $this->truncate();
                return true;
            }
        }        
        return null;
    }
    
    public function clearDetalles(){
        $query = "DELETE FROM $this->table WHERE status != '2'";
        $result = $this->query($query);
        
        if($result){
            return true;
        }        
        return null;
    }
    
    public function truncate(){
        $query = "TRUNCATE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function drop(){
        $query = "DROP TABLE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function setVentaDetallesById($idVenta){
        $this->query("TRUNCATE ".$this->table);
        $query = "INSERT INTO ".$this->table." (idVenta,idProducto,cantidad,descripcion,precio,immpuestos,descuento,cuentaContable)
                    SELECT idVenta,idProducto,cantidad,descripcion,precio,impuetos,descuento,cuentaContable FROM ventasdetalles WHERE idVenta = '$idVenta'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }        
        return null;
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }    

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('pfa' => 'usuario'));
    }
    
    public function getTotalesVenta(){
        $query = "SELECT "
                . "ROUND(SUM(precio_sin_impuestos * cantidad),2)as importe,"
                . "ROUND(SUM(descuento_item_monto),2)as descuento_items_monto,"
                . "ROUND(SUM(descuento_orden_monto),2)as descuento_orden_monto,"
                . "ROUND(SUM((precio_sin_impuestos * cantidad) - (descuento_item_monto + descuento_orden_monto)),2)as subtotal,"
                . "ROUND(SUM(impuestos_monto),2)as total_impuestos,"
                . "ROUND(SUM((precio_sin_impuestos * cantidad) - (descuento_item_monto + descuento_orden_monto) + impuestos_monto),2) as total_venta "
                . "FROM $this->table "
                . "WHERE status = '1' "
                . "GROUP BY idVenta";
        
        $result = $this->query($query);
        
        if($result->num_rows >0){
            return $this->resultToArray($result)[0];
        }        
        
        return null;
    }
    
    public function deleteVentaSuspendida($idVentaSuspendida){
        $this->startTransaction();
        $query = "DELETE FROM $this->table WHERE idVenta = '$idVentaSuspendida' AND status = '2'";
        $result = $this->query($query);
        
        if($result){
            if(parent::delete($idVentaSuspendida, 'ventas_suspendidas')){
                $this->commit();
                return true;
            }
        }        
        $this->rollback();
        return null;
    }
    
    public function getTableName(){
        return $this->table;
    }
}