<?php
class StoreInRepository extends EntityRepository {

    private $table = 'store_in';
    public $flashmessenger = null;
     private $options_files = array(
        'allowedExtensions'=>array('pdf'),
        'maxFileSizeAllowed'=>1000000,
        'pathToSave'=>PATH_PURCHASE_INVOICES
    );
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    
    public function saveFiles($files,$idCompra,$numFactura){       
        $file = new UploadFile();
        $file->setAllowedExtensions($this->options_files['allowedExtensions']);
        $file->setMaxFileSizeAllowed($this->options_files['maxFileSizeAllowed']);
        $file->setTempFolder($this->options_files['pathToSave']);
   
        $rsUpload = $file->uploadFile($files['invoice_file'],null,"Factura_de_compra_".$idCompra."_".$numFactura); 
        $rsUpload = $file->uploadFile($files['credit_note_file'],null,"Nota_de_credito".$idCompra."_".$numFactura); 
        
        if(!$rsUpload){
            $this->flashmessenger->addMessage(array('info'=>$file->getMessageError()));  
            return null;
        }        
        
        return true;        
    }

    public function save(array $data, $table = null) {     
        /* Valida que Vendor Invoice y Lote no esten registrados */
        $isValid = $this->validarReferencias($data);
        if($isValid === null) return null;
        
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $data['status'] = '1';
        $data['payments'] = 0;        
        if(trim($data['credit_note_amount']) === ''){$data['credit_note_amount'] = 0;}
        //$data['due_date'] = $tools->setFormatDateToDB($data['due_date']);
        
        /*Se obtiene informacion de pago en esta parte, porque en el fomulario de insert y edit estos campos estan deshabilitados*/
            $storeInAjax = new StoreInAjax();
            $vendorPaymentData = $storeInAjax->getVendorMethodPayment(array('vendor'=>$data['vendor'],'date'=>$data['date']));
            $data['method_payment'] = $vendorPaymentData['method_payment'];
            $data['credit_days'] = $vendorPaymentData['credit_days'];
            $data['due_date'] = $tools->setFormatDateToDB($vendorPaymentData['due_date']);
        /**/       
        
        $invoice_file = $data['invoice_file'];
        unset($data['invoice_file']);   
        
        if($data['id']==null || $data['id']==''){unset($data['id']);}
        
        $this->startTransaction();        
        $rs = parent::save($data, $this->table);        
        
        if($rs){
            $storeInDetailsTemp = new StoreInDetailsTempRepository();
            $idCompra = $this->getInsertId();
            $this->setLastInsertId($idCompra);//Para utilizarlo en el Controller action insert

            if($storeInDetailsTemp->saveDetalles($idCompra)){   
                $this->commit();
                $storeInDetailsTemp->drop();

                if($invoice_file['invoice_file']['name']!='' || $invoice_file['credit_note_file']['name']!=''){          
                    $this->saveFiles($invoice_file,$idCompra,$data['reference']);
                }
                return true;
            }
        }        
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }
    
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status'] == '3'){return true;}
        
        $this->startTransaction();
        $rs = parent::update($id, array('status'=>'3'), $this->table);
        
        if($rs){
            $repoInventorySupplie = new InventorySupplieRepository();
            $detalles = $this->getStoreInDetailsSaved($id);
            foreach ($detalles as $detalle){
                if(!$repoInventorySupplie->subInventory($detalle)){
                    $this->rollback();
                    return null;
                }
            }
            $this->commit();
            return true;
        }
        $this->rollback();
        return null;
    }

    public function update($id, $data, $table = null) {        
        $isValid = $this->validarReferencias(array(
                                    'id'=>$id,
                                    'reference'=>$data['reference'],
                                    'vendor'=>$data['vendor']
                ));
        if($isValid === null){return null;}
      
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);        
        if(trim($data['credit_note_amount']) === ''){$data['credit_note_amount'] = 0;}
        
        /*Se obtiene informacion de pago en esta parte, porque en el fomulario de insert y edit estos campos estan deshabilitados*/
            $storeInAjax = new StoreInAjax();
            $vendorPaymentData = $storeInAjax->getVendorMethodPayment(array('vendor'=>$data['vendor'],'date'=>$data['date']));
            $data['method_payment'] = $vendorPaymentData['method_payment'];
            $data['credit_days'] = $vendorPaymentData['credit_days'];
            $data['due_date'] = $tools->setFormatDateToDB($vendorPaymentData['due_date']);
        /**/               
        
        unset($data['payments']);
        if(trim($data['status']) == ''){unset($data['status']);}
        $invoice_file = $data['invoice_file'];
        unset($data['invoice_file']);   
        
        $this->startTransaction();
        $result = parent::update($id, $data, $this->table);        
        if($result){
            $repository = new StoreInDetailsTempRepository();
            if($repository->updateDetalles($id)){                   
                $this->commit();
                $repository->drop();   
                
                 if($invoice_file['invoice_file']['name']!='' || $invoice_file['credit_note_file']['name']!=''){    
                    $this->saveFiles($invoice_file,$id,$data['reference']);
                }               
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function validarReferencias($data){
        $result = true;
        $referencia = $this->existeReferencia($data['id'],$data['reference'],$data['vendor']);
        if($referencia){
            $this->flashmessenger->addMessage(array(
                'info'=>$this->_getTranslation('Este Num. Factura ya fue utilizada en Compra:').' #'.$referencia['id']));
            $result =  null;
        }
        
        return $result;
    }
    
    public function existeReferencia($id,$reference,$vendor){
       $query = "SELECT * FROM store_in_reference_vendor "
               . "WHERE reference = '$reference' "
               . "AND vendor = '$vendor' "
               . "AND id != '$id' "
               . "AND status != 3"; 
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%d/%m/%Y')as formatedDate,"
                . "DATE_FORMAT(due_date,'%d/%m/%Y')as formatedDueDate,"
                . "(total - IFNULL(payments,0)) as saldo_pendiente,"
                . "fxGetVendorName(vendor) as vendorName,"
                . "fxGetFormaPagoName(method_payment) as methodPaymentName,"
                . "fxGetStatusName(status,'status','storeIn')as statusName, "
                . "fxGetUserName(creado_por) as userName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('compras' => 'id')," AND status = 2 AND (type != 'BienesyServicios' AND type != 'Consigna' AND type != 'MateriaPrima')");
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        $query = "DROP TABLE IF EXISTS store_in_details_".$login->getId();
        $this->query($query);
        
        $query = "CREATE TABLE IF NOT EXISTS store_in_details_".$login->getId()." 
                 (  `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_store_in` int(11) NULL,
                    `idProduct` int(11) NOT NULL,
                    `description` varchar(255) NOT NULL,
                    `quantity` double NOT NULL,
                    `cost` double NOT NULL,
                    `cost_without_tax` double NOT NULL,
                    `discount` double NOT NULL,
                    `discount_type` char(15) NOT NULL,
                    `discount_amount` double NOT NULL,
                    `discount_general` double NOT NULL,
                    `discount_general_type` char(15) NOT NULL,
                    `discount_general_amount` double NOT NULL,
                    `taxes` int(11) NOT NULL,
                    `taxes_rate` double NOT NULL,
                    `taxes_amount` double NOT NULL,
                    `taxes_included` CHAR(50) NOT NULL,
                    `amount` double NOT NULL,
                    `total` double NOT NULL,
                    `expiration_date` date NULL,
                    `location` int(11) NOT NULL,                    
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $storeInDetailsTemp = new StoreInDetailsTempRepository();
        
        return $storeInDetailsTemp->save($data);
    }
    
    public function getStoreInDetails(){
        $login = new Login();
        $query = "SELECT v.*,
                    v.id as idDetailTemp,
                    p.code,
                    fxGetImpuestoName(v.taxes)as taxName,
                    IF(idProduct != 0,v.idProduct,v.description)as product,
                    fxGetCategoryDescription(p.category)as category,
                    fxGetBrandDescription(p.brand)as brand,
                    fxGetPresentationDescription(p.presentation)as presentation
                  FROM store_in_details_".$login->getId()." v LEFT JOIN supplies p
                  ON v.idProduct = p.id
                  ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getStoreInDetailSaved($id){
        $query = "SELECT c.*,
                    p.code as code
                    FROM store_in_details c LEFT JOIN supplies p ON c.idProduct = p.id
                    WHERE c.id = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result)[0];
            return $result;
        }
        
        return null;
    }
    
    public function getStoreInDetailsSaved($id){
        $query = "SELECT c.*,
                    p.code as code,
                    fxGetImpuestoName(c.taxes)as taxName
                    FROM store_in_details c LEFT JOIN supplies p ON c.idProduct = p.id
                    WHERE c.id_store_in = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setStoreInDetailsById($idCompra){
        $repository = new StoreInDetailsTempRepository();
        
        return $repository->setStoreInDetailsById($idCompra);
    }
    
    public function truncateIfIsEditInfo(){
        $repository = new StoreInDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
        
    }
    
    public function getProductById($idProducto){
        $query = "SELECT * FROM supplies WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    public function getListStoreIn(){          
        $query = "SELECT c.*,
                DATE_FORMAT(c.date,'%d/%m/%Y')as date,
                (total - payments)as balance,
                fxGetStatusName(c.`status`,'status','storeIn')as statusName,
                fxGetVendorName(c.vendor) as vendor
                FROM store_in c
                WHERE  1=1 " 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        return null;
  }
  
  public function getListSelectLocations(){
        $query = "SELECT * FROM supplies_location ORDER BY id ASC";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->description;
            }            
            return $array;
        }
        
        return null;
    }
    
    public function getDueDate($date,$creditDays){
        $query = "SELECT DATE_ADD('{$date}',INTERVAL $creditDays DAY)as due_date";
        $result = $this->query($query);
        
        if($result){
            $result = $result->fetch_object();
            return $result->due_date;
        }
        return '';
    }
    
    public function getListFacturaPendientesByProveedor($options){
      $idProveedor =  $options['proveedor'];
      $query = "SELECT f.*,
                fxGetVendorName(f.vendor)as proveedorName,
                DATE_FORMAT(convert(substring(f.date,1,10),date),'%d/%m/%Y')as fecha,
                DATE_FORMAT(due_date,'%d/%m/%Y') as fecha_pago,
                (total - IFNULL(payments,0))as saldo_pendiente
                FROM store_in f
                WHERE  1=1
                AND status != '3'
                AND (total - IFNULL(payments,0)) > '0'
                AND vendor = '$idProveedor' "
              . "GROUP BY f.id "
              . "ORDER BY f.id ASC";
      
      $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        return null;
  }
  
  public function getListMetodoPago(){
        $query = "SELECT id,descripcion FROM formas_metodos_pago WHERE tipo = 'Metodo pago'";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->descripcion;
            }
            
            return $array;
        }
    }  
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
}