<?php
class SpecialRequisitionRepository extends EntityRepository {

    private $table = 'special_requisitions';
    private $images = null;
    private $options_image = array(
        'allowedExtensions'=>array('image/jpg','image/jpeg','image/png','image/gif'),
        'maxFileSizeAllowed'=>16384
    );
    public $flashmessenger = null;
    
    private $options = array (        
        'req_number'=>null,
        'date' => null,
        'payment_date' => null,
        'customer'=>null,
        'customerName'=>null,
        'delivery_date'=>null,
        'home_service'=>null,
        'company_name'=>null,
        'address'=>null,
        'zip_code'=>null,
        'city'=>null,
        'phone'=>null,
        'email'=>null,
        'discount'=>null,
        'special_quantity'=>null,
        'ammount'=>null,
        'ammount_payments'=>null,
        'store'=>null,
        'status'=>null,
        'comments'=>null,
        'subTotal'=>null,
        'comments_1'=>null,
        'status'=>null,
        'status_baked'=>null,
        'status_payment'=>null,
        'status_delivery'=>null       
        );
    
    private $options_aux = array(
        'storeName'=>null,
        'statusName'=>null,
        'deliveryStatusName'=>null,
        'userName'=>null,
        'customerName'=>null,
        'delivery_date_formated'=>null,
        'parqueName'=>null,
        'token_form'=>null
    );
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
  
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    
    public function setImage($images){
        $this->images = $images;
    }
    
    public function resizeImage($image,$type){      
        $maxWidth = 480;
        
        switch($type){
            case 'image/jpeg':
            case 'image/jpg':
                $originImage = imagecreatefromjpeg($image);
                break;
            
            case 'image/png': 
                $originImage = imagecreatefrompng($image);
                break;
                
            case 'image/gif': 
                $originImage = imagecreatefromgif($image);
                break;
        }
        
        $originWidth = imagesx($originImage);
        $originHeight = imagesy($originImage);
        
        
        if($originWidth > $originHeight){
            #Es una imagen horizontal    
            $newWidth = $maxWidth;
            $newHeight = $maxWidth * $originHeight/$originWidth;
        }else{
            #Es una imagen vertical
            $newHeight = $maxWidth;
            $newWidth = $maxWidth * $originWidth/$originHeight;
        }
        
        $newImage = imagecreatetruecolor($newWidth, $newHeight); #tamano de nueva imagen
        imagecopyresized($newImage, $originImage, 0, 0, 0, 0, $newWidth, $newHeight, $originWidth, $originHeight);

        switch($type){
            case 'image/jpeg':
            case 'image/jpg':
                imagejpeg($newImage, $image);
                break;
            
            case 'image/png': 
                imagepng($newImage, $image);
                break;
                
            case 'image/gif': 
                imagegif($newImage, $image);
                break;
        }
       
    }
    
    public function saveImage($reqNumber){      
        try {
            $upload = new UploadFile();     
            if($this->images['name'][0] != ''){
                $images = array();

                for($i=0; $i <= count($this->images['name'])-1; $i++){
                    if (in_array($this->images['type'][$i], $this->options_image['allowedExtensions']) && $this->images['size'][$i] <= $this->options_image['maxFileSizeAllowed'] * 1024){
                        $imagen_temporal = $this->images['tmp_name'][$i];

                        // Tipo de archivo
                        $tipo = $this->images['type'][$i]; 
                        $size = $this->images['size'][$i];                             

                        $file = array(
                            'name' => "Image_$i.".$upload->getExtension($this->images['name'][$i]),
                            'tmp_name' => $this->images['tmp_name'][$i],
                            'size' =>  $this->images['size'][$i],
                            'type' => $this->images['type'][$i]
                        );

                        $upload->uploadFile($file);
                        $uploadedFile = $upload->getUploadedFile();
                        $uploadedFile = end($uploadedFile);
                        $this->resizeImage($uploadedFile, $tipo);                               

                        // Leemos contenido y escapamos caracteres especiales
                        $data = file_get_contents($uploadedFile);
                        //$data = addslashes($data);

                        $array = array(
                            'req_number'=>$reqNumber,
                            'image'=>$data,
                            'type'=>$tipo,
                            'size'=>$size
                        );

                        parent::save($array, 'images');

                        /*Array Para server principal */
                        $images[] = array(
                            'req_number'=>$reqNumber,
                            'image'=>$data,
                            'size' =>  $this->images['size'][$i],
                            'type'=> $this->images['type'][$i]
                        );      

                    }else{
                        $this->flashmessenger->addMessage(array(
                        'danger'=>$this->_getTranslation("Formato de archivo no permitido o excede el tamaÃƒÂ±o lÃƒÂ­mite de {$this->options_image['maxFileSizeAllowed']} Kbytes.")));
                        return null;
                    }
                }

                #Guardar en servidor principal
                /*
                $dbMainServer = new MainServerRepository();
                $dbMainServer->saveImageForSR($images);
                 * */
            }
            return true;
        } catch (Exception $exc) {
            echo $this->flashmessenger->addMessage(array('danger'=>$exc->getMessage()));
            return null;
        }

        
    }
    
    public function getImages($reqNumber){
        $query = "SELECT * FROM images WHERE req_number = '$reqNumber'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function setOptions($data){ 
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }    
    
    public function getTokenForm(){
        return $this->options_aux['token_form'];
    }
        
    public function getCustomerName(){
        return $this->options['customerName'];
    }

    public function getCreadoPorNombre(){
        return $this->options_user['userName'];
    }
    
    public function getCompanyName(){
        return $this->options['company_name'];
    }
    
    public function getStatus() {
       return $this->options['status'];
    }
    
    public function getUserName(){
        return $this->options_aux['userName'];
    }
    
    public function getStatusName(){
        return $this->options_aux['statusName'];
    } 
    
    public function getDeliveryStatusName(){
        return $this->options_aux['deliveryStatusName'];
    }
    
    public function getReqNumber() {
       return $this->options['req_number'];
    }
    
    public function getType() {
        return 'Especial';
       #return $this->options['type'];
    }
    
     public function getAmmount(){
        return $this->options['ammount'];
    }
    
    public function getBalance(){
        return $this->options['ammount'] - $this->options['ammount_payments'];
    }
    
    public function getDate() {
       return $this->options['date'];
    }
    
    public function getFormatDate(){
        $date = substr($this->getDate(), 0, 10);
        $date = strftime('%m/%d/%Y',  strtotime($date));
        return $date;
    }
    
    public function setDeliveryDate($deliveryDate){
        $this->options['delivery_date'] = $deliveryDate;
    }
    
    public function getDeliveryDate() {
       return $this->options['delivery_date'];
    }
  
    
    public function getFormatDeliveryDate(){
        return $this->options_aux['delivery_date_formated'];
    }
    
    public function getStoreName() {
       return $this->options_aux['storeName'];
    }
    
     public function getMinDate(){
        $hoy = new DateTime();
        $entrega = new DateTime($this->getDeliveryDate());       
        $diff = $hoy->diff($entrega);

        if($diff->invert == 0){
            return date('Y-m-d');
        }elseif($diff->invert == 1){
           return $this->getDeliveryDate();
        }
    }
    
    public function getTelefono() {
       return $this->options['phone'];
    }   
    
    public function getAddress() {
       return $this->options['address'];
    }
    
    public function getCity() {
       return $this->options['city'];
    }
    
    public function getComments() {
       return $this->options['comments'];
    }
    
    public function getComments1() {
       return $this->options['comments_1'];
    }   
    
    public function getListPayments(){
        $repo = new VentaRepository();
        return $repo->getPaymentsByIdSpecialRequisition($this->getId());
    }
    
    public function getSaldoPendiente($idReq){
        $totalPayments = $this->getTotalPayments($idReq);
        $saldoPendiente = $this->getAmmount() - $totalPayments;
        if($saldoPendiente > 0){
            $this->updateString(array('status_payment'=>'1','ammount_payments'=>$totalPayments), " id = '$idReq'");
            
        }else{
             $this->updateString(array('status_payment'=>'2','ammount_payments'=>$totalPayments), " id = '$idReq'");
        }
        
        return $saldoPendiente;
    }
        
    public function showImages(){
        $images = $this->getImages($this->getReqNumber());
        if(!$images){ return null;}
        
        $string = "<div class='galleryForSpecialRequisition'>";        
        foreach($images as $image){     
            $string .= '<div class="thumbail col-md-6">'
                    . '<img src="data:'.$image['type'].';base64,'.base64_encode( $image['image'] ).'"/>'
                    . '<div class="col-lg-12 col-md-12 col-xs-12 text-right">'
                        . '<a class="btn btn-xs btn-danger" data-id="'.$image['id'].'" onclick="deleteImage(this)"><i class="fa fa-trash"></i> Eliminar</a>'
                    . '</div>'
                    . '</div>';
            
        }
        
        return $string."</div>";
    }
    
    public function showImagesForProductionAndBakedPlan(){
        /*No muestra boton para eliminar*/
        $images = $this->getImages($this->getReqNumber());
        if(!$images){ return null;}
        
        $string = "<div class='galleryForSpecialRequisition'>";        
        foreach($images as $image){     
            $string .= '<div class="thumbail col-md-6">'
                    . '<img src="data:'.$image['type'].';base64,'.base64_encode( $image['image'] ).'"/>'
                    . '</div>';
            
        }
        
        return $string."</div>";
    }

    public function save(array $data, $table = null) {  
        $login = new Login();
        $tools = new Tools();
        $data['creado_por'] = $login->getId();
        $data['creado_fecha'] = date('Y-m-d H:i:s');
        $data['date'] = $tools->setFormatDateTimeToDB($data['date']);
        $data['payment_date'] = $tools->setFormatDateToDB($data['payment_date']);
        $data['status'] = '1';
        $data['status_production'] = '1';
        $data['status_baked'] = '1';
        $data['status_delivery'] = '1';
        $data['status_payment'] = '1';
        $data['store'] = $login->getSucursal();
        
        if(trim($data['delivery_date']) == ''){
            unset($data['delivery_date']);
        }else{
            $data['delivery_date'] = $tools->setFormatDateTimeToDB($data['delivery_date']);
        }
        
        $customerRepo = new ClienteRepository();
        $customerData = $customerRepo->getById($data['customer']);
        $data['customerName'] = $customerData['nombre'];
        
        $this->startTransaction();        
        parent::save($data, $this->table);        
        
        $storeInDetailsTemp = new SpecialRequisitionDetailsTempRepository();
        $idRequisition = $this->getInsertId();
        $this->setLastInsertId($idRequisition);//Para utilizarlo en el Controller action insert
        
        $reqNumber = $this->getPrefixNumberRequisition().str_pad($idRequisition, 7, '0', STR_PAD_LEFT);
        $this->updateString(array('req_number'=>$reqNumber), " id = '$idRequisition' ");
        
        if($storeInDetailsTemp->saveDetalles($idRequisition,$reqNumber, $this->getTokenForm())){ 
            if(!$this->saveImage($reqNumber)){
                $this->rollback();
                return null;
            }
            
            $this->commit();
            $storeInDetailsTemp->truncate($this->getTokenForm());

            return true;
        }
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'danger'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }
    
    public function delete($id, $table = null) {
        //return parent::delete($id, $this->table);
        return parent::update($id, array('status'=>'2'), $this->table);
    }

    public function update($id, $data, $table = null) {              
        $tools = new Tools();
        $login = new Login();
        $data['ultima_mod_por'] = $login->getId();
        $data['ultima_mod_fecha'] = date('Y-m-d H:i:s');
        $data['date'] = $tools->setFormatDateTimeToDB($data['date']);
        $data['payment_date'] = $tools->setFormatDateToDB($data['payment_date']);
        
        if(trim($data['delivery_date']) == ''){
            unset($data['delivery_date']);
        }else{
            $data['delivery_date'] = $tools->setFormatDateTimeToDB($data['delivery_date']);
        }

        $customerRepo = new ClienteRepository();
        $customerData = $customerRepo->getById($data['customer']);
        $data['customerName'] = $customerData['nombre'];
        
        $reqNumber = $data['req_number'];
        unset($data['status'],$data['status_supplies'],$data['status_baked'],$data['status_production'],$data['status_payment'],$data['req_number'],$data['store'],$data['creado_por_nombre']);
        $this->startTransaction();
 
        //Actualizo tabla compras
        $result = parent::update($id, $data, $this->table);
        
        if($result){
            $repository = new SpecialRequisitionDetailsTempRepository();
            if($repository->updateDetalles($id,$reqNumber, $this->getTokenForm())){       
                if(!$this->saveImage($reqNumber)){
                    $this->rollback();
                    return null;
                }
   
                $this->commit();
                $repository->truncate($this->getTokenForm());   
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }
    //modificar para pxgetparque
    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "fxGetStoreName(store)as storeName,"                
                . "DATE_FORMAT(delivery_date,'%m/%d/%Y %h:%i %p')as delivery_date_formated,"
                . "DATE_FORMAT(delivery_date,'%m/%d/%Y')as delivery_date_american_format,"                      
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetClienteName(customer)as customerNameAux,"
                . "fxGetStatusName(status,'status','Special-requisition')as statusName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        
        //var_dump($select); exit;
        $result = $this->query($select);
        
        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
    public function getByReqNumber($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%m/%d/%Y')as dateFormated,"
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetClienteName(customer)as customerNameAux,"
                . "fxGetStatusName(status,'status','Special-requisition')as statusName, "
                . "fxGetStatusName(status,'delivery_status','Special-requisition')as deliveryStatusName "

                . "FROM $this->table "
                . "WHERE req_number = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('store-out' => 'requisition'));
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        
        $query = "CREATE TABLE IF NOT EXISTS special_requisitions_details_".$login->getId()." 
                 (  
                    `token_form` char(50) NOT NULL,
                    `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_requisition` int(11) NULL,
                    `type` varchar(25) NOT NULL,
                    `id_product` int(11) NOT NULL,
                    `quantity` double NOT NULL,
                    `price` double NOT NULL,
                    `multiple` CHAR(50) NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $storeInDetailsTemp = new SpecialRequisitionDetailsTempRepository();
        
        return $storeInDetailsTemp->save($data);
    }
    
    public function getRequisitionDetailsSupplies($reqNumber){
        $query = "SELECT v.*,
                    fxGetCategoriaDescripcion(slice_category)as slice_category,
                    CONCAT(id_supplie,'-',slice_category)as id_supplie,
                    v.id as idDetailTemp,
                    p.id as product,
                    p.codigo,
                    p.descripcion,
                    fxGetUnidadMedidaDescripcion(p.unidad_de_medida)as um
                  FROM requisitions_details_supplies v LEFT JOIN supplies p
                  ON v.id_supplie = p.id
                  WHERE v.req_number = '$reqNumber'
                  ORDER BY fxGetCategoriaDescripcion(slice_category) ";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getRequisitionDetails($type = null,$token_form){
        $login = new Login();        
        $query = "SELECT v.*,
                    s.category,
                    v.id_product as product,                    
                    v.id as idDetailTemp,
                    p.id as l_product,
                    p.codigo as l_code,
                    fxGetCategoriaDescripcion(p.categoria)as l_category,
                    p.descripcion as l_description,
                    fxGetTamanoDescripcion(p.tamano)as l_size,
                    s.id as s_product,                      
                    fxGetCategoriaDescripcion(s.category)as s_category,
                    s.flavor as s_description,
                    fxGetTamanoDescripcion(s.size)as s_size
                  FROM special_requisitions_details_".$login->getId()." v 
                      LEFT JOIN productos p ON v.id_product = p.id AND v.type = 'Line'
                      LEFT JOIN slices s ON v.id_product = s.id AND v.type = 'Special'
                    WHERE token_form = '$token_form' 
                  ORDER BY multiple ASC,category ASC";
        
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }    
    
    public function getRequisitionDetailsForSpecial($idRequisition){      
        $query = "SELECT v.*,
                    s.category,
                    v.id_product as product,                    
                    v.id as idDetailTemp,
                    s.id as s_product,                      
                    fxGetCategoriaDescripcion(s.category)as s_category,
                    s.flavor as s_description,
                    fxGetTamanoDescripcion(s.size)as s_size
                  FROM special_requisitions_details v 
                      LEFT JOIN slices s ON v.id_product = s.id 
                      WHERE v.type = 'Special' AND id_requisition = '$idRequisition'
                  ORDER BY multiple ASC,category ASC";
        
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }    
    
    public function getRequisitionDetailsSaved($id,$forProductionScreen = null){        
        if($forProductionScreen == null){
           $query = "SELECT
                    v.id_requisition,
                    v.id as idDetailTemp,
                    v.`type`,
                    v.multiple,
                    v.id_product,
                    p.id as product,
                    p.codigo as code,
                    p.descripcion as description,
                    fxGetTamanoDescripcion(p.tamano)as size,
                    fxGetCategoriaDescripcion(p.categoria)as category,
                    v.quantity,v.produced,v.`status`,
                    p.punitarioventa as price
                    FROM special_requisitions_details v,productos p 
                    WHERE v.id_product = p.id AND v.`type` = 'Line'
                    AND v.id_requisition = '$id'
                    UNION
                    SELECT 
                    v.id_requisition,
                    v.id as idDetailTemp,
                    v.`type`,
                    v.multiple,
                    v.id_product,
                    s.id as product,
                    '' as code,
                    s.flavor as description,
                    fxGetTamanoDescripcion(s.size)as size,
                    fxGetCategoriaDescripcion(s.category)as category,
                    v.quantity,v.produced,v.`status`,
                     s.price as price
                    FROM special_requisitions_details v,slices s 
                    WHERE v.id_product = s.id AND v.`type` = 'Special'
                    AND v.id_requisition = '$id'";
        }else{
            $query = "SELECT v.id_requisition,v.id as idDetailTemp,v.`type`,       
                    v.id_product,
                    p.id as product,
                    p.codigo as code,
                    p.descripcion as description,
                    fxGetTamanoDescripcion(p.tamano)as size,
                    fxGetCategoriaDescripcion(p.categoria)as category,
                    v.quantity,
                    p.punitarioventa as price
                    FROM special_requisitions_details v,productos p 
                    WHERE v.id_product = p.id AND v.`type` = 'Line'
                    AND v.id_requisition = '$id'
                    UNION
                    SELECT r.id as id_requisition,r.id as idDetailTemp,'Special' as `type`,
                    '0' as id_product,
                    '0' as product,
                    '' as code,
                    'Especial' as description,
                    '' as size,
                    '' as category,
                    r.special_quantity,
                    SUM(d.price * d.quantity) as price
                    FROM special_requisitions r,special_requisitions_details d
                    WHERE r.id = d.id_requisition AND r.id = '$id' AND type = 'Special'";
        }        
        
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setRequisitionDetailsById($idCompra, $tokenForm){
        $repository = new SpecialRequisitionDetailsTempRepository();
        
        return $repository->setRequisitionDetailsById($idCompra, $tokenForm);
    }
    
    public function truncateIfIsEditInfo(){
        $repository = new SpecialRequisitionDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
        
    }
    
    public function getProductById($idProducto,$type){
        if($type=='Line'){
           $query = "SELECT *,punitarioventa as price FROM productos WHERE id = '$idProducto' LIMIT 1"; 
        }elseif($type=='Special'){
            $query = "SELECT * FROM slices WHERE id = '$idProducto' LIMIT 1";
        }
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    public function getListRequisitions($options = null){         
        $store = null;
        $customer  = null;
        $home_service  = null;
        $status = null;
        $date = null;
        $limit = null;        

        if($options != null){          

            $date = $this->createFilterFecha($options, 'delivery_date');      
            if(isset($options['store']) && $options['store']!='0'){$store = " AND r.store = '".$options['store']."'";}     
            if(isset($options['customer']) && $options['customer']!=''){$customer = " AND customerName like '%".$options['customer']."%'";}
            if(isset($options['home_service']) && $options['home_service']!='0'){$home_service = " AND home_service = '".$options['home_service']."'";}
            if(isset($options['status']) && $options['status']!='0'){$status = " AND r.status = '".$options['status']."'";}                

        }else{
          $limit = " LIMIT 150 ";
          
        }        
 
       $query = "SELECT r.*,
                fxGetStoreName(store)as storeName,
                DATE_FORMAT(r.date,'%m/%d/%Y')as date,                
                DATE_FORMAT(r.delivery_date,'%m/%d/%Y %h:%i %p')as delivery_date,
                DATE_FORMAT(delivery_date,'%m/%d/%Y')as delivery_date_american_format,
                DATE_FORMAT(r.delivery_date,'%H:%i ')as delivery_time,
                fxGetClienteName(r.customer) as customerNameAux,
                r.phone,                
                fxGetStatusName(r.`status`,'status','Special-requisition')as statusName,      
                fxGetStatusName(r.`status_delivery`,'status_delivery','Special-requisition')as statusDeliveryName,
                fxGetStatusName(r.`status_payment`,'status_payment','Special-requisition')as statusPaymentName,
                fxGetStatusName(r.`status_production`,'status_production','Special-requisition')as statusProductionName
                FROM special_requisitions r, special_requisitions_details d
                WHERE r.id = d.id_requisition"
              . "$store "
              . "$customer "
              . "$home_service "
              . "$status "
              . "$date " 
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC $limit ";
    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
   public function getListRequisitionsHorneado($options = null){          
        $store = null;
        $customer  = null;
        $home_service  = null;
        $status = null;
        $status_production = null;
        $date = null;
        $limit = null;
        
        if($options != null){
            $date = $this->createFilterFecha($options, 'delivery_date');      
            if(isset($options['store']) && $options['store']!='0'){$store = " AND store = '".$options['store']."'";}
            if(isset($options['customer']) && $options['customer']!=''){$customer = " AND customerName like '%".$options['customer']."%'";}
            if(isset($options['home_service']) && $options['home_service']!='0'){$home_service = " AND home_service = '".$options['home_service']."'";}
            if(isset($options['status']) && $options['status']!='0'){$status = " AND r.status = '".$options['status']."'";}
            if(isset($options['status_production']) && $options['status_production']!='0'){$status_production = " AND status_production = '".$options['status_production']."'";} 
        }else{
          $limit = " LIMIT 150";
        }
        
       $query = "SELECT r.*,
                fxGetStoreName(store)as storeName,
                DATE_FORMAT(r.date,'%d/%m/%Y')as date,                
                DATE_FORMAT(r.delivery_date,'%d/%m/%Y')as delivery_date,
                DATE_FORMAT(r.delivery_date,'%m/%d/%Y')as delivery_date_american_format,
                DATE_FORMAT(r.delivery_date,'%H:%i ')as delivery_time,
                fxGetCustomerName(r.customer) as customer,
                r.phone,
                fxGetStatusName(r.`status`,'status','Special-requisition')as statusName,                
                fxGetStatusName(r.`status_baked`,'status_baked','Special-requisition')as statusBakedName,
                fxGetStatusName(r.`status_supplies`,'status_supplies','Special-requisition')as statusSuppliesName,
                fxGetStatusName(r.`status_production`,'status_production','Special-requisition')as statusProductionName,
                fxGetStatusName(r.`status_delivery`,'status_delivery','Special-requisition')as statusDeliveryName,
                fxGetStatusName(r.`status_payment`,'status_payment','Special-requisition')as statusPaymentName
                FROM special_requisitions r, special_requisitions_details d
                WHERE r.id = d.id_requisition AND status_baked = '2' 
                 $store "
              . "$customer "
              . "$home_service "
              . "$status "
              . "$status_production "
              . "$date" 
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC $limit ";
    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
  public function getTotalRequiredAndProduced(){
      /* Se debe setear $this->setId para que este disponible en este query*/
      $query = "SELECT SUM(totalRequired)as totalRequired,SUM(totalProduced)as totalProduced FROM ("
                . "SELECT "
                . "SUM(quantity)as totalRequired,"
                . "SUM(produced)as totalProduced "
                . "FROM special_requisitions_details "
                . "WHERE id_requisition = '{$this->getId()}' AND `type` = 'Line' "
                . "UNION "
                . "SELECT "
                . "special_quantity as totalRequired, "
                . "produced as totalProduced "
                . "FROM $this->table "
                . "WHERE id = '{$this->getId()}')as t";              
              
      $result = $this->query($query);
      
      if($result){
          $result = $result->fetch_object();
          return $result;
      }
      return null;
  }
  
    
  public function getPrefixNumberRequisition(){
      $query = "SELECT * FROM settings WHERE `key` = 'operations_prefix'";
      $result = $this->query($query);
      
      if($result){
          $result = $result->fetch_object();
          return $result->value;
      }
      return null;
  }
  
  public function getListRequisitionsByIds($ids){          
        $query = "SELECT r.*,
                fxGetStoreName(r.store)as storeName,
                DATE_FORMAT(r.date,'%m/%d/%Y')as date,                
                DATE_FORMAT(r.delivery_date,'%m/%d/%Y')as delivery_date,
                DATE_FORMAT(r.delivery_date,'%H:%i ')as delivery_time,
                fxGetClienteName(r.customer) as customer,
                r.phone,
                fxGetStatusName(r.`status`,'status','Special-requisition')as statusName,                
                fxGetStatusName(r.`status_delivery`,'status_delivery','Special-requisition')as statusDeliveryName,
                fxGetStatusName(r.`status_payment`,'status_payment','Special-requisition')as statusPaymentName
                FROM special_requisitions r, special_requisitions_details d
                WHERE r.id = d.id_requisition
                AND find_in_set(r.id,'$ids')" 
              . "GROUP BY r.id "
              . "ORDER BY r.date ASC ";
    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
   public function getBakedPlan($idRequisitions){
        $query = "SELECT SUM(quantity)as quantity,flavor,categoryName,CONCAT(categoryName,'_',flavor)as pan,id_slice,sizeName FROM ("
            . "SELECT "
            . "SUM(srd.quantity)as quantity,"
            . "s.flavor, "
            . "fxGetCategoriaDescripcion(s.category)as categoryName, "
            . "s.id as id_slice, "
            . "fxGetTamanoDescripcion(s.size)as sizeName,"
            . "UUID() "
            . "FROM $this->table sr, special_requisitions_details srd, slices s "
            . "WHERE sr.id = srd.id_requisition "
            . "AND srd.id_product = s.id "
            . "AND find_in_set(sr.id,'$idRequisitions') "
            . "AND sr.status = 1 "
            . "AND srd.type = 'Special' "
            . "AND find_in_set(s.category,'1,3,4,5,6,7,8,9,32,33,34,35,36,37,38,39,40,41,42,43,44,46,48,49,50,51,52,53,54,55,56,57,58,59,61,62,63') " // Son las categoria de pan
            . "GROUP BY s.id "
                
            . "UNION "
                
            . "SELECT "
            . "SUM(srd.quantity * p.quantity)as quantity,"
            . "s.flavor, "
            . "fxGetCategoriaDescripcion(s.category)as categoryName, "
            . "s.id as id_slice, "
            . "fxGetTamanoDescripcion(s.size)as sizeName,"
            . "UUID() "
            . "FROM $this->table sr, special_requisitions_details srd, products_details p, slices s "
            . "WHERE sr.id = srd.id_requisition "
            . "AND srd.id_product = p.id_product "
            . "AND p.id_slice = s.id "
            . "AND find_in_set(sr.id,'$idRequisitions') "
            . "AND sr.status = 1 "
            . "AND srd.type = 'Line' "
            . "AND find_in_set(s.category,'1,3,4,5,6,7,8,9,32,33,34,35,36,37,38,39,40,41,42,43,44,46,48,49,50,51,52,53,54,55,56,57,58,59,61,62,63') " // Son las categoria de pan
            . "GROUP BY s.id )r "            
            . "GROUP BY id_slice ORDER BY flavor,sizeName";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result;
        }
        return null;
   }
   
   public function getSpecialProductionPlan($idRequisitions){
        $query = "SELECT * FROM ("
            . "SELECT "
            . "s.category,"
            . "sr.req_number,"
            . "multiple,"
            . "SUM(srd.quantity)as quantity,"
            . "s.flavor, "
            . "s.id as id_slice, "
            . "fxGetTamanoDescripcion(s.size)as sizeName, "
            . "fxGetCategoriaDescripcion(s.category)as categoryName "
            . "FROM $this->table sr, special_requisitions_details srd, slices s "
            . "WHERE sr.id = srd.id_requisition "
            . "AND srd.id_product = s.id "
            . "AND find_in_set(sr.id,'$idRequisitions') "
            . "AND sr.status = 1 "
            . "AND srd.type = 'Special' "
            . "AND (find_in_set(s.category,'1,3,4,5,6,7,8,9,32,33,34,35,36,37,38,39,40,41,42,43,44,46,48,49,50,51,52,53,54,55,56,57,58,59,61,62,63,2,31,60'))"
            . "GROUP BY srd.req_number,s.category,srd.id "
                
            . "UNION "
                
            . "SELECT "
            . "s.category,"
            . "sr.req_number,"
            . "multiple,"
            . "SUM(srd.quantity * p.quantity)as quantity,"
            . "s.flavor, "
            . "s.id as id_slice, "
            . "fxGetTamanoDescripcion(s.size)as sizeName, "
            . "fxGetCategoriaDescripcion(s.category)as categoryName "
            . "FROM $this->table sr, special_requisitions_details srd, products_details p, slices s "
            . "WHERE sr.id = srd.id_requisition "
            . "AND srd.id_product = p.id_product "
            . "AND p.id_slice = s.id "
            . "AND find_in_set(sr.id,'$idRequisitions') "
            . "AND sr.status = 1 "
            . "AND srd.type = 'Line' "
            . "AND (find_in_set(s.category,'1,3,4,5,6,7,8,9,32,33,34,35,36,37,38,39,40,41,42,43,44,46,48,49,50,51,52,53,54,55,56,57,58,59,61,62,63,2,31,60'))"
            . "GROUP BY srd.req_number,s.category,srd.id )r "            
            . "ORDER BY multiple,flavor,sizeName";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result;
        }
        return null;
    }
   
    public function getMaxMinDateFromIdsRequisitions($idsRequisition){
        $idsRequisition = implode(',',$idsRequisition);
        $query = "SELECT "
               . "DATE_FORMAT(MIN(delivery_date),'%m/%d/%Y')as startDate,"
               . "DATE_FORMAT(MAX(delivery_date),'%m/%d/%Y')as endDate "
               . "FROM $this->table "
               . "WHERE find_in_set(id,'$idsRequisition')";
        
        $result = $this->query($query);
        if($result->num_rows >0){
            $result = $this->resultToArray($result);
            return $result[0];
        }
    }
    
    public function getTotalPayments($idReq){
        $query = "SELECT *,"
                . "IFNULL(SUM(total_venta),0)as monto "
                . "FROM ventas "
                . "WHERE id_special_requisition = '$idReq' "
                . "AND status != 3 ";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            return $result->monto;
        }
        
        return 0;
    }
    
    public function descontarInventarioBySRId($id){
        $query = "SELECT srd.*,sr.store "
                . "FROM special_requisitions sr, special_requisitions_details srd  "
                . "WHERE sr.id = srd.id_requisition "
                . "AND type = 'Line' "
                . "AND sr.id = '$id'";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            
            $login = new Login();
            $repoInventario = new InventarioRepository();
            foreach($result as $producto){
                $repoInventario->subInventory(array(
                    'id_product'=>$producto['id_product'],
                    'quantity'=>$producto['quantity'],
                    'sucursal'=>$producto['store'],
                    'controller'=>"Ordenes especiales - entregada $id"
                ));
            }
        }
        
        return true;
    }
    
    public function agregarInventarioBySRId($id){
        $query = "SELECT srd.*,sr.store "
                . "FROM special_requisitions sr, special_requisitions_details srd  "
                . "WHERE sr.id = srd.id_requisition "
                . "AND type = 'Line' "
                . "AND sr.id = '$id'";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            
            $login = new Login();
            $repoInventario = new InventarioRepository();
            foreach($result as $producto){
                $repoInventario->addInventory(array(
                    'id_product'=>$producto['id_product'],
                    'quantity'=>$producto['quantity'],
                    'sucursal'=>$producto['store'],
                    'controller'=>"Ordenes especiales - eliminar entrega $id"
                ));
            }
        }
        
        return true;
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND DATE($campoFecha) BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND DATE($campoFecha) BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND DATE($campoFecha) BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
    
    #Home dashboard
    public function getListRequisitionsPendingToDelivery(){ 
        $query = "SELECT
            r.*,
            fxGetStoreName ( store ) AS storeName,
            DATE_FORMAT( r.date, '%m/%d/%Y' ) AS DATE,
            DATE_FORMAT( r.delivery_date, '%m/%d/%Y %h:%i %p' ) AS delivery_date,
            DATE_FORMAT( delivery_date, '%m/%d/%Y' ) AS delivery_date_american_format,
            DATE_FORMAT( r.delivery_date, '%H:%i ' ) AS delivery_time,
            fxGetClienteName ( r.customer ) AS customerNameAux,
            r.phone,
            fxGetStatusName ( r.`status`, 'status', 'Special-requisition' ) AS statusName,
            fxGetStatusName ( r.`status_delivery`, 'status_delivery', 'Special-requisition' ) AS statusDeliveryName,
            fxGetStatusName ( r.`status_payment`, 'status_payment', 'Special-requisition' ) AS statusPaymentName,
            fxGetStatusName ( r.`status_production`, 'status_production', 'Special-requisition' ) AS statusProductionName 
        FROM
            special_requisitions r,
            special_requisitions_details d 
        WHERE
            (DATE(r.delivery_date) BETWEEN DATE_SUB(CURRENT_DATE(), INTERVAL 1 DAY) AND DATE_ADD(CURRENT_DATE(), INTERVAL 5 DAY)) AND
            r.id = d.id_requisition AND
            r.status != 2 AND
            r.status_delivery = 1
        GROUP BY
            r.id 
        ORDER BY
            r.delivery_date ASC";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
    }
    
    public function getSpecialOrderByDateRange($start,$end,$group = null){
        if($group){$group = " GROUP BY store";}
        
        $date = $this->createFilterFecha(array('startDate'=>$start,'endDate'=>$end),'date');
        $query = "SELECT "
                . "fxGetStoreName(store)as store_name, "
                . "SUM(ammount)as total_sales,"
                . "COUNT(1)as total_orders "
                . "FROM $this->table "
                . "WHERE 1 = 1 AND status != 2 $date $group ORDER BY total_sales DESC ";
        
        $result = $this->query($query);
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
}