<?php
class SliceDetailsTempRepository extends EntityRepository {

    private $table = 'slices_details_';
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {        
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                 parent::delete($id,$this->table);
            }
         }
        
        unset($data['idDetailTemp']);           
        $query = "SELECT id,quantity FROM ".$this->table.
                " WHERE id_supplie = ".$data['id_supplie'];
        
        $result = $this->query($query);       

        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['quantity'] = $data['quantity'] + $result->quantity;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            return parent::save($data, $this->table);
        }
    }
    
    // Guarda en tabla comprasdetalles
    public function saveDetalles($idCompra){
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        if($result->num_rows > 0){
           
            $result = $this->resultToArray($result);
            
            foreach($result as $data){
                unset($data['id']);
                unset($data['id_detail']); 
                $data['id_slice'] = $idCompra;
                
                parent::save($data, 'slices_details');
            }            
        }

        return true;
    } 
    
    public function updateDetalles($idSlice){
        $query = "SELECT id FROM slices_details WHERE id_slice = '$idSlice'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOrigin = $this->resultToArray($result);
        }
        
        $query = "SELECT * FROM $this->table";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $idsDetalles = array();
        
            $result = $this->resultToArray($result);
            foreach($result as $data){
                $idDetalle = $data['id_detail'];
                unset($data['id']);
                unset($data['id_detail']);            
                $data['id_slice'] = $idSlice;
              
                if(!$idDetalle){
                    parent::save($data, 'slices_details');
                }else{
                    #contiene los idDetalles de la compra original que se mantendran, lo que no esten aqui se eliminaran.
                    $idsDetalles[] = $idDetalle;
                    parent::update($idDetalle,$data, 'slices_details');         
                }  
            }
        }

        #Se eliminan ids de tabla comprasdetalls que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la compra despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){
                    parent::delete($detalle['id'], 'slices_details');
                }
            }
        }  
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    
    public function truncateIfIsEditInfo(){
        $query = "SELECT id_slice FROM .".$this->table." LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            if($result->id_slice !=NULL || $result->id_slice != ''){
                $this->truncate();
                return true;
            }
        }
        
        return null;
    }
    
    public function truncate(){
        $query = "TRUNCATE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function drop(){
        $query = "DROP TABLE ".$this->table;
        $result = $this->query($query);
        
        if($result){
            return true;
        }        
        return null;
    }
    
    public function setSliceDetailsById($idSlice){
        $this->query("TRUNCATE ".$this->table);
        $query = "INSERT INTO ".$this->table." (id_detail,id_slice,id_supplie,quantity)
                    SELECT id,id_slice,id_supplie,quantity
                    FROM slices_details 
                    WHERE id_slice = '$idSlice'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null) {
        if(isset($data['id_slice'])){
            if($data['id_slice']=='' || !$data['id_slice']){
                unset($data['id_slice']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}