<?php
/**
 * Description of Producto
 * @author carlos
 */
class ProductoEntity extends ProductoRepository{
    private $options = array (        
        'type'=>null,
        'mostrar_en_menu'=>null,
        'nombre_para_menu'=>null,
        'codigo' => null,
        'descripcion' => null,
        'tamano' => null,
        'categoria' => null,
        'marca' => null,
        'presentacion' => null,
        'unidad_de_medida'=>null,
        'costo'=>null,       
        'punitarioventa' => null,
        'pmayoreoventa' => null,
        'descuento'=>null,
        'impuestos'=>null,
        'impuestos_incluidos'=>null,
        'stock_minimo'=>null,
        'creado_por'=>null,
        'creado_fecha'=>null,
        'modificaciones'=>null,
        'status'=>null
     );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getPreciosVenta(){
        $array = array(
            $this->options['punitarioventa']=>'Precio menudeo - $'.$this->options['punitarioventa'],
            $this->options['pmayoreoventa']=>'Precio mayoreo - $'.$this->options['pmayoreoventa']
        );
        
        return $array;
    }
    
    public function getDescripcion(){
        return $this->options['descripcion'];
    }
}