<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class ProductionRepository extends EntityRepository {

    private $table = 'production';

    public function save(array $data, $table = null) {
        $login = new Login();
        $settings = new SettingsEntity();
        $data['idSucursal'] = $settings->_get('store_default_production');        
        $data['status'] = 1;
        $data['creado_fecha'] = date('Y-m-d');
        $data['creado_por'] = $login->getId();
        
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        
        unset($data['modificaciones']);
        $this->startTransaction();
        $result = parent::save($data, $this->table);
        if($result){
            
            $repoInventory = new InventarioRepository();            
            $add = $repoInventory->addInventory(array(
                    'id_product'=>$data['id_product'],
                    'quantity'=>$data['quantity'],
                    'sucursal'=>$data['idSucursal'],
                    'controller'=>'Produccion-insertar'.$idProduction
                ));
            
            if($add){
                $this->commit();
                return true;                
            }
        }
        $this->rollback();
        return null;
    }
    
    public function delete($id, $table = null) {
        $data = $this->getById($id);
        if($data['status']=='2'){return true;}
        
        $this->startTransaction();
        $result = parent::update($id, array('status'=>'2'), $this->table);
        
        if($result){
            $repoInventory = new InventarioRepository();
            
            $add = $repoInventory->subInventory(array(
                    'id_product'=>$data['id_product'],
                    'quantity'=>$data['quantity'],
                    'sucursal'=>$data['idSucursal'],
                    'controller'=>'Produccion-eliminar'.$id
                ));
            
            if($add){
                $this->commit();
                return true;                
            }
        }
        $this->rollback();
        return null;
    }

    public function update($id, $data, $table = null) {        
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        
        $originData = $this->getById($id);
        $this->startTransaction();
        unset($data['creado_fecha'],$data['creado_por'],$data['status'],$data['modificaciones']);
        $result = parent::update($id, $data, $this->table);
        if($result){
            $repoInventory = new InventarioRepository();
            
            if($originData['id_product'] != $data['id_product']){
                $change = $repoInventory->changeProduct(array(
                        'origin_id_product'=>$originData['id_product'],
                        'origin_quantity'=>$originData['quantity'],
                        'origin_sucursal'=>$originData['idSucursal'],
                        'id_product'=>$data['id_product'],
                        'quantity'=>$data['quantity'],
                        'sucursal'=>$originData['idSucursal'], #Se mantiene sucursal cuando se edita
                        'controller'=>'Produccion-editar'.$id
                    ));
                
                if($change){
                    $this->commit();
                    return true;
                }
            }
            
            $update = $repoInventory->updateAddInventory(array(
                        'id_product'=>$data['id_product'],
                        'current_quantity'=>$originData['quantity'],
                        'current_sucursal'=>$originData['idSucursal'],
                        'new_quantity'=>$data['quantity'],
                        'new_sucursal'=>$originData['idSucursal'], #Se mantiene sucursal cuando se edita
                        'controller'=>'Produccion-editar'.$id
                    ));
            
            if($update){
                $this->commit();
                return true;
            }            
        }
        $this->rollback();
        return null;
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT pr.*,"
                . "p.codigo,"
                . "fxGetProductoDescripcion(id_product)as productName,"
                . "fxGetTamanoDescripcion(p.tamano)as sizeName,"
                . "CONCAT(fxGetProductoDescripcion(id_product),' ',fxGetTamanoDescripcion(p.tamano),' (',codigo,')')as product, "
                . "DATE_FORMAT(pr.creado_fecha,'%W')as created "
                . " from $this->table pr, productos p "
                . "WHERE pr.id_product = p.id "
                . "AND pr.id = $id ";
        
        $result = $this->query($select);

        if ($result->num_rows > 0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        #return parent::isUsedInRecord($id, array('productos' => 'marca'));
    }
    
     public function getListProduction($options = null) {      
         //var_dump($options);exit;
        $date = $this->createFilterFecha(array('start_date'=>date('m/d/Y'),'end_date'=>date('m/d/Y')), 'date');     
        if($options != null){ 
            $date = $this->createFilterFecha($options, 'date');      
        }
        
        $select = "SELECT pr.*,"
                . "date_format(date,'%m/%d/%Y')as date,"
                . "fxGetProductoDescripcion(id_product)as description,"
                . "fxGetTamanoDescripcion(p.tamano)as sizeName,"                
                . "fxGetUserName(pr.creado_por)as creadoPorName, "
                . "fxGetStatusName(pr.status,'status','Production')as statusName "
                . " from $this->table pr, productos p "
                . "WHERE pr.id_product = p.id"
                . "$date ORDER BY date DESC ";
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
    
     public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['start_date']) && !isset($options['end_date'])){return null;}        
        $startDate = $options['start_date'];
        $endDate = $options['end_date'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND DATE($campoFecha) BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND DATE($campoFecha) BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND DATE($campoFecha) BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
}
