<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class GenericRepository extends EntityRepository {
        
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
     public function getListSelectStores(){          
        $query = "SELECT * FROM stores";
    
        $result = $this->query($query);
        
       if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre'];
            }
            return $array;
        }
        return null;
    }
    
    public function saveRetiro($options){
        $login = new Login();
        if($options['id']===''){            
            $data['monto'] = $options['monto'];   
            $data['store_id'] = $login->getSucursal();
            $data['id_apertura_cierre'] = $options['id_apertura_cierre'];   
            $data['status'] = '1';
            $data['creado_por'] = $login->getId();
            $data['creado_fecha'] = date("Y-m-d H:i:s");
            try{
                $this->save($data, 'retiros');       
                $this->flashmessenger->addMessage(array('success'=>'Genial!! Se registro Retiro con exito.'));
                return $this->getInsertId();
            } catch (Exception $ex) {
                $this->flashmessenger->addMessage(array('danger'=>$ex->getMessage()));
                return null;
            }           
        }else{
            $data['monto'] = $options['monto'];
            $data['ultima_mod_por'] = $login->getId();
            $data['ultima_mod_fecha'] = date("Y-m-d H:i:s");
            try{
                $this->update($options['id'], $data, 'retiros');
                $this->flashmessenger->addMessage(array('success'=>'Genial!! Se actualizo Retiro con exito.'));
                return $options['id'];
            } catch (Exception $ex) {
                $this->flashmessenger->addMessage(array('danger'=>$ex->getMessage()));
                return null;
            }         
        }
    }
    
    public function deleteRetiro($id){
        try{
            $this->update($id,array('status'=>'2'), 'retiros');
            $this->flashmessenger->addMessage(array('success'=>'Hecho!! Se cancelo Retiro con exito.'));
            return true;
        } catch (Exception $ex) {
            $this->flashmessenger->addMessage(array('danger'=>$ex->getMessage()));
            return null;
        }         
    }
    
    public function getListRetiros($idApertura){
        $query = "SELECT *, "
                . "fxGetStatusName(status,'status','Retiro') as status "
                . "FROM retiros "
                . "wHERE id_apertura_cierre = '{$idApertura}'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getSumTotalRetiros($idApertura){
        $query = "SELECT SUM(monto)as total_retiros "
                . "FROM retiros "
                . "wHERE id_apertura_cierre = '{$idApertura}' "
                . "AND status = '1'";
        $result = $this->query($query);
        
        if($result){
            $result = $result->fetch_object();
            return $result->total_retiros;
        }
        return null;
    }
}