<?php
class DevolucionRepository extends EntityRepository {

    private $table = 'devoluciones';

    public function save(array $data, $table = null) {
        $options = $data['options'];
        $login = new Login();
        $options['creado_fecha'] = date('Y-m-d H:i:s');
        $options['creado_por'] = $login->getId();
        $options['idCaja'] = $login->getIdCaja();
        $options['idSucursal'] = $login->getIdCaja();
        $options['status'] = 1;
        unset($options['modificaciones']);
 
        $this->startTransaction();
        $result = parent::save($options, $this->table);
        $idDevolucion = $this->getInsertId();
        $this->setLastInsertId($idDevolucion);
        if($result){
            $devoluciones = $data['detalleDevolucion'];
            foreach($devoluciones as $idVentaDetalle => $cantidad){ 
                #$idVentaDetalle contiene idVentaDetalle y monto por ese detalle. Con formato idVentaDetalle|Monto
                $aux = explode("|", $idVentaDetalle);
                $rs_detalle = $this->saveDetalles(array(
                    'idDevolucion'=>$idDevolucion,
                    'idVentaDetalle'=>$aux[0],
                    'cantidad'=>$cantidad,
                    'monto'=>$aux[1]));
                
                if(!$rs_detalle){
                    $this->rollback();
                    return null;
                }
            }
            $pagos = $data['pagoDevolucion'];
            foreach($pagos as $pago){
                $rs_pago = $this->savePagos(array(
                    'idDevolucion'=>$idDevolucion,
                    'formaPago'=>$pago['formaPagoDevolucion'],
                    'monto'=>$pago['montoDevolucion'],
                    'numDocumento'=>$pago['numDocumentoDevolucion'],
                    'idCaja'=>$login->getIdCaja(),
                    'idSucursal'=>$login->getSucursal()
                ));
                
                if(!$rs_pago){
                    $this->rollback();
                    return null;
                }
            }
            $this->commit();
            return true;
        }
        $this->rollback();
        return null;
    }
    
    public function delete($id, $table = null) {
        $query = "UPDATE $this->table SET status = '2' WHERE id = '$id' ";
        $result = $this->query($query);
        if($result){
            return true;
        }
        return null;
    }

    public function update($id, $data, $table = null) {
        unset($data['status'],$data['fecha_creacion'],$data['creado_por'],$data['modificaciones']);
        return parent::update($id, $data, $this->table);
    }
    
    public function saveDetalles($data){
        return parent::save($data,'devoluciones_detalles');
    }
    
    public function savePagos($data){
        return parent::save($data,'devoluciones_pagos');
    }

    public function getById($id, $table = null,$selectAux = null) {
        $selectAux = "fxGetUserName(creado_por)as usuarioName";
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('' => ''));
    }
    
    public function getDevolucionesByIdVenta($idVenta){
        $query = "SELECT id FROM devoluciones WHERE idVenta = '$idVenta'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $devoluciones = array();
            $result = $this->resultToArray($result);
            foreach ($result as $devolucion){
                $devoluciones[$devolucion] = $this->getDevolucionCompleta($devolucion['id']);
            }
            return $devoluciones;
        }
        return null;
    }
    
    public function getDevolucionCompleta($id){
        $devolucion = $this->getById($id);
        
        $query = "SELECT * FROM devoluciones_detalles WHERE idDevolucion = '$id'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $detalles = $this->resultToArray($result);
            $array = array();
            foreach($detalles as $detalle){
                $array[$detalle['idVentaDetalle']] = $detalle;
            }
        }
        return array(
            'devolucion'=>$devolucion,
            'detalles'=>$array
        );
    }
    
    public function getSumProductosDevueltosPorIdVenta($idVenta){
        $query = "SELECT dd.idVentaDetalle,SUM(dd.cantidad)as cantidadDevolucion "
                . "FROM devoluciones d, devoluciones_detalles dd "
                . "WHERE d.id = dd.idDevolucion "
                . "AND d.idVenta = '$idVenta' "
                . "AND status = '1' "
                . "GROUP BY dd.idVentaDetalle";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            $result = $this->resultToArray($result);
            foreach($result as $devolucion){
                $array[$devolucion['idVentaDetalle']] = $devolucion['cantidadDevolucion'];
            }
            return $array;
        }
        return null;
    }
    
    public function getSumMontoDevolucionesParaArqueo($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        
        $query = "SELECT SUM(devolucion * cantidad)as devoluciones "
                . "FROM view_devoluciones "
                . "WHERE creado_fecha BETWEEN '{$data['fechaApertura']}' AND '{$data['fechaCierre']}' "
                . "AND idCaja = '{$data['idCaja']}' "
                . "AND status = '1' "; 
                
        $result = $this->query($query); 
        if($result){
            $result = $result->fetch_object();
            if($result->devoluciones <= 0){
                return '0';
            }
            return $result->devoluciones;
        }
    }
    
    public function getDevolucionesByIdCierre($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        $currenttime = date('Y-m-d H:i:s');
        
        $query = "select p.formaPago,sum(p.monto)as monto "
                . "FROM devoluciones d, devoluciones_pagos p "
                . "WHERE d.id = p.idDevolucion "
                . "AND creado_fecha BETWEEN '{$data['fechaApertura']}' AND '{$currenttime}'"
                . "AND d.status = '1' "
                . "AND d.idCaja = '{$data['idCaja']}' "
                . "GROUP BY p.formaPago ";
                
        $result = $this->query($query);
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            $array = array();
            $sumTotalDevoluciones = 0;
            
            foreach($result as $row){
                $array[$row['formaPago']] = $row['monto'];
                $sumTotalDevoluciones += $row['monto'];
            }
            
            return array(
                'devolucionesByFormaPago'=>$array,
                'sumTotalDevoluciones'=>$sumTotalDevoluciones
            );
        }
        return null;
    }
    
    public function getDevolucionDetalles($idDevolucion){
        $query = "SELECT d.fechaVenta as fechaVenta, "
                      . "d.fechaDevolucion as fechaDevolucion, "
                      . "v.descripcion, "
                      . "d.cantidad, "
                      . "d.devolucion as montoUnitario "
                . "FROM view_devoluciones d, ventasdetalles v "
                . "WHERE d.idVentaDetalle = v.id "
                . "AND d.idDevolucion = '$idDevolucion'";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getPagosDetalleByIdDevolucion($idDevolucion){
        $query = "SELECT *,"
                . "SUM(monto)as monto,"
                . "fxGetFormaPagoName(formaPago)as formaPagoName "
                . "FROM devoluciones_pagos "
                . "WHERE idDevolucion = '$idDevolucion' GROUP BY formaPago";
        $result = $this->query($query);
        
        if($result){
            return $this->resultToArray($result);
        }
        return null;
    }
}