<?php
class CompanyEntity Extends CompanyRepository{
    private $options = array(
        'name'=>null,
        'address'=>null,        
        'zipcode'=>null,
        'city'=>null,
        'state'=>null,
        'phone'=>null,
        'fax'=>null,
        'email'=>null,
        'webpage'=>null
    );
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function getName(){
        return $this->options['name'];
    }
    
    public function getAddress(){
        return $this->options['address'];
    }
    
    public function getCity(){
        return $this->options['city'];
    }
    
    public function getState(){
        return $this->options['state'];
    }
    
    public function getZipCode(){
        return $this->options['zipcode'];
    }
    
    public function getPhone(){
        $telefono = '';
        if(trim($this->options['phone'])!=''){$telefono .= 'Telefono. '.$this->options['phone'];}    
       
        return $telefono;
    }
    
    public function getEmail(){
        $email = '';
        if(trim($this->options['email'])!=''){$email .= 'E-MAIL. '.$this->options['email'];}    
       
        return $email;
    }
    
    public function getWebPage(){
        $paginaWeb = '';
        if(trim($this->options['webpage'])!=''){$paginaWeb .= $this->options['webpage'];}    
       
        return $paginaWeb;
    }
    
   public function pagination($pag){
      $paginacion = new Paginacion($pag);
      $paginacion->setTables('company');
      $paginacion->setLayout(new Tradicional(2));

      return $paginacion;   
    }
}