<?php
class CobroRepository extends EntityRepository {
    
    private $table = 'cobros';
    private $repoVenta = null;
    private $lastInsertMultiple = null;
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    
    private function getRepoVenta(){
        if(!$this->repoVenta instanceof VentaRepository){
            $this->repoVenta = new VentaRepository();
        }
        return $this->repoVenta;
    }
    
    public function updateVentaStatus($idVenta){
        $repository = $this->getRepoVenta();
        if(!$repository->hasSaldoPendiente($idVenta)){
            return parent::update($idVenta, array('status'=>'2',),'ventas'); // 2 = Pagada
        }else{
            return parent::update($idVenta, array('status'=>'1'),'ventas'); // 1 = pendiente
        }        
        return true;
    }

    public function save(array $data, $table = null) {   
        $data['status'] = '1';
        
        $this->startTransaction();
        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToDB($data['fecha']);        
        
        if(parent::save($data, $this->table)){
            if($this->updateVentaStatus($data['idVenta'])){
                $this->commit();
                return true;
            }else{
                $this->rollback();
                $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                return null;
            }
        }
        $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
        return null;
    }

    public function update($id, $data, $table = null) {
        unset($data['status']);
        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToDB($data['fecha']);        
        
        $this->startTransaction();
        if(parent::update($id, $data, $this->table)){
            if($this->updateVentaStatus($data['idVenta'])){
                $this->commit();
                return true;
            }else{
                $this->rollback();
                $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                return null;
            }
        }
        $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
        return null;
    }
    
    public function delete($id, $table = null) {
        $data = $this->getById($id);
        $this->query("START TRANSACTION");
        if(parent::update($id, array('status'=>'2'), $this->table)){
            if($this->updateVentaStatus($data['idVenta'])){
                $this->query("COMMIT");
                return true;
            }else{
                $this->query("ROLLBACK");
                return null;
            }
        }
        return null;
    }
    
    public function deleteMultiple($id){
        $query = "SELECT id FROM cobros WHERE multiple = '$id'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $cobros = $this->resultToArray($result);
            $delete = true;            
            $this->startTransaction();
            foreach($cobros as $key => $cobro){
                $delete = $this->delete($cobro['id']);
                if($delete===null){
                    $this->rollback();
                    return null;
                }
            }
            $this->commit();
            return true;
        }
        return null;
    }   
    
    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere= null) {
        return parent::isUsedInRecord($id, array('pfa'=>'shipFrom'),"AND tipo = 'Inbound'");   
    }
    
    public function getCobrosByIdVenta($idVenta,$status = 1){
        if($status==1){
            $status = " AND c.status = $status ";
        }
        $query = "SELECT c.*,cl.nombre,
                    DATE_FORMAT(c.fecha,'%b-%d-%Y') as fecha,
                    fxGetFormaPagoName(c.formaPago)as formaPago,
                    fxGetCuentaBancariaName(c.cuentaBancaria)as cuentaBancaria,
                    fxGetStatusName(c.status,'status','cobro')as statusName
                    FROM cobros c,ventas v,clientes cl
                    WHERE v.id = '$idVenta'
                    AND c.idVenta = v.id
                    AND v.cliente = cl.id
                    $status
                    ORDER BY c.fecha DESC";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getNextCobroByFecha($idVenta){
        $query = "SELECT id FROM cobros "
                . "WHERE idVenta = '$idVenta' "
                . "AND status = 1"
                . "ORDER BY fecha ASC LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->fetch_object();
            return $result->id;
        }else{
            return null;
        }
    }
    
    public function getLastInsertMultiple(){
        return $this->lastInsertMultiple;
    }
    
    public function saveMultiple($data){
      $login = new Login();
      $facturas = $data['cobro'];
      $formasPago = $data['formaPago'];
      $numCheque = $data['numCheque'];
      
      $this->startTransaction();
      $numCobroMultiple = $this->getNextNumCobroMultiple();
      foreach ($facturas as $idVenta => $monto){
           $idVenta = explode("-",$idVenta);
           $idVenta = $idVenta[0]; // para asegurarnos que no traiga el formato 123-587 que se utiliza para actualiza en updateMulitples
          if($monto > 0 && trim($monto!= '') && $monto !== null){
                $result = $this->save(array(
                    'fecha'=>$data['fecha'],
                    'idVenta'=>$idVenta,
                    'monto'=>$monto,
                    'formaPago'=>$formasPago[$idVenta],
                    'numCheque'=>$numCheque[$idVenta],
                    'cuentaBancaria'=>$data['cuentaBancaria'],
                    'notas'=>$this->_getTranslation('Registrado desde Cobros Multiples.'),
                    'multiple'=>$numCobroMultiple,
                    'ultimaModificacion'=>date('Y-m-d'),
                    'usuario'=>$login->getId()
                ));

                if($result === null){
                    $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                    $this->rollback();
                    return null;
                }
          }
      }
      $this->commit();
      $this->lastInsertMultiple = $numCobroMultiple;
      return true;
  }
  
  public function updateMultiple($data){
      $login = new Login();
      $facturas = $data['cobro'];
      $formasPago = $data['formaPago'];
      $numCheque = $data['numCheque'];

      $this->startTransaction();      
      $arrayIdsCobros = array();
      foreach ($facturas as $idVenta => $monto){
          $idVentaOrigin = $idVenta;
          $idVenta = explode("-",$idVenta);
          if($monto > 0 && trim($monto!= '') && $monto !== null){
              $array = array(
                    'fecha'=>$data['fecha'],
                    'idVenta'=>$idVenta[0],
                    'monto'=>$monto,
                    'formaPago'=>$formasPago[$idVentaOrigin],
                    'numCheque'=>$numCheque[$idVentaOrigin],
                    'cuentaBancaria'=>$data['cuentaBancaria'],
                    'multiple'=>$data['id'],
                    'notas'=>$this->_getTranslation('Actualizado desde Cobros Multiples.'),
                    'ultimaModificacion'=>date('Y-m-d'),
                    'usuario'=>$login->getId()
                );
              
                //$idCompra[1] contiene el id de Pago
                //Si existe $idCompra[1], significa que ya existe un pago con ese id y solo debe actualizarse
                //Sino existe, debe agregarse.
                if(isset($idVenta[1]) && $idVenta[1] != ''){
                    $result = $this->update($idVenta[1], $array);
                    $arrayIdsCobros[] = $idVenta[1]; 
                }else{ 
                    $result = $this->save($array);
                }             

                if($result === null){
                    $this->flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                    $this->rollback();
                    return null;
                }
          }
      }
      
      foreach($_SESSION['cobrosOriginales'] as $cobro){
          if(!in_array($cobro['id'], $arrayIdsCobros)){
              $this->query("UPDATE cobros SET status = 2 WHERE id = '{$cobro['id']}'");
              $this->updateVentaStatus($cobro['VentaId']);
          }
      }
      #echo "bien";exit;
      $this->commit();
      return true;
  }
  
  public function getNextNumCobroMultiple(){
      $query = "SELECT MAX(multiple)as numMultipleCobro FROM cobros LIMIT 1";
      $result = $this->query($query);
      
      if($result->num_rows > 0){
          $result = $result->fetch_object();
          return $result->numMultipleCobro + 1;
      }
      return 1;
  }
    
    public function createFilterFecha($options,$campoFecha = null ){
        $fechaInicio = $options['fechaInicio'];
        $fechaFin = $options['fechaFin'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
}