$(document).ajaxStart($.blockUI).ajaxStop($.unblockUI);
$(document).ready(function() { 
    $(".modal-dialog").draggable({
        handle: ".modal-header,.modal-body,.modal-footer"
    });
    
    $(".modal").on("hidden.bs.modal", function(){
        $(".modal-dialog").css({top: 0,left: 0});
    });
});
$(function(){$('._tooltip').tooltip();});

function fadeOutAlert(){
  window.setTimeout(function() {
    $('.alert').slideUp('slow', function(){
        $(this).remove();
    });
  }, 5000);
}

function number_format(number,decimals,dec_point,thousands_sep) {
    number  = number*1;//makes sure `number` is numeric value
    var str = number.toFixed(decimals?decimals:0).toString().split('.');
    var parts = [];
    for ( var i=str[0].length; i>0; i-=3 ) {
        parts.unshift(str[0].substring(Math.max(0,i-3),i));
    }
    str[0] = parts.join(thousands_sep?thousands_sep:',');
    return str.join(dec_point?dec_point:'.');
}

function addMsgFlashmessenger(tipo,msg,messengerId){
    $('#msg').remove();
    
    var icon = "";
    if(tipo==='danger'){icon = "<i class='fa fa-times-circle'></i> ";}
    else if(tipo==='info'){icon = "<i class='fa fa-info-circle'></i> ";}
    else if(tipo==='success'){icon = "<i class='fa fa-check-circle'></i> ";}
    
    $('#'+messengerId).append("<div id='msg' class='alert alert-"+tipo+"'></div>");
    var btnClose = "<button type='button' class='close' data-dismiss='alert'>&times;</button>";
    
    $('#msg').html(btnClose+icon+msg);
}

function submit(formName){
    $('form[name='+formName+']').submit();
}

function clearForm(formName){
    $('form[name='+formName+']')[0].reset();
}

function _getTranslation(msj,callback){
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getTranslation',
        msj:msj
            }, function(data) {
                callback(msj);
            }, 'json');
}

function destroyDataTable(table_id){
    if ($.fn.dataTable.isDataTable( '#'+table_id )) {
        var table = $('#'+table_id).DataTable();
        table.destroy();
    } 
}

function setDataTable(tableId){
    $('#'+tableId).DataTable({paginate:false,filter:true,aaSorting:[]});
    $('#'+tableId)
            .removeClass( 'display' )
            .addClass('table table-striped table-bordered');
        
    $('#'+tableId+' tfoot th.filter').each( function () {
        var input_name = $(this).data('filtername');
        $(this).html( '<input type="text" name="filter_'+input_name+'" class="column_filter" placeholder="Buscar" style="width:100%" />' );
    } );  
 
    var table = $('#'+tableId).DataTable();
    // Apply the search
    table.columns().every( function () {
        var that = this; 
        $( 'input', this.footer() ).on( 'keyup change', function () {
            if ( that.search() !== this.value ) {
                that
                    .search (this.value.replace("/;/g", "|"), true, false)
                    .draw();
            }
        } );
    } );
}

function setVentaPos(byCode){    
   //$('#descuento_item_valor').val(30);
   var options = $("form[name=venta]").serializeArray();
   var idProducto = $('#idProducto').val();
   var idDetailTemp = $("#idDetalleTemp").val();

    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'setVentaDetalles',
        options: options,
        byCode: byCode
    }, function(data) {
        if (data.response){
            $("#venta-table").find('tbody').empty().append(data.ventaDetalles);
            $("#subtotal").val(number_format(data.subtotal,2,'.',''));  
            $("#total_venta").val(number_format(data.montoTotal,2,'.','')); 

            $("#totalPagar").html(number_format(data.montoTotal,2,'.',','));
            $("#quickBtnTotalPagar").html(number_format(data.montoTotal,2,'.',','));
            $('#quickBtnTotalPagar').data('value',number_format(data.montoTotal,2,'.',''));   
            
            if(data.descuentoOrden !== 0){$("#descuentoOrden").html(number_format(data.descuentoOrden,2,'.',','));}            
            $("#descuentoItems").html(number_format(data.descuentoItems,2,'.',','));            
            $("#divSubtotal").html(number_format(data.subtotal,2,'.',','));  
            if(data.descuentoTotal !== 0){$('#tr_regular_price').removeClass('hidden');$("#regular_price").html(number_format(data.regularPrice,2,'.',','));}            
            $("#impuestosTotal").html(number_format(data.impuestosTotal,2,'.',','));  
            
            $("#itemsTotal").html(data.itemsTotal);
            $("#montoTotal").html(number_format(data.montoTotal,2,'.',','));
            
            $("#idDetalleTemp").val('');
            $("#cantidadOrigen").val('');
            $("#producto").val('');
            $("#idProducto").val('');
            $('#cantidad').val('1');
            $('#precio').val('');
            $("#impuestos").val('');
            $("#descuento_item_valor").val('');
            
            if(data.showModal && idDetailTemp == ''){ /*Cuando el producto es pan por libra*/   
                $("td[data-idproduct='"+data.lastInsertId+"']:first").trigger('click');                
            }else{
                $('#modalEditarProducto').modal('hide');
            }
                
        }else{
            $('#flashmessenger').html(data.message);
            $("#idDetalleTemp").val('');
            $("#producto").val('');
            fadeOutAlert();
        }        

        $('#producto').focus();
    }, 'json');
}

function onEnterPos(ev,element){
    if(ev === 13){
        switch(element.name){
            case 'producto':
                $('#producto').autocomplete('close');
                var idProduct = $("#producto").val();
                $("#idProducto").val(idProduct);
                setVentaPos(true);
                break;
                
            case 'idVentaDevolucion':
                setVentaDetallesDevolucion();
                break;
        }
    }
}

function setVentaPosFromQuickBtn(idProduct){
    $('#idProducto').val(idProduct);
    setVentaPos();
}


function setProductToEdit(element){
   var idProduct = $(element).data('idproduct');
   
   $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'setProductToEdit',
        idProduct: idProduct
    }, function(data) {
        if (data.response){  
            for (var name in data.data) {
                $('form[name=venta] #'+name).val(data.data[name]);
            }                 
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }        
    }, 'json');
}

function deleteDetallesVenta(id){ 
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar producto',
            content: 'Desea eliminar el producto ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                       $('#producto').focus();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        var descuento_orden_tipo = parseFloat($('#descuento_orden_tipo').val());
                        var descuento_orden_valor = parseFloat($('#descuento_orden_valor').val());
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'deleteDetalles',
                            id: id,
                            descuento_orden_tipo:descuento_orden_tipo,
                            descuento_orden_valor:descuento_orden_valor
                        }, function(data) {
                            if (data.response){
                                $("#venta-table").find('tbody').empty().append(data.ventaDetalles);
                                $("#subtotal").val(number_format(data.subtotal,2,'.',''));
                                $("#total_venta").val(number_format(data.montoTotal,2,'.','')); 
                                $("#montoTotal").html(number_format(data.montoTotal,2,'.',','));
                                $("#itemsTotal").html(number_format(data.itemsTotal,2,'.',','));

                                $("#totalPagar").html(number_format(data.montoTotal,2,'.',','));
                                $("#quickBtnTotalPagar").html(number_format(data.montoTotal,2,'.',','));
                                $('#quickBtnTotalPagar').data('value',number_format(data.montoTotal,2,'.',''));
                                $("#descuentoOrden").html(number_format(data.descuentoOrden,2,'.',','));
                                if(descuento_orden_valor === ''){ $("#descuentoOrden").html("<i class='fa fa-plus-circle'></i>");}
                                $("#descuentoItems").html(number_format(data.descuentoItems,2,'.',','));                                    

                                $("#divSubtotal").html(number_format(data.subtotal,2,'.',','));
                                $("#regular_price").html(data.regularPrice);
                                if(data.descuentoTotal !== 0){
                                    $('#tr_regular_price').removeClass('hidden');
                                }else{
                                    $('#tr_regular_price').addClass('hidden');
                                }            
                                $("#impuestosTotal").html(number_format(data.impuestosTotal,2,'.',','));

                                var totalPagar = $('#totalPagar').html();
                                var totalPagado = $('#totalPagado').html();

                                totalPagar = totalPagar.replace(',','');
                                totalPagado = totalPagado.replace(',','');   

                                if(!$.isNumeric(totalPagar.replace(',',''))){totalPagar = 0;}
                                if(!$.isNumeric(totalPagado.replace(',',''))){totalPagado = 0;}

                                var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);

                                $("#totalBalance").html(number_format(totalBalance,2,'.',','));
                                $("#idDetalleTemp").val('');
                                $("#cantidadOrigen").val('');
                                $("#idProducto").val('');
                                $('#cantidad').val('1');
                                $('#precio').val('');
                                $("#impuestos").val('');
                                $("#descuento_item_valor").val('');

                            }else{
                                $('#flashmessenger').html(data.message);
                                fadeOutAlert();
                            }        
                            
                            $('#producto').focus();
                            
                        }, 'json');
                    }
                }
            }
        });
}

function deleteVentaPosActual(){
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar venta actual',
            content: 'Desea eliminar venta actual ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                       $('#producto').focus();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                    $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'deleteVentaPosActual'
                        }, function(data) {
                            if (data.response){
                                $("#venta-table").find('tbody').empty().append('');
                                $("#subtotal").val('0');
                                $("#total_venta").val('0'); 
                                $("#id_special_requisition").val('0');
                                $('#descuento_orden_valor').val('');
                                $('#cliente').val('1');
                                $("#montoTotal").html('0.00');
                                $("#itemsTotal").html('');

                                $("#totalPagar").html('0.00');
                                $("#totalPagado").html('0.00');
                                $("#totalBalance").html('0.00');
                                $("#quickBtnTotalPagar").html(''); 
                                $('#quickBtnTotalPagar').data('value','');

                                $("#descuentoItems").html('0.00');
                                $("#descuentoOrden").html("<i class='fa fa-plus-circle'></i>");
                                $("#divSubtotal").html('0.00');
                                $("#regular_price").html('');
                                $('#tr_regular_price').addClass('hidden');          
                                $("#impuestosTotal").html('0.00');           

                                $("#idDetalleTemp").val('');
                                $("#cantidadOrigen").val('');
                                $("#producto").val('');
                                $("#idProducto").val('');
                                $('#cantidad').val('1');
                                $('#precio').val('');
                                $("#impuestos").val('');
                                $("#descuento_item_valor").val('');

                            }else{
                                $('#flashmessenger').html(data.message);
                                fadeOutAlert();
                            }       
                            
                            $('#producto').focus();
                             
                        }, 'json');
                    }
                }
            }
        });
    
}


/* POS PAYMENTS*/
function disabledAddPayment(){
    $("form[name=cobro] input").prop("disabled", true);    
    $('table.sparko_numPad tr').css({'pointer-events':'none','background-color':'#eee'});
    
    _getTranslation('Forma de pago',function(msj){$('#paymentMethodName').html(msj);});
}

function enabledAddPayment(){
    $("form[name=cobro] input").prop("disabled", false);    
    $('table.sparko_numPad tr').css({'pointer-events':'','background-color':''});
}

function clearPaymentForm(){
    $("form[name=cobro]").data('bootstrapValidator').resetForm();
    $("form[name=cobro]")[0].reset();
    $("form[name=cobro] #id").val('');
    $('#cardDetails').hide();
}

function setPaymentAmount(btn){
    var value = $(btn).data('value');
    if(value === 'clear'){
        $('#monto').val('');
        return true;
    }else if(value === 'backspace'){
        var amount = $('#monto').val();
        amount = amount.slice(0,-1);
        $('#monto').val(amount);
        return true;
    }else if(value==='cancel'){
        clearPaymentForm();           
        disabledAddPayment();
        
        return true;        
    }else if(value === 'done'){
        return setCobroTemp();
    }else if(btn.classList.contains('quickPaymentBtn')){
        $('#monto').val();
        $('#monto').val(value);
        return true;
    }
    
    var amount = $('#monto').val();
    amount = amount.toString()+value;
    
    var preg = /^([0-9]+\.?[0-9]{0,2})$/; 
    if(preg.test(amount) === true){
        $('#monto').val(amount);
    }else{
       return false;
    }   
}

function setFormaPago(formaPago,e){
    clearPaymentForm();
    enabledAddPayment();
    configShowPaymentForm(formaPago,e);
}

function createStripeTokenBySwiped(swiped,callback){   
    // Visa issuer number begins with 4 and may vary from 13 to 19 total digits. 16 digits is most common.
    //var visa = new RegExp("^%B(4[0-9]{12,18})\\^([A-Z\/ ]+)([A-Z ]+)(\\.[A-Z ]+)?\\^([0-9]{2})([0-9]{2})");
    var visa = new RegExp("^%[B-b](4[0-9]{12,18})\\^([A-z\/ \\.]+)([A-z ]+)(\\.[A-z ]+)?\\^([0-9]{2})([0-9]{2})");
    var match = visa.exec(swiped);
    if (!match){
        // MasterCard starts with 51-55, and is 16 digits long.
        //var mastercard = new RegExp("^%B(5[1-5][0-9]{14})\\^([A-Z\/ ]+)([A-Z ]+)(\\.[A-Z ]+)?\\^([0-9]{2})([0-9]{2})");
        var mastercard = new RegExp("^%[B-b](5[1-5][0-9]{14})\\^([A-z\/ \\.]+)([A-z ]+)(\\.[A-z ]+)?\\^([0-9]{2})([0-9]{2})");
        
        var match = mastercard.exec(swiped);
        if(!match){
            // discover starts with 6, and is 16 digits long.
            var discover = new RegExp("^%[B-b](6[0-9]{15})\\^([A-z\/ \\.]+)([A-z ]+)(\\.[A-z ]+)?\\^([0-9]{2})([0-9]{2})");
            var match = discover.exec(swiped);
            if(!match){
                // American Express starts with 34 or 37, and is 15 digits long.
                var amex = new RegExp("^%[B-b](3[4|7][0-9]{13})\\^([A-z ]+)/([A-z ]+)(\\.[A-z ]+)?\\^([0-9]{2})([0-9]{2})");
                var match = amex.exec(swiped);
                if(!match){
                    $('#swiped').val('');
                    //alert(swiped+'Error al leer la tarjeta');   
                    //cambiopcg
                     _getTranslation('Error al tratar de leer la tarjeta.<br/>Intenta ingresando datos de tarjeta manualmente.',function(msj){$.alert({content:msj,title:"<i class='fa fa-info-circle'></i> Mensaje", columnClass: 'col-md-6 col-md-offset-3'});}); 
                    errorLogCardReader(swiped);
                    return null;
                }
            }
        }
    }  
    
    $('.card-number').val(match[1]);
    $('.card-expiry-month').val(match[6]);    
    $('.card-expiry-year').val(parseInt(match[5])+2000);   
     
     var options = $("form[name=cobro] input,form[name=cobro] hidden,form[name=cobro] select").serializeArray();
    
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'setCobroTemp',
            options: options 
        }, function(data) {
            if (data.response){
                $("#cobros-table").find('tbody').empty().append(data.listCobros);
                $("#totalPagado").html(number_format(data.totalPagado,2,'.',','));

                var totalPagar = $('#totalPagar').html();
                var totalPagado = $('#totalPagado').html();

                totalPagar = totalPagar.replace(',','');
                totalPagado = totalPagado.replace(',','');   

                if(!$.isNumeric(totalPagar)){totalPagar = 0;}
                if(!$.isNumeric(totalPagado)){totalPagado = 0;}

                var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);
                $("#totalBalance").html(number_format(totalBalance,2,'.',','));
                if(totalBalance >= 0){
                    $('#quickBtnTotalPagar').html(number_format(totalBalance,2,'.',','));
                    $('#quickBtnTotalPagar').data('value',number_format(totalBalance,2,'.',''));
                }else{
                    $('#quickBtnTotalPagar').html(number_format(0,2,'.',','));
                    $('#quickBtnTotalPagar').data('value',number_format(0,2,'.',''));
                }   
                
                $('#flashmessenger-pago').html(data.msg);
                clearPaymentForm();            
                disabledAddPayment();

            }else{
                $('#flashmessenger-pago').html(data.msg);
            }                    
        }, 'json'); 
        
        callback();
        
}

function errorLogCardReader(swiped){
            $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'errorLogCardReader',
            swiped: swiped 
        }, function(data) {
            if (data.response){
                return true;
            }        
        }, 'json');
}



function configShowPaymentForm(formaPago,e){
    $('#paymentMethodName').html($(e).data('paymentmethod'));
    $('#formaPago').val(formaPago); 
    
    if(formaPago === 5 || formaPago === 6){
        //$('#cardDetails').show();
        //$('#cardnumber').fodus();
        $('#card_payment_type').val('swiped');
        $('#monto').val(number_format($('#quickBtnTotalPagar').data('value'),'2','.'));
    }else{
        $('#cardDetails').hide();
    }
    
    if(formaPago === 4 || formaPago === 7 || formaPago === 5 || formaPago === 6){
        $('#divNumDocumento').show();
    }else{
        $('#divNumDocumento').hide();
    } 
}

function stripeResponseHandler(status, response) {
    if (response.error) {
        // re-enable the submit button
        //$('.submit-button').removeAttr("disabled");
        // show hidden div
        //document.getElementById('a_x200').style.display = 'block';
        // show the errors on the form
        addMsgFlashmessenger('danger',response.error.message,'flashmessenger-pago');
    } else {
        var form = $("form[name=cobro]");
        // token contains id, last4, and card type
        var token = response['id'];
        // insert the token into the form so it gets submitted to the server
        form.append("<input type='hidden' name='stripeToken' value='" + token + "' />");
        var options = $("form[name=cobro] input,form[name=cobro] hidden,form[name=cobro] select").serializeArray();
    
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'setCobroTemp',
            options: options 
        }, function(data) {
            if (data.response){
                $("#cobros-table").find('tbody').empty().append(data.listCobros);
                $("#totalPagado").html(number_format(data.totalPagado,2,'.',','));

                var totalPagar = $('#totalPagar').html();
                var totalPagado = $('#totalPagado').html();

                totalPagar = totalPagar.replace(',','');
                totalPagado = totalPagado.replace(',','');   

                if(!$.isNumeric(totalPagar)){totalPagar = 0;}
                if(!$.isNumeric(totalPagado)){totalPagado = 0;}

                var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);
                $("#totalBalance").html(number_format(totalBalance,2,'.',','));
                if(totalBalance >= 0){
                    $('#quickBtnTotalPagar').html(number_format(totalBalance,2,'.',','));
                    $('#quickBtnTotalPagar').data('value',number_format(totalBalance,2,'.',''));
                }else{
                    $('#quickBtnTotalPagar').html(number_format(0,2,'.',','));
                    $('#quickBtnTotalPagar').data('value',number_format(0,2,'.',''));
                }   
                
                $('#flashmessenger-pago').html(data.msg);
                clearPaymentForm();            
                disabledAddPayment();

            }else{
                $('#flashmessenger-pago').html(data.msg);
            }        
        }, 'json'); 
    }
}

function swipeCard(){
    var s = $.confirm({
            lazyOpen: true,
            title: '',
            icon: '',
            theme: 'supervan',
            content: '<input id="swiped" type="text" class="name form-control" style="opacity:0;width:0px" />'+
                     '<p class="swiped_msg" style="font-size:32px"><i class="fa fa-credit-card"></i> Deslizar tarjeta.</p>'+
                     '<p class="activeSwipe" style="padding-bottom:25px;cursor:pointer;display:none">Haz click aqui y despues desliza tarjeta en lector.</p>',
            onContentReady: function(){                
                $('#swiped').focus();
                $('#swiped').blur(function(){
                    $('.swiped_msg').hide();
                    $('.activeSwipe').show();
                });
                $("#swiped").keypress(function(e) {
                    var code = (e.keyCode ? e.keyCode : e.which);
                    if(code === 13){
                        createStripeTokenBySwiped($('#swiped').val(),function(){s.close();});                        
                    }
                });
                
                $('.activeSwipe').on('click',function(){                    
                    $(this).hide();
                    $('.swiped_msg').show();
                    $('#swiped').focus();
                });
            },
            buttons:{
                ok:{
                    btnClass:'hide ok'
                },
                Cancel:{
                    text: 'Cancelar',
                    action: function(){
                        clearPaymentForm();
                        disabledAddPayment();
                    }                    
                },
                Manualy:{
                    text: 'Ingresar datos de tarjeta manual',
                    action: function(){
                        $('#card_payment_type').val('manually');
                        $('#cardDetails').show();
                        $('#cardnumber').focus();
                    }
                }                        
            }                       
        });   
}

function setCobroTemp(){
    var form = $("form[name=cobro]");
    var hasError = form.bootstrapValidator('validate').has('.has-error:visible').length;;
    if(hasError){
        return null;
    }
    
    var amount = $('#monto').val();
    if(!$.isNumeric(amount) || amount <= 0){return null;}
    
    /*
    if($('#formaPago').val() === '5' || $('#formaPago').val() === '6'){
        if($('#card_payment_type').val() === 'swiped'){
             return swipeCard();
        }  
    }*/
    
    var options = $("form[name=cobro] input,form[name=cobro] hidden,form[name=cobro] select").serializeArray();
    
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'setCobroTemp',
        options: options 
    }, function(data) {
        if (data.response){
            $("#cobros-table").find('tbody').empty().append(data.listCobros);
            $("#totalPagado").html(number_format(data.totalPagado,2,'.',','));
            
            var totalPagar = $('#totalPagar').html();
            var totalPagado = $('#totalPagado').html();
            
            totalPagar = totalPagar.replace(',','');
            totalPagado = totalPagado.replace(',','');   
            
            if(!$.isNumeric(totalPagar)){totalPagar = 0;}
            if(!$.isNumeric(totalPagado)){totalPagado = 0;}
            
            var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);
            $("#totalBalance").html(number_format(totalBalance,2,'.',','));
            if(totalBalance >= 0){
                $('#quickBtnTotalPagar').html(number_format(totalBalance,2,'.',','));
                $('#quickBtnTotalPagar').data('value',number_format(totalBalance,2,'.',''));
            }else{
                $('#quickBtnTotalPagar').html(number_format(0,2,'.',','));
                $('#quickBtnTotalPagar').data('value',number_format(0,2,'.',''));
            }            

            clearPaymentForm();            
            disabledAddPayment();
            $('#flashmessenger-pago').html(data.msg);
                
        }else{
            $('#flashmessenger-pago').html(data.msg);
        }        
    }, 'json'); 
}

function clearModalCobros(){    
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar pagos',
            content: 'Si cancela esta ventana, los pagos con tarjeta registrados para esta venta seran reembolsados. Desea continuar ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'clearListCobros'
                        }, function(data) {
                            if (data.response){
                                $("#cobros-table").find('tbody').empty();

                                $("#totalPagar").html(number_format($('#total_venta').val(),2,'.',','));
                                $("#totalPagado").html(number_format(0,2,'.',','));                   
                                $("#totalBalance").html(number_format($('#total_venta').val(),2,'.',','));
                                $('#quickBtnTotalPagar').html($('#total_venta').val());
                                $('#quickBtnTotalPagar').data('value',$('#total_venta').val());

                                disabledAddPayment();
                                clearPaymentForm();
                                $('#flashmessenger').html(data.msg);
                                $('#flashmessenger-pago').html('');
                                $('#modalPago').modal('hide');
                            }else{
                                $("#cobros-table").find('tbody').empty().append(data.listCobros);
                                $('#flashmessenger-pago').html(data.msg);
                            }    
                        }, 'json');                       
                    }
                }
            }
        });
}

function setCobroToEdit(data,e){
    for (var name in data) {
        $('form[name=cobro] #'+name).val(data[name]);
    } 
    
    enabledAddPayment();
    var buttonPaymentMethod = $("span[data-paymentmethod='"+data['formaPagoName']+"']");
    configShowPaymentForm(parseInt(data['formaPago']),buttonPaymentMethod);
    
}

function deleteCobro(id){
    clearPaymentForm();
    disabledAddPayment();
    
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar pago',
            content: 'Desea eliminar el pago ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'deleteCobro',
                            id: id
                        }, function(data) {
                            if (data.response){
                                $("#cobros-table").find('tbody').empty().append(data.listCobros);
                                $("#totalPagado").html(number_format(data.totalPagado,2,'.',','));

                                var totalPagar = $('#totalPagar').html();
                                var totalPagado = $('#totalPagado').html();

                                totalPagar = totalPagar.replace(',','');
                                totalPagado = totalPagado.replace(',','');                                    

                                if(!$.isNumeric(totalPagar)){totalPagar = 0;}
                                if(!$.isNumeric(totalPagado)){totalPagado = 0;}

                                var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);
                                $("#totalBalance").html(number_format(totalBalance,2,'.',','));

                                if(totalBalance >= 0){ 
                                    $('#quickBtnTotalPagar').html(number_format(totalBalance,2,'.',','));
                                    $('#quickBtnTotalPagar').data('value',number_format(totalBalance,2,'.',''));                                     
                                }else{
                                    $('#quickBtnTotalPagar').html(number_format(0,2,'.',','));
                                    $('#quickBtnTotalPagar').data('value',number_format(0,2,'.',''));
                                }                             
                            }                            
                            $('#flashmessenger-pago').html(data.msg);
                        }, 'json');
                    }
                }
            }
        });
}

function addMonto(monto){
    var monto = monto;
    monto = monto.replace(',',''); 
    
    var montoActual = $('#monto').val();
    if(montoActual === ''){
        montoActual = 0;
    }
    
    montoActual = parseFloat(montoActual) + parseFloat(monto);
    $('#monto').val(montoActual);
}

function clearMonto(){
    $('#monto').val('');
}

function openModalAddDiscount(){
    var descuentoOrden = parseFloat($('#descuento_orden_valor').val());
    if(!$.isNumeric(descuentoOrden)){
        $('#cerrarDescuento').show();
        $('#cancelarDescuento').hide();
    }else{
        $('#cerrarDescuento').hide();
        $('#cancelarDescuento').show();
    }
    
    $('#modalAgregarDescuento').modal('show');
}

function setDescuento(){
    var descuentoTipo = $('#descuento_orden_tipo').val();
    var descuentoOrden = parseFloat($('#descuento_orden_valor').val());
    if(!$.isNumeric(descuentoOrden)){descuentoOrden = 0;}
    
    if(descuentoOrden === 0){alert('Descuento debe ser mayor a cero'); return null;}
    
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'setDescuentoOrden',
        descuento_orden_tipo: descuentoTipo,
        descuento_orden_valor: descuentoOrden
    }, function(data) {
        if (data.response){
            $("#venta-table").find('tbody').empty().append(data.ventaDetalles);
            $("#subtotal").val(number_format(data.subtotal,2,'.',''));
            $("#total_venta").val(number_format(data.montoTotal,2,'.','')); 
            
            $("#montoTotal").html(number_format(data.montoTotal,2,'.',','));
            $("#totalPagar").html(number_format(data.montoTotal,2,'.',','));
            
            $("#quickBtnTotalPagar").html(number_format(data.montoTotal,2,'.',','));
            $('#quickBtnTotalPagar').data('value',number_format(data.montoTotal,2,'.',''));    
            
            $("#descuentoOrden").html(number_format(data.descuentoOrden,2,'.',','));
            $("#divSubtotal").html(number_format(data.subtotal,2,'.',','));
            if(data.descuentoTotal !== 0){$('#tr_regular_price').removeClass('hidden');$("#regular_price").html(data.regularPrice);}            
            $("#impuestosTotal").html(data.impuestosTotal);
            
            $('#modalAgregarDescuento').modal('hide');
        }
    },'json');
}

function cancelDescuento(){    
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'cancelDescuentoOrden'
    }, function(data) {
        if (data.response){
            $("#venta-table").find('tbody').empty().append(data.ventaDetalles);
            $("#subtotal").val(number_format(data.subtotal,2,'.',''));
            $("#total_venta").val(number_format(data.montoTotal,2,'.','')); 
            
            $("#totalPagar").html(number_format(data.montoTotal,2,'.',','));            
            $("#quickBtnTotalPagar").html(number_format(data.montoTotal,2,'.',','));
            $('#quickBtnTotalPagar').data('value',number_format(data.montoTotal,2,'.',''));   
            
            $('#descuento_orden_tipo').val('porcentaje');
            $('#descuento_orden_valor').val('');
            
            $("#descuentoOrden").html("<i class='fa fa-plus-circle'></i>");
            $("#divSubtotal").html(number_format(data.subtotal,2,'.',','));
            $("#regular_price").html('');
            $('#tr_regular_price').addClass('hidden');    
            $("#impuestosTotal").html(number_format(data.impuestosTotal,2,'.',','));
            
            $("#montoTotal").html(number_format(data.montoTotal,2,'.',','));           
            
            $('#modalAgregarDescuento').modal('hide');
        }
    },'json');
}

/* POS VENTA*/

function saveVentaPos(){
    var totalPagar = $('#total_venta').val();
    var total_recibido = $('#totalPagado').html();
    
    totalPagar = totalPagar.replace(',','');
    total_recibido = total_recibido.replace(',','');
    
    if(!$.isNumeric(totalPagar)){totalPagar = 0;}
    if(!$.isNumeric(total_recibido)){total_recibido = 0;}
    if(parseFloat(totalPagar) > parseFloat(total_recibido)){        
        
         _getTranslation('Debe pagar el monto total de la venta.',function(msj){addMsgFlashmessenger('info',msj,'flashmessenger-pago');});
        return null;    
    }
    
    var cambio = total_recibido - totalPagar;
    var options = $("form[name=venta]").serializeArray();
    options.push({name:'total_recibido',value:total_recibido});
    options.push({name:'cambio',value:cambio});
    
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'saveVentaPos',
        options: options
    }, function(data) {
        if (data.response){            
            $('#modalPago').modal('hide');
            //$("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicket.php?idVenta="+data.idVenta);  
            $("#last_sale_id").val(data.idVenta);                

            $('#flashmessenger-pos').html(data.message);
            $('#modalChooseReceiptOption').modal('show');   
            fadeOutAlert();
            
            $('.hideForSR').show();
            $("#venta-table").find('tbody').empty().append('');
            $("#cobros-table").find('tbody').empty().append('');
            $("#venta-pago").find('tbody').empty();
            $("#subtotal").val('0');
            $("#total_venta").val('0'); 
            $("#id_special_requisition").val('0');
            $('#descuento_orden_valor').val('');
            $('#cliente').val('1');
            $('form[name=venta] #telefono').val('');
            $("#montoTotal").html('0.00');
            $("#itemsTotal").html('');

            $("#totalPagar").html('0.00');
            $("#totalPagado").html('0.00');
            $("#totalBalance").html('0.00');
            $("#quickBtnTotalPagar").html('');    
            $('#quickBtnTotalPagar').data('value','');         

            $("#descuentoItems").html('0.00');
            $("#descuentoOrden").html("<i class='fa fa-plus-circle'></i>");
            $("#divSubtotal").html('0.00');
            $("#regular_price").html('');
            $('#tr_regular_price').addClass('hidden');          
            $("#impuestosTotal").html('0.00');           

            $("#idDetalleTemp").val('');
            $("#cantidadOrigen").val('');
            $("#producto").val('');
            $("#idProducto").val('');
            $('#cantidad').val('1');
            $('#precio').val('');
            $("#impuestos").val('');
            $("#descuento_item_valor").val('');
            
        }else{
            $('#flashmessenger-pago').html(data.message);
        }   
        
        $('#producto').focus();
        
    }, 'json');    
}

function reimprimirTicketVenta(){
    // confirmarAccion('reemprimir_ticket',function(){ 
        var idVenta = $('#idVentaReimprimir').val();       
        $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicket.php?numVenta="+idVenta);   
    //});  
    $('#producto').focus();
}

function mailingTicketVenta(idVenta){     
    $.confirm({
            title: '<i class="fa fa-envelope"></i> Send email receipt',
            content: '' +
            '<form action="" class="formName">' +
            '<div class="form-group">' +
            '<input type="text" placeholder="jhon.smith@email.com" class="email form-control" value="" required />' +
            '</div>' +
            '</form>',
            buttons: {
                formSubmit: {
                    text: 'Submit',
                    btnClass: 'btn-blue',
                    action: function () {
                        var emailRegex = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
                        var email = this.$content.find('.email').val();
                        if(!emailRegex.test(email)){
                            $.alert('Example: jhon.smith@email.com','<li class="fa fa-exclamation-circle"></li> Provide a valid email');
                            return false;
                        }
                        
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'mailingTicketVenta',
                            idVenta: idVenta,
                            email: email
                        }, function(data) {
                            if (data.response){
                                $('#flashmessenger-pos').append(data.message);
                                fadeOutAlert();
                            }
                        },'json');
                        
                    }
                },
                cancel: function () {
                    //document.location = 'Pos.php';
                }
            },
            onContentReady: function () {
                // bind to events
                var jc = this;
                this.$content.find('form').on('submit', function (e) {
                    // if the user submits the form by pressing enter in the field.
                    e.preventDefault();
                    jc.$$formSubmit.trigger('click'); // reference the button and click it
                });
            }
        });
}

function suspenderVenta(){
    var options = $("form[name=venta]").serializeArray();
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'suspenderVenta',
        options: options
    }, function(data) {
        if (data.response){
            $("#ventasSuspendidas-table").find('tbody').empty().append(data.ventasSuspendidas);
            $("#venta-table").find('tbody').empty().append('');
            $("#subtotal").val('0');
            $("#total_venta").val('0'); 
            $("#id_special_requisition").val('0');
            $('#descuento_orden_valor').val('');
            $('#cliente').val('1');
            $('form[name=venta] #telefono').val('');
            $("#montoTotal").html('0.00');
            $("#itemsTotal").html('');

            $("#totalPagar").html('0.00');
            $("#totalPagado").html('0.00');
            $("#totalBalance").html('0.00');
            $("#quickBtnTotalPagar").html('');            

            $("#descuentoItems").html('0.00');
            $("#descuentoOrden").html("<i class='fa fa-plus-circle'></i>");
            $("#divSubtotal").html('0.00');
            $("#regular_price").html('');
            $('#tr_regular_price').addClass('hidden');          
            $("#impuestosTotal").html('0.00');           

            $("#idDetalleTemp").val('');
            $("#cantidadOrigen").val('');
            $("#producto").val('');
            $("#idProducto").val('');
            $('#cantidad').val('1');
            $('#precio').val('');
            $("#impuestos").val('');
            $("#descuento_item_valor").val('');
        }
        
        $("#referencia_venta_suspendida").val('');
        $('#flashmessenger').html(data.message);
        fadeOutAlert();
        
        $('#producto').focus();
               
    }, 'json');
}

function activarVentaSuspendida(idVentaSuspendida){  
    $('#modalVentasSuspendidas').modal('hide');
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'getActivarVentaSuspendida',
        idVenta: idVentaSuspendida
    }, function(data) {
        if (data.response){
            $("#ventasSuspendidas-table").find('tbody').empty().append('');
            $("#ventasSuspendidas-table").find('tbody').empty().append(data.ventasSuspendidas);
            $("#venta-table").find('tbody').empty().append('');
            $("#venta-table").find('tbody').empty().append(data.ventaDetalles);
            
            $("#subtotal").val(data.subtotal);  
            $("#total_venta").val(number_format(data.montoTotal,2,'.','')); 
            $("#descuento_orden_valor").val(data.descuento_orden_valor); 

            $("#totalPagar").html(number_format(data.montoTotal,2,'.',','));
            $("#quickBtnTotalPagar").html(number_format(data.montoTotal,2,'.',','));
            $('#quickBtnTotalPagar').data('value',number_format(data.montoTotal,2,'.',''));   
            
            if(data.descuentoOrden !== 0){$("#descuentoOrden").html(number_format(data.descuentoOrden,2,'.',','));}            
            $("#descuentoItems").html(number_format(data.descuentoItems,2,'.',','));            
            $("#divSubtotal").html(number_format(data.subtotal,2,'.',','));  
            if(data.descuentoTotal !== 0){$('#tr_regular_price').removeClass('hidden');$("#regular_price").html(number_format(data.regularPrice,2,'.',','));}            
            $("#impuestosTotal").html(number_format(data.impuestosTotal,2,'.',','));  
            
            $("#itemsTotal").html(data.itemsTotal);
            $("#montoTotal").html(number_format(data.montoTotal,2,'.',','));
                     
            $("#idDetalleTemp").val('');
            $("#cantidadOrigen").val('');
            $("#producto").val('');
            $("#idProducto").val('');
            $('#cantidad').val('1');
            $('#precio').val('');
            $("#impuestos").val('');
            $("#descuento_item_valor").val('');
        }
        
        $('#flashmessenger').html(data.message);
        fadeOutAlert();
        
        $('#producto').focus();
               
    }, 'json');
}

function deleteVentaSuspendida(idVentaSuspendida){    
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar Venta suspendida',
            content: 'Desea eliminar el Venta suspendida ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Pos.php', {
                               action: 'ajax',
                               request: 'deleteVentaSuspendida',
                               idVentaSuspendida: idVentaSuspendida
                           }, function(data) {
                               if (data.response){
                                   $("#ventasSuspendidas-table").find('tbody').empty().append(data.ventasSuspendidas);
                                   $('#flashmessenger-ventasSuspendidas').html(data.message);
                                   fadeOutAlert();                
                               }       
                           }, 'json');
                    }
                }
            }
        });
}

/* POS DEVOLUCIONES*/

function setVentaDetallesDevolucion(){
    var idVentaDevolucion = $('#idVentaDevolucion').val();
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'getVentaDetallesDevolucion',
        idVentaDevolucion: idVentaDevolucion
    }, function(data) {
        if (data.response){
            $("#devolucion-table").find('tbody').empty().append(data.ventaDetalles);            
            $('#clienteOrigen').html(data.clienteName);
            $("#subtotalOrigen").html(number_format(data.subtotal,2,'.',','));
            $("#descuentoOrdenOrigen").html(number_format(data.descuentoOrden,2,'.',','));
            $("#montoTotalOrigen").html(number_format(data.montoTotal,2,'.',','));
            $("#impuestosTotalOrigen").html(number_format(data.impuestosTotal,2,'.',','));
        }
        
        $('#flashmessenger').html(data.message);
        fadeOutAlert();
               
    }, 'json');
}

function setSubtotalDevolucion(cantidadDisponible,devolucion,precio,item){
    if(devolucion.value.trim() === ''){return null;}
    if(devolucion.value > cantidadDisponible){
        addMsgFlashmessenger('info','No puede hacer una devolucion mayor a la cantidad vendida','flashmessenger-devolucion');      
        fadeOutAlert();
        $(devolucion).val('');
        return null;
    }
    $('#'+item+'-devolucion').html((devolucion.value*precio).toFixed(2));
    
    var total = 0;
    $('.subtotal-devolucion').each(function(){
        var subTotal = $(this).html();
        if(subTotal.trim() === ''){subTotal = 0;}
        total += parseFloat(subTotal);
    });
    
    $('.montoTotalDevolucion').html(total.toFixed(2));        
    $('#quickBtnTotalDevolucion').html(total.toFixed(2));
    
    if(total > 0){
        $('#agregarPagoDevolucion').prop('disabled',false);
    }else{ 
        $('#agregarPagoDevolucion').prop('disabled',true);
    }
}

function setFormaPagoDevolucion(formaPago){
    $('#formaPagoDevolucion').val(formaPago);
    $('#modalPagoDevolucion').on('shown.bs.modal', function () {
        $('#montoDevolucion').focus();
    });
}

 function addMontoDevolucion(monto){
    var montoActual = $('#montoDevolucion').val();
    if(montoActual === ''){
        montoActual = 0;
    }
    
    montoActual = parseFloat(montoActual) + parseFloat(monto);
    $('#montoDevolucion').val(montoActual.toFixed(2));  
}

function clearMontoDevolucion(){
    $('#montoDevolucion').val('');
}

function setPagoDevolucionTemp(){
    var options = $("#montoDevolucion,#formaPagoDevolucion,#numDocumentoDevolucion").serializeArray();
    options.push({name:'formaPagoNameDevolucion',value:$("#formaPagoDevolucion option:selected").html()});
    
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'setPagoDevolucionTemp',
        options: options 
    }, function(data) {
        if (data.response){
            $("#pagosDevolucion-table").find('tbody').empty().append(data.listPagos);
            $(".totalPagadoDevolucion").html(data.totalPagado);
            
            var totalPagar = $('#montoTotalDevolucion').html();
            var totalPagado = $('.totalPagadoDevolucion').html();
            
            totalPagar = totalPagar.replace(',','');
            totalPagado = totalPagado.replace(',','');   
            
            if(!$.isNumeric(totalPagar)){totalPagar = 0;}
            
            var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);
            $(".balanceDevolucion").html(totalBalance.toFixed(2));

            $("#montoDevolucion").val('');
            $("#formaPagoDevolucion").val('3');
            $("#numDocumentoDevolucion").val('');
            
            $('#modalPagoDevolucionDetalle').modal('hide');
                
        }else{
            $('#flashmessenger-devolucionPagoDetalles').html(data.message);
            fadeOutAlert();
        }        
    }, 'json'); 
}

function getListaPagosDevolucion(){
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'getListaCobros'
    }, function(data) {
        if (data.response){
            $("#cobros-table").find('tbody').empty().append(data.listCobros);
            $("#totalPagado").html(data.totalPagado);           
            
            var totalPagar = $('#totalPagar').html();
            var totalPagado = $('#totalPagado').html();
            
            totalPagar = totalPagar.replace(',','');
            totalPagado = totalPagado.replace(',','');
            
            if(!$.isNumeric(totalPagar)){totalPagar = 0;}
            if(!$.isNumeric(totalPagado)){totalPagado = 0;}
            
            var totalBalance = parseFloat(totalPagar) - parseFloat(totalPagado);            
             $("#totalBalance").html(number_format(totalBalance,2,'.',','));
        }    
    }, 'json'); 
}

function setPagoDevolucionToEdit(data){
     for (var name in data) {
        $('#'+name).val(data[name]);
    } 
}

function deletePagoDevolucion(id){
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar pago de devolucion',
            content: 'Desea eliminar el pago ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'deletePagoDevolucion',
                            id: id
                        }, function(data) {
                            if (data.response){
                                $("#pagosDevolucion-table").find('tbody').empty().append(data.listPagos);
                                $(".totalPagadoDevolucion").html(data.totalPagado);

                                var totalPagar = $('#montoTotalDevolucion').html();
                                totalPagar = totalPagar.replace(',','');

                                if(!$.isNumeric(totalPagar)){totalPagar = 0;}

                                var totalBalance = parseFloat(totalPagar) - parseFloat(data.totalPagado.replace(',',''));
                                $(".balanceDevolucion").html(totalBalance.toFixed(2));

                                $("#montoDevolucion").val('');
                                $("#formaPagoDevolucoin").val('');
                                $("#numDocumentoDevolucion").val('');
                            }else{
                                $('#flashmessenger').html(data.message);
                                fadeOutAlert();
                            }        
                        }, 'json');
                    }
                }
            }
        });
}

function saveDevolucion(){
    var totalDevolucion = $(".montoTotalDevolucion").html();
    var totalPagado = $(".totalPagadoDevolucion").html();
    
    if(!$.isNumeric(totalDevolucion)){totalDevolucion = 0;}
    if(!$.isNumeric(totalPagado)){totalPagado = 0;}
    
    if(parseFloat(totalDevolucion) > parseFloat(totalPagado)){        
         _getTranslation('Debe pagar el monto total de la devolucion.',function(msj){addMsgFlashmessenger('info',msj,'flashmessenger-devolucion');});
        return null;    
    }
    
    var devoluciones = $('.devolucionInput').serializeArray();
    var options = $('#idVentaDevolucion,#notasDevolucion').serializeArray();
    
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'saveDevolucion',
        devoluciones: devoluciones,
        options:options
    }, function(data) {
        if (data.response){
            clearModalDevolucion();
            printDevolucion(data.idDevolucion);
            $('#modalDevolucion').modal('hide');
            $('#flashmessenger-pos').html(data.message);
            fadeOutAlert();          
        }else{
            $('#flashmessenger-devolucion').html(data.message);
            fadeOutAlert();
        }   
    }, 'json'); 
}

function clearModalDevolucion(){
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'clearListPagosDevolucion'
    }, function(data) {
        if (data.response){
           $("#devolucion-table").find('tbody').empty();
           $("#pagosDevolucion-table").find('tbody').empty();
           $("#idVentaDevolucion").val('');
           $("#notasDevolucion").val('');
           
           $("#idVentaDevolucion").val('');
           $("#montoDevolucion").val('');
           $("#formaPagoDevolucion").val('');
           $("#numDocumentoDevolucion").val('');
           
           $(".infoOrigenVenta").html('');
           $(".montoTotalDevolucion").html('0.00');
           $(".totalPagadoDevolucion").html('0.00');
           $(".balanceDevolucion").html('0.00');
           $('#agregarPagoDevolucion').prop('disabled',true);

        }
        $('#producto').focus();
    }, 'json'); 
}

function enabledDisabledPeriodoCredito(value,formName){
    if(value === '2'){
        $('form[name='+formName+'] #diasCredito').prop('disabled',false);
    }else if(value === '1'){
        $('form[name='+formName+'] #diasCredito').prop('disabled',true);
    }
}

/* REPORTS */
function setFilterReport(report){
    var reportName = $(report).data('reportname');
    $('#reporte').val(reportName);
    $.post('/Controller/Reports.php',{
        action: 'ajax',
        request: 'getFiltersReport',
        report: reportName
    },function(data){
        if(data.response){
            $('#filtersArea').html(data.filters);
            $('select').select2();
            $('#fechaInicio,#fechaFin').datetimepicker({format: 'MM/DD/YYYY'});      
        }
    },'json');
}
/* END REPORTS*/

function sumDenominaciones(){
    var elementId = $('#elementId').val();
    var options = $("form[name='denominaciones']").serializeArray();
    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'sumDenominaciones',
        options:options
    }, function(data) {
        if (data.response){
            $("#"+elementId).val(data.sumMonto);
            $('#modalDenominaciones').modal('hide');
        }    
    }, 'json'); 
}

function clearDenominaciones(){
    clearForm('denominaciones');
    $('#elementId').val('');
}

function printTicketVenta(idVenta){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicket.php?idVenta="+idVenta);
}
function printTicketEntrega(idRequisicion){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketEntrega.php?idSr="+idRequisicion);
}

function printTicketVentaCancelada(idVenta){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketCancelado.php?idVenta="+idVenta);
}

function printTicketCharge(reference){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketCharge.php?reference="+reference);
}

function printTicketRefund(reference){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketRefund.php?reference="+reference);
}

function openRegister(){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/openRegister.php");
}

function printOpening(idOpeningRegister){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketApertura.php?idAperturaCaja="+idOpeningRegister);
}
function printResumen(){
   
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketResumen.php?idResumen="+ sessionStorage.idR);
    //alert(sessionStorage.idR);
}
function printClosing(idOpeningRegister){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketCierre.php?idCierreCaja="+idOpeningRegister);
}

function printDevolucion(idDevolucion){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketDevolucion.php?idDevolucion="+idDevolucion);
}

function printRetiro(idAperturaCaja,idRetiro){
    $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Tickets/printTicketRetiro.php?idAperturaCaja="+idAperturaCaja+"&idRetiro="+idRetiro);
}

function setModalCliente(btn){    
    var action = $(btn).data('action');
    
    if(action==='insert'){
        clearForm('cliente'); 
        $('form[name=cliente] #action').val(action); 
        $('#customerModalLabel').html('Agregar cliente');
        $('#modalAgregarClientePos').modal('show');
    }
    
    if(action==='edit'){
        if($('#customer').val() !== ''){
            setCustomerData();
            $('form[name=cliente] #action').val(action);
            $('#customerModalLabel').html('Actualizar cliente');
            $('#modalAgregarClientePos').modal('show');
        }
    }
}
function saveCliente(){ //alert($('#nombre').val());
   var options = $('form[name=cliente]').serializeArray();
   $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'saveCliente',
        options: options,
        idCustomer: $('#customer').val()
    }, function(data) {
        if (data.response){            
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
            $('#modalAgregarClientePos').modal('hide');
            $('form[name=cliente] #nombre_empresa').val('');
            $('form[name=cliente] #nombre').val('');
            $('form[name=cliente] #calle').val('');
            $('form[name=cliente] #ciudad').val('');
            $('form[name=cliente] #telefono').val('');
            $('form[name=cliente] #correo').val('');
            
            $('#s2id_customer').select2('destroy');
            $('#customer').html(data.listClientes);
            $('#customer').select2();
            setCustomerData();
        }else{
            $('#flashmessenger-agregarCliente').html(data.message);
             fadeOutAlert();
             
        }
    }, 'json');
}

function setCustomerData(){
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'getCustomerData',
        id: $('#customer').val()
    }, function(data) {
        if (data.response){     
            for (var name in data.customerData) {
                $('form[name=special-requisition] #'+name).val(data.customerData[name]);
                $('form[name=cliente] #'+name).val(data.customerData[name]);
            } 
            
            /*Si existe city, existe ciudad*/
            if(data.customerData['city']){
                $("#city").val(data.customerData['city']); 
            }
        }
    }, 'json');
}

function getVentasByIdRegister(id){    
     $('#dataVentaArqueo').html('');
     $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'getDataVenta',
        idRegister: id
    }, function(data) {
        if (data.response){          
            $('#dataResumenVenta').html(data.string);
            $('#modalResumenDeVenta').modal('show');
             fadeOutAlert();         
        }
    }, 'json');   
}

function setIdCheckRegister(id){    
     $('#dataVentaArqueo').html('');
     $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'getDataVentaArqueo',
        idRegister: id
    }, function(data) {
        if (data.response){          
            $('#dataVentaArqueo').html(data.string);
             fadeOutAlert();         
        }
    }, 'json');   
}

function deleteRegistry(link){     
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar el registro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                         document.location = link;
                    }
                }
            }
        });
        return null;
}

function sendReportToMail(){
    var optionsget = $("#optionsFromGet").val();
    var optionsmail = $("form[name=formMail]").serializeArray();

    $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'prepareToSendMail',
        optionsmail: optionsmail,
        optionsget: optionsget
    }, function(data) {
        if (data.response){  
            parent.document.location = data.reportUrl;
        }
    }, 'json');   
}

function enableToOpen(idStation){
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'enableToOpen',
        idStation: idStation
    }, function(data) {
        if (data.response){  
           document.location.reload();
        }
    }, 'json');   
}

    function disableToOpen(idStation){
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'disableToOpen',
        idStation: idStation
    }, function(data) {
        if (data.response){  
           document.location.reload();
        }
    }, 'json');   
}

    function setLastDevoluciones(){
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'getLastDevoluciones'
        }, function(data) {
            if (data.response){            
                $("#tblLastDevoluciones").find('tbody').empty().append(data.listLastDevoluciones);
            }
        }, 'json');    
    }
    
function deleteDevolucion(id){
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar devolucion',
            content: 'Desea eliminar la devolucion ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                       $('#producto').focus();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'deleteDevolucion',
                            id: id
                        }, function(data) {
                            if (data.response){
                                    $('#modalUltimasDevoluciones').modal('hide');
                            }else{
                                $('#flashmessenger').html(data.message);
                                fadeOutAlert();
                            }        
                        }, 'json');
                    }
                }
            }
        });
}

function setLastSales(){
     $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'getLastSales'
    }, function(data) {
        if (data.response){            
            $("#tblLastVentas").find('tbody').empty().append(data.listLastSales);
        }
    }, 'json');    
}

/*RECEIVINGS*/
function setReceivingDetails(byCode){ 
    var options = $("form[name=receiving]").serializeArray();
    var idDetailTemp = $('#idDetailTemp').val();
    
    $.post('/Controller/Receiving.php', {
        action: 'ajax',
        request: 'setReceivingDetails',
        options:options,
        byCode: byCode
    }, function(data) {
        if (data.response){
                $("#receiving-table").find('tbody').empty().append(data.receivingDetails);
                $("#totalItems").html(data.totalItems);                 
                $("#receivedItems").html(data.receivedItems); 
                
                $('#idDetailTemp').val('');
                $('#idProduct').val('');  
                $('#product').val('');   
                $('#product').autocomplete('close');
                $('#received').val('1');       
                //alert(idDetailTemp);
                if(idDetailTemp !== '' && idDetailTemp !== null){
                    document.location = '#_'+idDetailTemp;
                    window.scrollTo(window.scrollX, window.scrollY - 100);
                    
                    $('#_'+idDetailTemp).addClass('warning');
                    setTimeout(function(){ $('#_'+idDetailTemp).removeClass("warning"); }, 3000);
                    
                }
                
                
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetailReceivingToEdit(data){
    for (var name in data) {
        $('form[name=receiving] #'+name).val(data[name]); 
    } 
   
    $('#idProduct').val(data['product']);
    document.location = '#_fields';
    $('#received').focus();
    
}

function deleteReceivingDetails(id){ 
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar cantidad recibida',
            content: 'Desea eliminar cantidad recibida ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Receiving.php', {
                                action: 'ajax',
                                request: 'deleteDetalles',
                                id: id
                            }, function(data) {
                                if (data.response){
                                        $("#receiving-table").find('tbody').empty().append(data.receivingDetails);
                                        $("#totalItems").html(data.totalItems); 
                                        $("#receivedItems").html(data.receivedItems); 

                                        $('#idDetalleTemp').val('');
                                        $('#idProduct').val(''); 
                                        $('#product').val('');   
                                        $('#received').val('1');   
                                }else{
                                    $("#flashmessenger").html(data.mensaje);
                                }
                            }, 'json');
                    }
                }
            }
        });
}

function getShipmentData(){
    var numShipment = $('#num_shipment').val();
    
    $.post('/Controller/Receiving.php', {
        action: 'ajax',
        request: 'getShipmentData',
        numShipment:numShipment        
    }, function(data) {
        if (data.existReceiving){
            document.location = "Receiving.php?action=edit&id="+data.idReceiving;
        }
        
        $('#idDetailTemp').val('');
        $('#idProduct').val('');   
        $('#product').val('');   
        $('#received').val('');  
        $('#flashmessenger').html(data.message);
        
    }, 'json');
}

function onEnterReceiving(ev,element){
    if(ev === 13){
        switch(element.name){
            case 'product':
                $('#product').autocomplete('close');
                var idProduct = $("#product").val();
                $("#idProduct").val(idProduct);
                setReceivingDetails(true);
                break;
        }
    }
}

/*SPECIAL REQUISITIONS*/
function setSpecialRequisitionDetails(){ 
    var quantity = $('#quantity').val();
    var price = $('#price').val();
    var type = $('#type').val();
    /*
    if(quantity.trim() === '0' || price.trim() === '0' || quantity.trim() === '' || price.trim() === ''){
        $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-exclamation-triangle',
            title: 'Cantidad y/o Precio no puede ser cero',
            content: 'Cantidad y/o Precio deben ser mayor a cero !!',
            buttons:{                
                cancel: {
                    text:'Aceptar',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                }
            }
        });
        return null;
    }    */
    
    var options = $("form[name=special-requisition]").serializeArray(); 
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'setRequisitionDetails',
        options:options
    }, function(data) {
        if (data.response){
                $("#requisition-table").find('tbody').empty().append(data.requisitionDetails);               
                
                $('#idDetailTemp').val('');
                if(type === 'Special'){$('#category').val('0').trigger('change');}                
                $('#product').val('').trigger('change');
                $('#quantity').val('');
                $('#price').val('');
                $('#multiple').val('');
                $('#subTotal').val(data.grandTotal);
                $('#label_subTotal').html(number_format(data.grandTotal,2,'.',','));
                applyDiscount();
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetailSpecialRequisitionToEdit(data){
    applyDiscount();
    for (var name in data) {
        $('form[name=special-requisition] #'+name).val(data[name]);
    }  
    
    if(data['type']){
        $("#type").trigger('change'); 
        
        if(data['type'] === 'Line'){
            setUnsetCategoryField(function(){$("#product").select2('val',data['product']); });
        }else{
            setUnsetCategoryField();
        }
    }  
    
    if(data['category']){
        $("#category").trigger('change');            
        if(data['type']==='Special'){
            setSlicesForSpecialRequisition(function(){$("#product").val(data['product']).trigger('change'); });
        }
    }   
}

function deleteSpecialRequisitionDetails(id,item){
        $.confirm({
                theme: 'material',
                columnClass: 'col-md-6 col-md-offset-3',
                icon: 'fa fa-trash',
                title: 'Eliminar producto',
                content: 'Desea eliminar el producto ?',
                buttons:{                
                    cancel: {
                        text:'No',
                        btnClass: 'btn-default col-md-4 pull-right',
                        action: function(){
                           $(this).remove();
                        }
                    },
                    confirm: {
                        text: 'Si ',
                        btnClass: 'btn-primary col-md-4 pull-right',
                        action: function(){
                            var type = $(item).data('type');    
                            $.post('/Controller/Special-requisition.php', {
                                    action: 'ajax',
                                    request: 'deleteDetalles',
                                    id: id,
                                    type:type
                                }, function(data) {
                                    if (data.response){
                                            $("#requisition-table").find('tbody').empty().append(data.requisitionDetails); 
                                            $('#idDetalleTemp').val('');
                                            $('#product').val('');   
                                            $("#s2id_product").select2("val",'0');
                                            $('#quantity').val('1');                                            
                                            $('#multiple').val('');
                                            $('#subTotal').val(data.grandTotal);
                                            $('#label_subTotal').html(number_format(data.grandTotal,2,'.',','));
                                            $("#s2id_product").focus();
                                            applyDiscount();
                                    }else{
                                        $("#flashmessenger").html(data.mensaje);
                                        $("#s2id_product").focus();
                                    }
                                }, 'json');
                        }
                    }
                }
            });
}


function setSlicesForSpecialRequisition(callbackSetValue){
    var category = $('#category').val();
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'setSliceFlavor',
        category: category        
    }, function(data) {
        if (data.response){ 
            $('#s2id_product').select2("destroy");
            $('#product').html(data.listSlices);  
            $('#product').select2({placeholderOption: 'first'});
            
            if(callbackSetValue){
                 callbackSetValue();
            }
           
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function clearSpecialRequisitionDetails(){
    var type = $('#type').val();
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'clearSpecialRequisitionDetails',
        type: type
    }, function(data) {
        if (data.response){ 
            $("#requisition-table").find('tbody').empty(); 
            $('#category').select2({placeholderOption: 'first'});  
            $('#s2id_product').select2("destroy");
            $('#product').html(data.listSlices);  
            $('#product').select2({placeholderOption: 'first'});  
            $('#quantity').val('');
            $('#price').val('');
            $('#multiple').val(''); 
           
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setUnsetCategoryField(callbackSetValue){ 
    var type = $('#type').val();
    if(type !== 'Special'){ 
        $('#category').select2({placeholderOption: 'first'});  
        $('#category').prop("disabled", true);
    }else{        
        $('#category').prop("disabled", false);
    }
     
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'getListProducts',
        type: type
    }, function(data) {
        if (data.response){ 
            $('#product').html(data.listProducts); 
            $('#s2id_product').select2("destroy"); 
            $('#product').select2({placeholderOption: 'first'});  
            if(callbackSetValue){
                 callbackSetValue();
            }
           
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');    
    
}

function addPaymentToSpecialReq(idReq){
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'addPaymentToSpecialReq',
        idReq: idReq
    }, function(data) {
        if (data.response){ 
            document.location = '/Controller/Pos.php?sr';
        }
    }, 'json');    
}

/* END SPECIAL REQUISITION*/

/* SLICE */
function setSliceDetails(){
    var options = $("form[name=slice]").serializeArray();
    
    $.post('/Controller/Slice.php', {
        action: 'ajax',
        request: 'setSliceDetails',
        options:options        
    }, function(data) {
        if (data.response){
                $("#slice-table").find('tbody').empty().append(data.sliceDetails);
                
                $('#idDetailTemp').val('');
                $('#id_slice').val('');   
                $("#s2id_id_supplie").select2("val",'0');                
                $("#s2id_id_supplie").focus();
                $('#quantity').val('');  
                $('#unitMeasure').html('');  
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetailSliceToEdit(data){
    for (var name in data) {
        $('form[name=slice] #'+name).val(data[name]);
    } 

    if(data['id_supplie']){
        $("#s2id_id_supplie").select2("destroy");
        $("#s2id_id_supplie").select2(); 
        $("#s2id_id_supplie").select2('val',data['id_supplie']);  
    }
}

function deleteSliceDetalles(id){ 
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar producto',
            content: 'Desea eliminar el producto ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Slice.php', {
                            action: 'ajax',
                            request: 'deleteDetalles',
                            id: id
                        }, function(data) {
                            if (data.response){
                                    $("#slice-table").find('tbody').empty().append(data.listDetails);
                                    $('#idDetalleTemp').val('');
                                    $('#id_slice').val('');   
                                    $("#s2id_id_slice").select2("val",'0');
                                    $('#quantity').val('');    
                                    $('#unitMeasure').html('');   
                                    $("#s2id_id_slice").focus();
                            }else{
                                $("#flashmessenger").html(data.mensaje);
                                $("#s2id_id_slice").focus();
                            }
                        }, 'json');
                    }
                }
            }
        });
}
function getUnitMeasure(){
    var supplie = $('#id_supplie').val();
    $.post('/Controller/Slice.php', {
        action: 'ajax',
        request: 'getUnitMeasure',
        supplie: supplie        
    }, function(data) {
        if (data.response){ 
            $('#unitMeasure').html(data.unitMeasure); 
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}
/* END SLICES */

function cancelVenta(idVenta){
     $.post('/Controller/Pos.php', {
        action: 'ajax',
        request: 'cancelVenta',
        idVenta: idVenta
    }, function(data) {
        if (data.response){
            $('#flashmessenger-ultimasVentas').html(data.message);        
            $('#tblLastVentas').find('tbody').empty().append(data.lastSales);
            printTicketVentaCancelada(idVenta);
            fadeOutAlert();   
        }          
    }, 'json');
}

/* VALIDAR SUPERVISOR */
function confirmarAccion(operacion,callback){
    $.confirm({
        title: 'Confirmar accion !',
        icon: 'fa fa-key',
        content: '' +
        '<form action="" class="formName">' +
        '<div class="form-group">' +
        '<label>Ingresa usuario y contraseña para confirmar.</label>' +
        '<input id="usuario" type="text" placeholder="Usuario" class="name form-control" required />' +
        '<input id="contrasena" type="password" placeholder="Contrasena" class="name form-control" required />' +
        '</div>' +
        '</form>',
        buttons: {
            formSubmit: {
                text: 'Submit',
                btnClass: 'btn-blue',
                action: function () {
                    $.post('/Controller/Pos.php', {
                        action: 'ajax',
                        request: 'confirmarAccion',
                        usuario: $('#usuario').val(),
                        contrasena: $('#contrasena').val(),
                        operacion:operacion
                    }, function(data) {
                        if (data.response){
                            callback();
                        }else{                            
                            $('#flashmessenger').html(data.msg); 
                            return false;
                        }     
                    }, 'json');
                }
            },
            cancel: function () {
                //close
            }
        }
    });
}
/* RETIROS */

function saveRetiro(){
    var options = $("form[name=retiro]").serializeArray();
    
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'saveRetiro',
        options:options        
    }, function(data) {
        if (data.response){
            $("#tblRetiros").find('tbody').empty().append(data.retirosDetails);                 
            $('form[name=retiro] #id').val('');
            $('form[name=retiro] #monto').val('');  
            
            printRetiro(data.idAperturaCaja,data.idRetiro);
            
            $('#flashmessenger-retiro').html(data.message);
            fadeOutAlert();
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setRetiroToEdit(data){
    for (var name in data) {
        $('form[name=retiro] #'+name).val(data[name]);
    } 
}

function deleteRetiro(id){
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar Retiro',
            content: 'Desea eliminar Retiro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                       $('#producto').focus();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Ajax.php', {
                            action: 'ajax',
                            request: 'deleteRetiro',
                            id: id
                        }, function(data) {
                           if (data.response){
                                $("#tblRetiros").find('tbody').empty().append(data.retirosDetails);                 
                                $('form[name=retiro] #id').val('');
                                $('form[name=retiro] #monto').val('');                                  
                                
                                $('#flashmessenger-retiro').html(data.message);
                                fadeOutAlert();
                            }else{
                                $('#flashmessenger').html(data.message);
                                fadeOutAlert();
                            }
                        }, 'json');
                    }
                }
            }
        });
}

function changeStatusForSR(element){    
    var id =  $(element).data('id');
    var reqnumber =  $(element).data('reqnumber');
    var status =  $(element).data('status');
    var field =  $(element).data('statusfield');
    var statusName =  $(element).data('statusname');
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Cambiar status a Requisicion',
            content: 'Desea cambiar a status <b>'+ statusName+'</b> a esta Orden especial ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Special-requisition.php', {
                            action: 'ajax',
                            request: 'changeStatus',
                            id: id,
                            req_number:reqnumber,
                            field:field,
                            status: status
                        }, function(data) {
                            if (data.response){
                                if(field == 'status_production'){
                                    $('._'+id).html(data.btnStatus);
                                
                                }else if(field == 'status_delivery'){
                                    $('._statusDelivery_'+id).html(data.string);                                
                                }                                
                            }
                        }, 'json');
                    }
                }
            }
        });
    }
    
function setProductPrice(){
    var product = $('#product').val();
    var category = $('#category').val();
    var type = $('#type').val();
    
    if(type === 'Special' && product === '1'){
        $('#price').prop('readonly',false);
    }else{
        $('#price').prop('readonly',true);
    }
   
    $.post('/Controller/Special-requisition.php', {
        action: 'ajax',
        request: 'getProductPrice',
        type: type,
        product:product
    }, function(data) {
        if (data.response){ 
            $('#price').val(data.price);           
        }
    }, 'json');    
}

function deleteImage(image){     
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar imagen',
            content: 'Desea eliminar la imagen ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        var id = $(image).data('id');
                        $.post('/Controller/Special-requisition.php', {
                            action: 'ajax',
                            request: 'deleteImage',
                            id: id
                        }, function(data) {
                           if (data.response){
                               $(image).closest('.thumbail').remove();
                            }
                        }, 'json');
                    }
                }
            }
        });
        return null;
}

function setInventoryManually(){    
    var options = $('.optionsEditInvetory').serializeArray();
    
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'setInventoryManually',
        options: options
    }, function(data) {
        if (data.response){ 
            $('.optionsEditInvetory').val(''); 
            $('#'+data.idProduct+'_'+data.idStore).html(number_format(data.stock,2,'.',','));
            $('#modalEditInventory').modal('hide');
        }else{
            $('#flashmessenger-editInventory').html(data.message);
        }
    }, 'json');
}

/* TIMECLOCK*/

function setPunchTimeClock(){
    var nip_user = $('#nip_user').val();
    $('#nip_user').val('');
    $.post('/Controller/TimeClock.php', {
        action: 'ajax',
        request: 'setPunchTimeClock',
        nip_user: nip_user
    }, function(data) {
        if (data.response){ 
            //$("#tbl-punchstimeclock").find('tbody').empty().append(data.punchstimeclock);
            addMsgFlashmessenger('success',data.message,'flashmessenger-timeclock');
        }else{
            addMsgFlashmessenger('danger',data.message,'flashmessenger-timeclock');
        }
    }, 'json');
}
/**/

/* TIMECLOCK MOBILE*/
function updateTimeClock(){
    var options = $('form[name=timeClock]').serializeArray();
    $.post('/Controller/TimeClock.php', {
       action: 'ajax',
       request: 'updateTimeClock',
       options: options
       }, function(data) {
           if (data.response){     
               document.location.reload();
           }
       }, 'json');
}

function setDataToEditTimeClock(id){
        $.post('/Controller/TimeClock.php', {
        action: 'ajax',
        request: 'getDataToEdit',
        id: id
        }, function(data) {
            if (data.response){                    
                for (var name in data.timeClockInfo) {
                    $('form[name=timeClock] #'+name).val(data.timeClockInfo[name]);
                }                           
                $('#modalAgregarTimeClock').modal('show');
            }
        }, 'json');
    }
    
function deleteTimeClock(id){     
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar registro',
            content: 'Desea eliminar este registro ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/TimeClock.php', {
                            action: 'ajax',
                            request: 'deleteTimeClock',
                            id: id
                            }, function(data) {
                                if (data.response){     
                                    document.location.reload();
                                }
                            }, 'json');                       
                    }
                }
            }
        });
        return null;
}

/* END TIMECLOCK MOBILE*/

/*SHIPMENTS*/
function setShipmentDetails(byCode){ 
    var options = $("form[name=shipment]").serializeArray();
    options.push({name:'byCode',value:byCode});
    
    var filters = $('.column_filter').serializeArray();
    
    $.post('/Controller/Shipment.php', {
        action: 'ajax',
        request: 'setShipmentDetails',
        options:options
    }, function(data) {
        if (data.response){
                destroyDataTable('shipment-table');                
                $("#shipment-table").find('tbody').empty().append(data.shipmentDetails);
                $("#requiredItems").html(data.requiredItems);          
                $("#totalItems").html(data.totalItems);                 
                $("#receivedItems").html(data.receivedItems); 
                setDataTable('shipment-table');
                
                /*popular filtros - recorrer filter y asigna valores*/
                $(filters).each(function(i, field){
                    $('input[name='+field.name+']').val(field.value);
                });
                
                /*Apply the search*/
                var table = $('#shipment-table').DataTable();
                table.columns().every( function () {
                    var that = this; 
                    var criteria = $('input', this.footer()).val();

                    if(typeof criteria !== "undefined" && criteria !== ''){
                         if ( that.search() !== criteria ) {
                            that
                                .search (criteria.replace("/;/g", "|"), true, false)
                                .draw();
                        }
                    }
                       
                } );
                
                $('#idDetailTemp').val('');
                $('#idProduct').val('');   
                $('#product').val('');   
                $('#quantity').val('1');                  
        }else{
            $('#idProduct').val('');   
            $('#product').val('');   
            $.alert({ 
                title:"<i class='fa fa-info-circle'></i> Mensaje", 
                content:data.message,
                columnClass: 'col-md-6 col-md-offset-3',
                buttons: {   
                    ok: {
                        text: "OK",
                        btnClass: 'btn-default',
                        keys: ['enter'],
                        action: function(){
                             $(this).remove();
                        }
                    }
                }                      
            });     
        }
        $('#product').focus();
    }, 'json');
}

function setDetailShipmentToEdit(data){
    for (var name in data) {
        $('form[name=shipment] #'+name).val(data[name]);
    } 

    $('#idProduct').val(data['id_product']);
    $('#product').val(data['description']+' '+data['size']);
}

function deleteShipmentDetails(id){ 
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar envio',
            content: 'Desea eliminar el envio ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Shipment.php', {
                                action: 'ajax',
                                request: 'deleteDetalles',
                                id: id
                            }, function(data) {
                                if (data.response){
                                        $("#shipment-table").find('tbody').empty().append(data.shipmentDetails);
                                        $("#totalItems").html(data.totalItems); 
                                        $("#receivedItems").html(data.receivedItems); 

                                        $('#idDetalleTemp').val('');
                                        $('#product').val('');   
                                        $("#s2id_product").select2("val",'0');
                                        $('#quantity').val('');   
                                        $("#s2id_product").focus();
                                }else{
                                    $("#flashmessenger").html(data.mensaje);
                                    $("#s2id_product").focus();
                                }
                            }, 'json');
                    }
                }
            }
        });
}

function onEnterShipment(ev,element){
    if(ev === 13){
        switch(element.name){
            case 'product':
                $('#product').autocomplete('close');
                var idProduct = $("#product").val();
                //IdProduct seria el texto ingresado en el campo producto, que seria el codigo a buscar en tabla productos
                $("#idProduct").val(idProduct);
                setShipmentDetails(true);
                break;
        }
    }
}

/* END SHIPMENTS*/

/* REFUNDS */
    function setLastCardOperations(){
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'getLastCardOperations'
        }, function(data) {
            if (data.response){            
                $("#tblCardOperations").find('tbody').empty().append(data.lastCardOperations);
            }
        }, 'json');    
}
 
    function prepareRefund(e){
        $('#charge').val($(e).data('charge'));
        $('#modalRefund').modal('show');
    }
    
    function crateRefund(){
        var options = $('form[name=refund], form[name=refund] hidden').serializeArray();
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'refund',
            options: options
        }, function(data) {
            if (data.response){            
                $("#tblCardOperations").find('tbody').empty().append(data.lastCardOperations);
                $('#flashmessenger-lastCardOperations').html(data.msg);
                clearModalRefund();
                $('#modalRefund').modal('hide');
            }else{
                $('#flashmessenger-refund').html(data.msg);
            }
        }, 'json');
    }

    function clearModalRefund(){
       $("form[name=refund]")[0].reset();
       $('#flashmessenger-refund').html('');
       $('#modalRefund').modal('hide');
    }
    
    function getCardOperationBySale(sale){
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'getCardOperationBySale',
            sale: sale
        }, function(data) {
            if (data.response){            
                $("#tblCardOperations").find('tbody').empty().append(data.lastCardOperations);
            }
        }, 'json');    
    }
    
    /*END REFUNDS */
    
    /* VOID CARD TRANSACTION*/
    function voidTransaction(elem){ 
        $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar pago con tarjeta',
            content: 'Desea eliminar este pago con tarjeta ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Pos.php', {
                            action: 'ajax',
                            request: 'void',
                            transaction_id: $(elem).data('charge')
                        }, function(data) {
                            if (data.response){            
                                $("#tblCardOperations").find('tbody').empty().append(data.lastCardOperations);
                                $('#flashmessenger-lastCardOperations').html(data.msg);
                                clearModalRefund();
                                $('#modalRefund').modal('hide');
                            }else{
                                $('#flashmessenger-lastCardOperations').html(data.msg);
                            }
                        }, 'json');
                    }
                }
            }
        });
    }
    
    /*END VOID CARD TRANSACTION*/
    
    function showCardPaymentDetails(e){
        $('#modalCardOperationsDetails').modal('show');
        
        $.post('/Controller/Pos.php', {
            action: 'ajax',
            request: 'getDataPaymentDetails',
            charge: $(e).data('charge')
        }, function(data) {
            if (data.response){            
                $("#tblCardPaymentsLog").find('tbody').empty().append(data.cardPaymentsLog);
                $('.pd_sale').html(data.sale);
                $('.pd_card').html(data.card);
                $('.pd_amount').html("$ "+data.amount);
                $('.pd_status').html(data.status);
                
                $('#printReceipt').data("schemareceipt",data.schemaReceipt);
                $('#printReceipt').data("charge",data.charge);
            }
        }, 'json');
    }
    
    /* END REFUNDS*/
    
/* PRODUCT DETAILS (SLICES )*/
function setProductDetails(){    
    $.post('/Controller/Product.php', {
        action: 'ajax',
        request: 'setProductDetails',         
        idDetailTemp: $('#idDetailTemp').val(),
        slice_id: $('#slice_id').val(),
        slice_quantity: $('#slice_quantity').val()
,    }, function(data) {
        if (data.response){
                $("#productSlices-table").find('tbody').empty().append(data.productDetails);
                
                $('#idDetailTemp').val(''); 
                $("#slice_category").val('0');
                $("#slice_id").val('0');                
                $('#slice_quantity').val('');
                $("#s2id_slice_category").select2("val",'0');
                $("#s2id_slice_id").select2("val",'0');                
                $("#s2id_slice_id").focus(); 
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetailProductToEdit(data){
    for (var name in data) {
        $('#'+name).val(data[name]);
    } 
    
    if(data['slice_category']){
        $("#s2id_slice_category").select2("destroy");
        $("#slice_category").select2(); 
    }
    
    setSliceFlavor(function(){
        $('#slice_id').val(data['slice_id']);
        $('#s2id_slice_id').select2("val",data['slice_id']);
    });
       
}

function deleteProductDetalles(id){ 
     $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar parte del pastel',
            content: 'Desea eliminar parte del pastel ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Product.php', {
                            action: 'ajax',
                            request: 'deleteDetalles',
                            id: id
                        }, function(data) {
                            if (data.response){
                                    $("#productSlices-table").find('tbody').empty().append(data.listDetails);                
                                    $('#idDetailTemp').val(''); 
                                    $("#slice_category").val('0');
                                    $("#slice_id").val('0');                
                                    $('#slice_quantity').val('');
                                    $("#s2id_slice_category").select2("val",'0');
                                    $("#s2id_slice_id").select2("val",'0');                
                                    $("#s2id_slice_id").focus(); 
                            }
                            
                            $("#flashmessenger-slices").html(data.message);
                            
                        }, 'json');
                    }
                }
            }
        });
}

function setSliceFlavor(callbackSetValue){
    var category = $('#slice_category').val();
    $.post('/Controller/Product.php', {
        action: 'ajax',
        request: 'setSliceFlavor',
        category: category        
    }, function(data) {
        if (data.response){ 
            $('#s2id_slice_id').select2("destroy");
            $('#slice_id').html(data.listSlices);  
            $('#slice_id').select2();
            if(callbackSetValue){
                 callbackSetValue();
            }
           
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

 /* END PRODUCT DETAILS*/
 
  /* STORES */
function setStoreDetails(){ 
    var options = $("form[name=sucursal]").serializeArray();
    options.push({name:'days',value:$("#days").val()});
    
    $.post('/Controller/Store.php', {
        action: 'ajax',
        request: 'setStoreDetails',
        options:options        
    }, function(data) {
        if (data.response){
                $("#store-table").find('tbody').empty().append(data.storeDetails);
                $("#totalItemsMin").html(data.totalItemsMin);       
                $("#totalItemsMax").html(data.totalItemsMax);       
                
                $('#idDetailTemp').val('');
                $('#product').val('');   
                $("#s2id_product").select2("val",'0');
                $('#min').val('');    
                $('#max').val('');    
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetailStoreToEdit(data){
    for (var name in data) {
        $('form[name=sucursal] #'+name).val(data[name]);
    } 
    
    if(data['product']){
        $("#s2id_product").select2("destroy");
        $("#product").select2(); 
    }
    
    if(data['days']){
        $("#days").select2('destroy');
        var values = data['days'];
        
        $.each(values.split(","), function(i,e){
            $("#days option[value='" + e + "']").prop("selected", true);
        });
        
        $('#days').select2();
    }
}

function deleteStoreDetails(id){ 
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar producto',
            content: 'Desea eliminar el producto ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-primary col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Store.php', {
                                action: 'ajax',
                                request: 'deleteDetalles',
                                id: id
                            }, function(data) {
                                if (data.response){
                                        $("#store-table").find('tbody').empty().append(data.storeDetails);
                                        $("#totalItemsMin").html(data.totalItemsMin); 
                                        $("#totalItemsMax").html(data.totalItemsMax); 

                                        $('#idDetalleTemp').val('');
                                        $('#product').val('');   
                                        $("#s2id_product").select2("val",'0');
                                        $('#min').val('');   
                                        $('#max').val('');   
                                        $("#s2id_product").focus();
                                }else{
                                    $("#flashmessenger").html(data.mensaje);
                                    $("#s2id_product").focus();
                                }
                            }, 'json');
                    }
                }
            }
        });
}

/* END STORES*/
 
    
/*REQUISITIONS*/
function setRequisitionDetails(){ 
    var options = $("form[name=requisition]").serializeArray();
    var filters = $('.column_filter').serializeArray();
    
    $.post('/Controller/Requisition.php', {
        action: 'ajax',
        request: 'setRequisitionDetails',
        options:options        
    }, function(data) {
        if (data.response){
                destroyDataTable('requisition-table');                
                $("#requisition-table").find('tbody').empty().append(data.requisitionDetails);
                $("#totalItems").html(data.totalItems);                 
                $("#producedItems").html(data.producedItems); 
                setDataTable('requisition-table');
                
                /*popular filtros - recorrer filter y asigna valores*/
                $(filters).each(function(i, field){
                    $('input[name='+field.name+']').val(field.value);
                });
                
                /*Apply the search*/
                var table = $('#requisition-table').DataTable();
                table.columns().every( function () {
                    var that = this; 
                    var criteria = $('input', this.footer()).val();

                    if(typeof criteria !== "undefined" && criteria !== ''){
                         if ( that.search() !== criteria ) {
                            that
                                .search (criteria.replace("/;/g", "|"), true, false)
                                .draw();
                        }
                    }                       
                } );
                
                $('#idDetailTemp').val('');
                $('#product').val('0').trigger('change');   
                $('#quantity').val('');      
                
                $('#product').select2('open');
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetailRequisitionToEdit(data){
    for (var name in data) {
        $('form[name=requisition] #'+name).val(data[name]);
    } 
    
    $("#product").trigger('change'); 
    $('#quantity').select().focus();
}

function deleteRequisitionDetails(id){ 
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar producto',
            content: 'Desea eliminar el producto ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-success col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Requisition.php', {
                                action: 'ajax',
                                request: 'deleteDetalles',
                                id: id
                            }, function(data) {
                                if (data.response){
                                        $("#requisition-table").find('tbody').empty().append(data.requisitionDetails);
                                        $("#totalItems").html(data.totalItems); 
                                        $("#producedItems").html(data.producedItems); 

                                        $('#idDetalleTemp').val('');
                                        $('#product').val('');   
                                        $("#s2id_product").select2("val",'0');
                                        $('#quantity').val('');   
                                        $("#s2id_product").focus();
                                }else{
                                    $("#flashmessenger").html(data.mensaje);
                                    $("#s2id_product").focus();
                                }
                            }, 'json');
                    }
                }
            }
        });
}

 function createWorkOrderFromInventoryReport(){
        var wordOrder = $('#work_order').val();
        $.post('/Controller/Requisition.php', {
            action: 'ajax',
            request: 'createWorkOrderFromInventoryReport',
            wordOrder: wordOrder
        }, function(data) {
           if (data.response){ 
               document.location = '/Controller/Requisition.php?action=edit&id='+data.idRequisition;
            }
        },'json');
    }
    
function changeStatusBaked(element){    
    var id =  $(element).data('id');
    var reqNumber =  $(element).data('reqnumber');
    var field = $(element).data('statusfield');
    var controller = $(element).data('controller');
    var status =  $(element).data('status');
    var statusName =  $(element).data('statusname');
    
     $.post('/Controller/'+controller+'.php', {
        action: 'ajax',
        request: 'changeStatus',
        id: id,
        field: field,
        status: status
    }, function(data) {
       if (data.response){ 
           if(status === 2){
               $('#req_'+reqNumber).prop("disabled", false);
               $('#req_'+reqNumber).prop("checked", true);
           }else{                            
               $('#req_'+reqNumber).prop("disabled", true);
               $('#req_'+reqNumber).prop("checked", false);
           }

           $('.'+reqNumber).removeClass('btn-primary');
           $('.'+reqNumber).addClass('btn-default');
           $(element).removeClass('btn-default');
           $(element).addClass('btn-primary');
        }
    }, 'json');
}    
    function getImagesForSR(idReq){
        $('#divImages').html('');
        $.post('/Controller/Special-requisition.php', {
            action: 'ajax',
            request: 'getImages',
            idReq: idReq
        }, function(data) {
           if (data.response){ 
               $('#divImages').html(data.images);
            }
        },'json');
    }      
    
//Store Request
   function updateStoreRequestQty(callback){
    var store_request_quantity = $('._storeRequestQuantity', table.rows().nodes()).serializeArray();
     $.post('/Controller/Store-request.php', {
        action: 'ajax',
        request: 'updateStoreRequestQty',
        token_form: $('#token_form').val(),
        storage_request_quantity: store_request_quantity
    }, function(data) {
        if (data.response){
            callback();
        }else{
            $('#flashmessenger').html(data.message);
        }
    }, 'json');
}

function generateShipment(id){
     $.post('/Controller/Store-request.php', {
        action: 'ajax',
        request: 'generateShipment',
        id_store_request: id
    }, function(data) {
        if (data.response){
           $('#flashmessenger').html(data.msg);           
        }
    }, 'json');
}
function deleteReportSaleList(id){ 
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-trash',
            title: 'Eliminar producto',
            content: 'Desea eliminar venta?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-success col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Reports.php', {
                            action: 'ajax',
                            request: 'deleteReportSaleList',
                            id: id
                        }, function(data) {
                            if (data.response){
                                $("td.venta_"+id+"").html("Cancelado");
                                
                            }
                        }, 'json');
                    }
                }
            }
        });
}

function applyDiscount(){
    var discount = $('#discount').val();
    var monto = $('#subTotal').val();
    if(monto !== '0' && monto !== ''){
        var descuento = (monto)*(discount/100);
        var ammount = monto - descuento;
        $('#ammount').val(ammount);
        $('#label_grandTotal').html(number_format(ammount,2,'.',','));
        $('#label_descuento').html(number_format(descuento,2,'.',','));
    }
    return null;
}

/* LOAD LINES*/
function setTypeRequisition(value){
    var requisition = value.split("-");
    $('#type').val(requisition[1]);
}

function confirmAction(line){
    var action = $(line).data('action');
    var idLoadLine = $(line).data('loadline');
    var request = $(line).data('request'); 
    
    $.confirm({
            theme: 'material',
            columnClass: 'col-md-6 col-md-offset-3',
            icon: 'fa fa-exclamation-triangle',
            title: 'Confirmar accion',
            content: 'Desea ejecutar la accion '+action+' ?',
            buttons:{                
                cancel: {
                    text:'No',
                    btnClass: 'btn-default col-md-4 pull-right',
                    action: function(){
                       $(this).remove();
                    }
                },
                confirm: {
                    text: 'Si ',
                    btnClass: 'btn-success col-md-4 pull-right',
                    action: function(){
                        $.post('/Controller/Load-line.php', {
                                action: 'ajax',
                                request: request,
                                idLoadLine: idLoadLine
                            }, function(data) {
                                if (data.response){
                                    document.location = 'Load-line.php';
                                }
                            }, 'json');
                    }
                }
            }
        });
}

function setIdLoadLine(){
    var idLoadLine = $('#id_load_line').val();
    
    $.post('/Controller/Production.php', {
                      action: 'ajax',
                      request: 'setIdLoadLine',
                      idLoadLine: idLoadLine
                  }, function(data) {
                      if (data.response){
                          document.location = 'Production.php';
                      }
                  }, 'json');
}

function setInfoProduction(detail){    
    $('#quantity').val('');
    $('#id_product').val($(detail).data('idproduct'));
    $('#infoProducto').html($(detail).data('description'));
    $('#modalProduction').modal('show');
}

function saveProduction(){
    var options = $("form[name=production]").serializeArray();
    $.post('/Controller/Production.php', {
        action: 'ajax',
        request: 'saveProduction',
        options: options
    }, function(data) {
        if (data.response){           
            $('#idProductionDetailToPrintLabel').val(data.idDetail);
            $('#quantityPrintLabelForLine').val($('#quantity').val());
            $('#infoPrintLabelForLine').html(data.descripcion);
            
            printLabelForLine();
            
            $('#quantity').val('');
            $('#id_product').val('');
            $('#id_detail').val('');       
            $('#modalProduction').modal('hide');
        }
    }, 'json');
}

function setDetailProductionToEdit(data,detail){
    for (var name in data) {
        $('form[name=production] #'+name).val(data[name]);
    } 
    $('#infoProducto').html($(detail).data('description'));
    $('#modalProduction').modal('show');
}

function setInfoPrintLabelForLine(detail){
        $('#idProductionDetailToPrintLabel').val($(detail).data('idproductiondetail'));
        $('#quantityPrintLabelForLine').val('');
        $('#infoPrintLabelForLine').html($(detail).data('description'));
    }
    
    function printLabelForLine(){
        var idDetail = $('#idProductionDetailToPrintLabel').val();
        var copies = $('#quantityPrintLabelForLine').val();
        $("#iframe").attr("src", "http://pcgus.demo.lpcg.mx/View/Labels/printLabelForLine.php?idReq="+idDetail+"&copies="+copies);
    }
    
    function printLabelForSR(idReq){
        $("#iframe").attr("src", "https://paris.ware.mymg.app//View/Labels/printLabelForSR.php?idReq="+idReq);
    }

