<?php
class ReceivingForm extends Form {    
    public function __construct() {
        $this->setName('receiving');
        $this->setActionForm('Receiving.php');
        $this->setClass('receiving form-horizontal');
        $this->setMethod('post');
        $this->setDefaultFormLabelsColSize('4');
        $this->setDefaultFormElementsColSize('8');
        parent::__construct();
        $this->init();
    }

    public function init() {          
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'from_store'
         ));
         
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'from_to'
         ));
         
          $this->addElement(array(
            'type' => 'text',
            'name' => 'statusName',
            'label'=>'Status',
            'optionals'=>array('readOnly'=>'readOnly'),
            'required'=>false,
        ));      
          
        $attributes_wrapper_append_select = array('class'=>'select2-bootstrap-append');
        
        $attributes_wrapper_append_date = array('class'=>'date','id'=>'dateDatePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'validators'=>array('datetime'),
            'required'=>true,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));  
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'num_shipment',
            'label'=>'Num de envio'
         ));
         
        $append = "<span class = 'btn input-group-addon' onclick='getShipmentData()'><i class='fa fa-eye'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'num_shipment',
            'label'=>'Num de envio',
            'required'=>true,
            'append'=>$append
        ));  
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments',
            'label'=>'Notas',
            'required'=>false
        ));  
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'status'
        ));   
                 
         /*Se utiliza para consulta si existe en la tabla de requisitions_details_X, si existe se actualiza registro.*/
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        ));         
         
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idProduct',
            'required'=>false
        )); 
         
        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'product',
            'label'=>'Producto',
             'optionals'=>array('onKeyPress'=>'onEnterReceiving(event.keyCode,this)','placeholder'=>'Teclea o escanea producto para recibir'),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
            'append'=>$append

        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'received',
            'label'=>'Recibido',
            'value'=>'1',
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-success',
            'optionals'=>array('onClick'=>'setReceivingDetails()')
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'terminar',
            'value'=>$this->_getTranslation('Terminar'),
            'class'=>'btn btn-primary',
            'optionals'=>array("onClick"=>"submit('receiving')")
        ));        
    }
    
    public function getListProducts(){
        $repository = new ProductoRepository();
        #1 = status activo
        $productos = $repository->getListaProductos('1');
        
        $array = array('0'=>'');        
        foreach($productos as $producto){      
            $array[$producto['id']] = $producto['codigo']." - ".$producto['descripcion']." ".$producto['tamano'];
        }
        
        $list= array();
        foreach ($array as $key => $value) {
            $list[$key] = $value;
        }
        return $list;
    }
    
    public function getListStores(){
        return array('1'=>'Almacen');
        $repo = new GenericRepository();
        $result = $repo->getListSelectStores();
        
        if(count($result)>1){ $array = array(''=>'Seleccionar una opcion...');}
        if ($result) {               
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }        
    }
    
    public function populate($data) { 
        $tools = new Tools();
        if(isset($data['date'])){
            $data['date'] = $tools->setFormatDateTimeToForm($data['date']);
        }
        parent::populate($data);
    } 
}