<?php
class StoreRequestRepository extends EntityRepository {

    private $table = 'store_request';
    public $flashmessenger = null;
    private $options = array (
        'date' => null,
        'store_id' => null,
        'comments'=>null,
        'status'=>null);
    
    private $options_aux = array(
        'token_form'=>null,
        'formatedDate'=>null,
        'statusName'=>null
    );
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getStatus(){
        return $this->options['status'];
    }
    
    public function getStoreId(){
        return $this->options['store_id'];
    }
    
    public function getStatusName(){
        return $this->options_aux['statusName'];
    }
    
    public function getFormatedDate(){
        return $this->options_aux['formatedDate'];
    }
    
     public function getComments(){
        return $this->options['comments'];
    }
    
    public function getTokenForm(){
        return $this->options_aux['token_form'];
    }

    public function save(array $data, $table = null) {              
        $tools = new Tools();        
        $login = new Login();
        $data['date'] = $tools->setFormatDateToDB($data['date']); 
        $data['status'] = '1'; 
        $data['creado_fecha'] = date('Y-m-d H:i:s');
        $data['creado_por'] = $login->getId();
        
        $this->startTransaction();        
        parent::save($data, $this->table);     
        $idStoreRequest = $this->getInsertId();
        $this->setLastInsertId($idStoreRequest);
        
        $storeRequestDetallesTemp = new StoreRequestDetailsTempRepository();       
        if($storeRequestDetallesTemp->saveDetalles($idStoreRequest,$this->getTokenForm())){ 
                $this->commit();
                $storeRequestDetallesTemp->truncate($this->getTokenForm());
                return true;   
        }
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }

    public function update($id, $data, $table = null) {         
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);        
                
        $this->startTransaction();
        $result = parent::update($id, $data, $this->table);  
        if($result){
            $repository = new StoreRequestDetailsTempRepository();
            if($repository->updateDetalles($id,$this->getTokenForm())){      
                $this->commit();
                $repository->truncate($this->getTokenForm());                   
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }    
        
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status'] === '2'){return true;}
        
        return parent::update($id, array('status'=>'2'), $this->table);
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "fxGetStoreName(store_id) as storeName,"
                . "DATE_FORMAT(date,'%m/%d/%Y')as formatedDate,"
                . "fxGetStatusName(status,'status','Store-request')as statusName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        
        $query = "CREATE TABLE IF NOT EXISTS store_request_details_".$login->getId()." 
                 (  `id` int(11) NOT NULL AUTO_INCREMENT,
                    `token_form` char(50) NOT NULL,
                    `id_detalle` int(11) NULL,
                    `id_store_request` int(11) NULL,                    
                    `id_product` int(11) NOT NULL,
                    `id_size` int(11) NOT NULL,
                    `quantity` double NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function getStoreRequestDetalles($token_form){
        $login = new Login();
       $query = "SELECT p.id as productoID,s.*,p.descripcion,fxGetTamanoDescripcion(p.tamano)as sizeName
                  FROM store_request_details_".$login->getId()." s, productos p 
                  WHERE s.id_product = p.id  
                  AND token_form = '$token_form'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getStoreRequestDetallesSaved($id){
        $query = "SELECT *,
                    fxGetProductoDescripcion(id_product)as description,
                    fxGetTamanoDescripcion(id_size)as size
                    FROM store_request_details
                    WHERE id_store_request = '$id' 
                    ORDER BY id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getStoreRequestDetallesSavedPDF($id){
        $query = "SELECT d.*,
                    fxGetProductoDescripcion(id_product)as description,
                    fxGetTamanoDescripcion(id_size)as size
                    FROM store_request_details d
                    WHERE id_store_request = '$id' 
                    AND quantity > 0
                    ORDER BY id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setStoreRequestDetallesById($idStoreRequest,$tokenForm){
        $repo = new StoreRequestDetailsTempRepository();
        return $repo->setStoreRequestDetallesById($idStoreRequest, $tokenForm);
    }

    public function getListStoreRequest($options = null){
        $login = new Login();
        $store_request_id = null;
        $store_id = null;
        $status = null;
        $limit = null;
        
        $date = $this->createFilterFecha($options,'date');
        
        /* 14 = Sucursal*/
        if($login->getRole() === '14'){
            $store_id = " AND store_id = '{$login->getStoreId()}'";
            
        }elseif(isset($options['store_id']) && is_array($options['store_id']) && count($options['store_id']) > 0){
            $idsStore = implode(',', $options['store_id']);
            $store_id = " AND find_in_set(store_id,'$idsStore')";
        }      

        if(trim($options['store_request_id']) !== ''){$store_request_id = " AND find_in_set(m.id,'{$options['store_request_id']}')";}
        
        if(isset($options['status']) && is_array($options['status']) && count($options['status']) > 0){
            $idsStatus = implode(',', $options['status']);
            $status = " AND find_in_set(status,'$idsStatus')";
        }  
        
        if($options === null){
            $limit = " LIMIT 100 ";
        }
        
        $query = "SELECT m.*,"
                . "fxGetStoreName(store_id) as storeName,"
                . "DATE_FORMAT(date,'%m/%d/%Y')as formatedDate,"
                . "fxGetStatusName(status,'status','Store-request')as statusName "
                . "FROM $this->table m LEFT JOIN store_request_details d ON m.id = d.id_store_request "
                . "WHERE 1 = 1  "
                . "$store_request_id "
                . "$store_id "
                . "$status "
                . "$date "
                . "GROUP BY m.id "
                . "ORDER BY m.id DESC "
                . "$limit ";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function _generateShipment($idStoreRequest){
        $repo = new ShipmentRepository();
        $settings = new SettingsEntity();
        
        $dataExist = $repo->existShipmentForStoreRequest($idStoreRequest);
        if($dataExist != null){
            $msg = $this->_getTranslation('Ya existe un envio para este pedido. Envio #');
            $msg .=" <a href='Shipment.php?action=edit&id={$dataExist['id']}'>{$dataExist['num_shipment']}</a>";
            $this->flashmessenger->addMessage(array('danger'=>$msg));
            return array(
                'response'=>true,
                'msg'=>$this->flashmessenger->getMessageString()
            );
        }
        
        $data = $this->getById($idStoreRequest);
        
        if($data['status'] =='2'){return array('response'=>false);}
        
        #Save 
        $shipmentData = array(
            'date'=>$data['date'],
            'id_store_request'=>$idStoreRequest,
            'from_store'=>$settings->_get("default_store_for_shipment"),
            'to_store'=>$data['store_id'],
            'status'=>'1'
        );
        
        parent::startTransaction();
        parent::save($shipmentData, $repo->getTableName());
        $idShipment = parent::getInsertId();
        
        $numShipment = $repo->getPrefixNumberShipment().str_pad($idShipment, 7, '0', STR_PAD_LEFT);
        parent::update($idShipment, array('num_shipment'=>$numShipment), $repo->getTableName());
        
        $login = new Login();
        $details = $this->getStoreRequestDetallesSaved($idStoreRequest);
        
        $repoStore = new StoreRepository();
        $minStockByProduct = $repoStore->getMinimumStockForStoreByDay(date('N',strtotime($data['date'])));
        foreach($details as $detail){
            if($detail['quantity'] >= 0){
                $minStock = 0;
                if(isset($minStockByProduct[$data['store_id']][$detail['id_product']])){$minStock = $minStockByProduct[$data['store_id']][$detail['id_product']];}
                
                if($detail['quantity'] < $minStock){
                        $arrayDetail = array(
                        'id_shipment'=>$idShipment,
                        'id_product'=>$detail['id_product'],
                        'min_stock'=>$minStock,
                        'real_stock_in_store'=>$detail['quantity'],
                        'quantity'=>0,
                        'creado_por'=>$login->getId(),
                        'creado_fecha'=>date('Y-m-d H:i:s')
                    );
                    parent::save($arrayDetail, 'stores_shipments_details');
                }               
            }
        }
        
        parent::commit();
        $msg = $this->_getTranslation('Se genero envio exitosamente. Envio #');
        $msg .=" <a href='Shipment.php?action=edit&id={$idShipment}'>{$numShipment}</a>";
        $this->flashmessenger->addMessage(array('success'=>$msg));
        return array(
            'response'=>true,
            'msg'=>$this->flashmessenger->getMessageString()
        );
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['fechaInicio']) && !isset($options['fechaFin'])){return null;}        
        $fechaInicio = $options['fechaInicio'];
        $fechaFin = $options['fechaFin'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
}