<?php
class StoreOutRepository extends EntityRepository {

    private $table = 'store_out';
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }

    public function save(array $data, $table = null) {      
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $data['status'] = '1';
        unset($data['id']);
        
        $this->startTransaction();        
        parent::save($data, $this->table);        
        
        $storeInDetailsTemp = new StoreOutDetailsTempRepository();
        $idStoreOut = $this->getInsertId();
        $this->setLastInsertId($idStoreOut);//Para utilizarlo en el Controller action insert
        
        if($storeInDetailsTemp->saveDetalles($idStoreOut)){              
            $this->commit();
            $storeInDetailsTemp->drop();
        
            return true;
        }
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }
    
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status'] == '2'){return true;}
        
        $this->startTransaction();
        $rs = parent::update($id, array('status'=>'2'), $this->table);    
        if($rs){
            $repoSupplieInventory = new InventorySupplieRepository();
            $details = $this->getStoreOutDetailsSaved($id);
            if($details){                
                foreach($details as $detail){
                    if(!$repoSupplieInventory->addInventory($detail)){
                        $this->rollback();
                        return null;
                    }
                }                
            }
            $this->commit();
            return true;
        }
        $this->rollback();
        return null;
    }

    public function update($id, $data, $table = null) {              
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        if(trim($data['status']) == ''){unset($data['status']);}       
        
        $this->startTransaction();
        //Actualizo tabla store_out
        $result = parent::update($id, $data, $this->table);        
        if($result){
            $repository = new StoreOutDetailsTempRepository();
            if($repository->updateDetalles($id)){                      
                $this->commit();
                $repository->drop();   
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "fxGetStatusName(status,'status','storeOut')as statusName, "
                . "fxGetUserName(creado_por)as userName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('compras' => 'id')," AND status = 2 AND (type != 'BienesyServicios' AND type != 'Consigna' AND type != 'MateriaPrima')");
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        $query = "DROP TABLE IF EXISTS store_out_details_".$login->getId();
        $this->query($query);
        
        $query = "CREATE TABLE IF NOT EXISTS store_out_details_".$login->getId()." 
                 (  `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_store_out` int(11) NULL,  
                    `idProduct` int(11) NOT NULL,
                    `quantity` double NOT NULL,
                    `location` int(11) NOT NULL,                    
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $storeOutDetailsTemp = new StoreOutDetailsTempRepository();
        
        return $storeOutDetailsTemp->save($data);
    }
    
    public function getStoreOutDetails(){
        $login = new Login();
        $query = "SELECT v.*,
                    v.id as idDetailTemp,
                    p.code,
                    p.description,
                    fxGetBrandDescription(p.brand)as brand,
                    fxGetPresentationDescription(p.presentation)as presentation,
                    fxGetLocationDescription(v.location)as location
                  FROM store_out_details_".$login->getId()." v LEFT JOIN supplies p
                  ON v.idProduct = p.id
                  ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getStoreOutDetailSaved($id){
        $query = "SELECT c.*,
                    p.code as code
                    FROM store_out_details c LEFT JOIN supplies p ON c.idProduct = p.id
                    WHERE c.id = '$id' "
                ;
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result)[0];
            return $result;
        }
        
        return null;
    }
    
    public function getStoreOutDetailsSaved($id,$idProduct = null){
        if($idProduct){ $idProduct = " AND c.idProduct = $idProduct";}
        $query = "SELECT c.*,
                    p.code as code,
                    p.description,
                    fxGetBrandDescription(p.brand)as brandName,
                    fxGetPresentationDescription(p.presentation)as presentationName,
                    fxGetLocationDescription(c.location)as locationName
                    FROM store_out_details c LEFT JOIN supplies p ON c.idProduct = p.id
                    WHERE c.id_store_out = '$id' $idProduct"
                ;
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setStoreOutDetailsById($idCompra){
        $repository = new StoreOutDetailsTempRepository();
        
        return $repository->setStoreOutDetailsById($idCompra);
    }
    
    public function truncateIfIsEditInfo(){
        $repository = new StoreOutDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
        
    }
    
    public function getSupplieById($idSupplie){
        $query = "SELECT * FROM supplies WHERE id = '$idSupplie' LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    
    public function getListStoreOut(){          
        $query = "SELECT c.*,
                DATE_FORMAT(c.date,'%d/%m/%Y')as date,
                fxGetStatusName(c.`status`,'status','storeOut')as statusName,
                fxGetUserName(c.creado_por)as user
                FROM store_out c
                LEFT JOIN store_out_details d ON c.id = d.id_store_out
                WHERE  1=1 " 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        return null;
  }
  
  public function getListSelectLocations(){
        $query = "SELECT * FROM locations ORDER BY id ASC";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->name;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
}