<?php
class ShipmentDetailsTempRepository extends EntityRepository {

    private $table = 'stores_shipments_details_';
    
    public function __construct(){
        $login = new Login();
        $this->table = $this->table.$login->getId();
    }
    // Guarda en temporal
    public function save(array $data, $table = null) {
        if(isset($data['idDetailTemp']) && trim($data['idDetailTemp'])!= ''){
            $result = $this->getById($data['idDetailTemp']);
            if($result){
                $id = $data['idDetailTemp'];
                unset($data['idDetailTemp']);    
                return parent::update($id, $data,$this->table);
            }
        }

        unset($data['idDetailTemp']);        
        $query = "SELECT id,quantity FROM ".$this->table.
                " WHERE id_product = '".$data['id_product']."' AND token_form = '{$data['token_form']}'";
        
        $result = $this->query($query);      
         
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $data['quantity'] = $data['quantity'] + $result->quantity;
            $id = $result->id;
            return parent::update($id, $data,$this->table);
        }else{
            return parent::save($data, $this->table);
        }
    }
    
    // Guarda en tabla shipment_detalles
    public function saveDetalles($idShipment,$idSucursal, $tokenForm){
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        if($result->num_rows > 0){           
            $result = $this->resultToArray($result);            
            $repoProduct = new InventarioRepository();
            foreach($result as $data){
                $data['id_shipment'] = $idShipment;
                unset($data['id'],$data['id_detail'],$data['received'], $data['token_form']);
                
                if(parent::save($data, 'stores_shipments_details')){
                    if(!$repoProduct->subInventory(array(
                        'id_product'=>$data['id_product'],
                        'quantity'=>$data['quantity'],
                        'sucursal'=>$idSucursal,
                        'controller'=>'Envios-agregar '.$idShipment))){
                        return null;
                    }
                }else{
                    return null;
                }
            }  
        }         
        return true;
    } 
    
    public function updateDetalles($idShipment,$idSucursal, $tokenForm){
        $query = "SELECT id,id_product,quantity FROM stores_shipments_details WHERE id_shipment = '$idShipment'";
        $result = $this->query($query);
        $detallesOrigin = null;    
        if($result->num_rows > 0){
            $detallesOriginTemp = $this->resultToArray($result);
            foreach($detallesOriginTemp as $detalle){
                $detallesOrigin[$detalle['id']] = $detalle;
            }
        }
        
        $query = "SELECT * FROM $this->table WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        $idsDetalles = array(); 
        $repoProduct = new InventarioRepository(); 
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            
            foreach($result as $data){
                $idDetalle = $data['id_detail'];                
                $data['id_shipment'] = $idShipment;
                unset($data['id'],$data['id_detail'],$data['received'], $data['token_form']);
              
                if(!$idDetalle){
                    if(parent::save($data, 'stores_shipments_details')){
                        if(!$repoProduct->subInventory(array(
                            'id_product'=>$data['id_product'],
                            'quantity'=>$data['quantity'],
                            'sucursal'=>$idSucursal,
                            'controller'=>'Envios-editar '.$idShipment))){
                            return null;
                        }
                    }
                }else{
                    #contiene los idDetalles de la requisicion original que se mantendran, lo que no esten aqui se eliminaran.
                    $currentData = $detallesOrigin[$idDetalle];
                    $idsDetalles[] = $idDetalle;
          
                    if(parent::update($idDetalle,$data, 'stores_shipments_details')){
                        if(!$repoProduct->updateSubInventory(array(
                                'id_product'=>$data['id_product'],
                                'current_quantity'=>$currentData['quantity'],
                                'new_quantity'=>$data['quantity'],
                                'sucursal'=>$idSucursal,
                                'controller'=>'Envios-editar '.$idShipment))){
                            return null;
                        }
                    }
                    //echo "ahora si";exit;
                }  
            }
        }

        #Se eliminan ids de tabla requisition_details que ya no estan en $idsDetalles (este array contiene los ids que permanececieron en la requisicion despues del update)                
        if($detallesOrigin){
            foreach ($detallesOrigin as $detalle){
                if(!in_array($detalle['id'], $idsDetalles)){                    
                    if(parent::delete($detalle['id'], 'stores_shipments_details')){                        
                        if(!$repoProduct->addInventory(array(
                            'id_product'=>$detalle['id_product'],
                            'quantity'=>$detalle['quantity'],
                            'sucursal'=>$idSucursal,
                            'controller'=>'Envios-agregar '.$idShipment))){
                            return null;
                        }
                    }
                }
            }
        }  
            
        return true;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }
    
    public function truncate($tokenForm){
        $query = "DELETE FROM ".$this->table." WHERE token_form = '$tokenForm'";
        $result = $this->query($query);
        
        if($result){
            return true;
        }
        
        return null;
    }
    
    public function setShipmentDetailsById($idShipment,$tokenForm){
        $query = "INSERT INTO ".$this->table." (token_form,id_detail,id_shipment,id_product,min_stock,real_stock_in_store,quantity,received)
                    SELECT '$tokenForm',id,id_shipment,id_product,min_stock,real_stock_in_store,quantity,received
                    FROM stores_shipments_details WHERE id_shipment = '$idShipment'";
        
        $result = $this->query($query);
        if($result){
            return true;
        }
        
        return null;
    }

    public function update($id, $data, $table = null) {
        if(isset($data['id_shipment'])){
            if($data['id_shipment']=='' || !$data['id_shipment']){
                unset($data['id_shipment']);
            }
        }

        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
}