<?php
class ProductionRepository extends EntityRepository {
    
    private $table = 'production';
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function save(array $data, $table = null) {
        $login = new Login();
        $data['status'] = '1';       
        $data['creado_por'] = $login->getId();
        $data['creado_fecha'] = date('Y-m-d H:i:s');
        
        $this->startTransaction();   
        
        if(parent::save($data, $this->table)){
            $lastInsertId = $this->getInsertId();
            $this->setLastInsertId($lastInsertId);
            $repoProduct = new InventarioRepository();
            $requisitionRepo = new RequisitionRepository();
            $settings = new SettingsEntity();
            $idSucursal = $settings->_get('store_default_production');
            
            $requisitionData = $requisitionRepo->getById($data['id_requisition']);
            
            if($repoProduct->addInventory(array(
                'id_product'=>$data['id_product'],
                'quantity'=>$data['quantity'],
                'sucursal'=>$idSucursal,
                'controller'=>'Produccion '.$requisitionData['req_number']." - Insertar ({$lastInsertId})"))){
                $this->commit();
                return true;
            }
        }        
        
        $this->rollback();
        return null;
    }

    public function update($id, $data, $table = null) {
        $currentData = $this->getById($id);
        
        $login = new Login();
        $data['status'] = '1';       
        $data['ultima_mod_por'] = $login->getId('');
        $data['ultima_mod_fecha'] = date('Y-m-d H:i:s');        
        unset($data['status'],$data['creado_por'],$data['creado_fecha']);      
        
        $this->startTransaction();  
        
        if(parent::update($id, $data, $this->table)){
            $settings = new SettingsEntity();
            $id_sucursal = $settings->_get('store_default_production');
            
            $requisitionRepo = new RequisitionRepository();
            $requisitionData = $requisitionRepo->getById($data['id_requisition']);
            
            $repoProduct = new InventarioEntity();
            if($repoProduct->updateAddInventory(array(
                'id_product'=>$data['id_product'],
                'current_quantity'=>$currentData['quantity'],
                'new_quantity'=>$data['quantity'],
                'current_sucursal'=>$id_sucursal,
                'new_sucursal'=>$id_sucursal,
                'controller'=>'Produccion '.$requisitionData['req_number']." - Editar ({$id})"))){
                
                $this->commit();
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT p.*,"
                . "pr.codigo,"
                . "fxGetProductoDescripcion(p.id_product)as productName,"
                . "fxGetSizeDescriptionByIdProduct(p.id_product)as sizeName,"
                . "fxGetStatusName(p.status,'status','loadLine')as statusName, "
                . "DATE_FORMAT(p.creado_fecha,'%W')as created "
                . "FROM $this->table p JOIN productos pr ON p.id_product = pr.id  "
                . "WHERE p.id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }
        
        return false;
    }
    
    public function delete($id, $table = null) {
        $this->startTransaction();
        
        if($this->updateString(array('status'=>'2'), " id = $id ", $this->table)){
            $data = $this->getById($id);
            $this->updateProducedQtyInRequisition($data);
            
            $settings = new SettingsEntity();
            $idSucursal = $settings->_get('store_default_production');
                    
            $requisitionRepo = new RequisitionRepository();
            $requisitionData = $requisitionRepo->getById($data['id_requisition']);
            
            $repoProduct = new InventarioEntity();
            if($repoProduct->subInventory(array(
                'id_product'=>$data['id_product'],
                'quantity'=>$data['quantity'],
                'sucursal'=>$idSucursal,
                'controller'=>'Produccion '.$requisitionData['req_number']." - Eliminar({$id})"))){
                $this->commit();
                return true;
            }           
        }
        
        $this->rollback();
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere= null) {
       # return parent::isUsedInRecord($id, array('production'=>'id_load_line'));   
        return null;
    }
    
    
     public function getListProduction($idLoadLine = null){
         if($idLoadLine != null){
             $idLoadLine = " AND id_load_line = {$idLoadLine}";
         }
        $query = "SELECT pr.*,"
                . "DATE_FORMAT(pr.creado_fecha,'%r')as createdTime,"
                . "IF(pr.id_product = '0','Especial',p.descripcion)as description,"
                . "fxGetTamanoDescripcion(tamano)as sizeName "
                . "FROM "
                . "$this->table pr LEFT JOIN `productos` p ON pr.id_product = p.id "
                . "WHERE 1 = 1 $idLoadLine "
                . "ORDER BY pr.id DESC";
        $result = $this->query($query);
        
        if($result){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getListSelectLines(){
        $query = "SELECT id,name FROM `lines` ORDER BY name ASC";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->name;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function startProduction($idLoadLine){
        $startTime = date('Y-m-d G:i:s');
        return $this->updateString(array('start'=>$startTime,'status'=>'3'), " id = '$idLoadLine'", $this->table);
    }
    
    public function pauseProduction($idLoadLine){
        $startTime = date('Y-m-d G:i:s');
        return $this->updateString(array('last_downtime'=>$startTime,'status'=>'4'), " id = '$idLoadLine'", $this->table);
    }
    
    public function restartProduction($idLoadLine,$status = null){ 
        /* Envio status cuando la uso desde esta clase en la function endProduction */
        if($status == null){$status = '3';}
        $restartTime = date('Y-m-d G:i:s');
        $originData = $this->getById($idLoadLine); 
        
        if($originData['downtime']=='' || $originData['downtime'] == null){
            $query = "UPDATE $this->table SET "
                    . "downtime = SEC_TO_TIME(TIMESTAMPDIFF(SECOND,last_downtime,'$restartTime')),"
                    . "status = '$status'";
            return $this->query($query);
        }else{
            $query = "UPDATE $this->table SET "
                    . "downtime = ADDTIME(SEC_TO_TIME(TIMESTAMPDIFF(SECOND,last_downtime,'$restartTime')),downtime),"
                    . "status = '$status'";
            return $this->query($query);
        }
    }
    
    public function endProduction($idLoadLine){
        $endTime = date('Y-m-d G:i:s');
        $originData = $this->getById($idLoadLine);
        
        if($originData['status']=='4'){
            return $this->restartProduction($idLoadLine,'5');
        }else{
            return $this->updateString(array('end'=>$endTime,'status'=>'5'), " id = '$idLoadLine'", $this->table);
        }       
    }
    
    public function getSumProduced($data){
        $reqNumber = null;
        $idProduct = null;
        
        if(key_exists('req_number',$data)){ $reqNumber = " AND req_number = '{$data['req_number']}' ";}
        if(key_exists('id_product',$data)){ $idProduct = " AND id_product = '{$data['id_product']}' ";}
        
        $query = "SELECT SUM(quantity)produced FROM production WHERE 1=1 AND status != 2 $reqNumber $idProduct ";
        $result = $this->query($query);
        
        if($result){
            $result = $result->fetch_object();
            if($result->produced == null){
                return '0';
            }
            return $result->produced;
        }
        return '0';
    }
    
    public function updateProducedQtyInRequisition($data){ 
        $produced = $this->getSumProduced($data);
        $entity = new EntityRepository();      
        
        if($data['id_product'] == '0'){
            #Para requisiciones Especiales y que el producto es especial, es decir no es de linea.
            #En este caso se actualiza tbl requisition
            $query = "UPDATE special_requisitions SET produced = $produced "
               . "WHERE id = '{$data['id_requisition']}'";
        }else{
            if($data['type']=='Line'){
                $table = 'requisitions_details';
            }elseif($data['type']=='Special'){
                $table = 'special_requisitions_details';
            }        
        
            $query = "UPDATE $table SET produced = $produced "
               . "WHERE id_requisition = '{$data['id_requisition']}' AND id_product = '{$data['id_product']}' ";
        }
        
        $entity->query($query);
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        $fechaInicio = $options['startDate'];
        $fechaFin = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
}