<?php

class LoadLineRepository extends EntityRepository {
    
    private $table = 'load_lines';
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }

    public function save(array $data, $table = null) {
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $reqNumber = explode('-', $data['req_number']);
        $data['req_number'] = $reqNumber[0];
        $data['type'] = $reqNumber[1];
        $data['status'] = '1';
        
        return parent::save($data, $this->table);
    }

    public function update($id, $data, $table = null) {
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $reqNumber = explode('-', $data['req_number']);
        $data['req_number'] = $reqNumber[0];
        $data['type'] = $reqNumber[1];
        unset($data['status']);
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "fxGetStatusName(status,'status','loadLine')as statusName, "
                . "DATE_FORMAT(start,'%d/%m/%Y %r')as startFormated,"
                . "DATE_FORMAT(end,'%d/%m/%Y %r')as endFormated,"
                . "DATE_FORMAT(last_downTime,'%d/%m/%Y %r')as lastDowntimeFormated,"
                . "fxGetLineName(id_line)as lineName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
    public function delete($id, $table = null) {
        return $this->updateString(array('status'=>'2'), " id = $id ", $this->table);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere= null) {
        return parent::isUsedInRecord($id, array('production'=>'id_load_line'));   
    }
    
    public function getListSelectLoadLines(){
        $query = "SELECT ll.id,ll.req_number,l.name "
                . " FROM "
                . " $this->table ll LEFT JOIN `lines` l ON ll.id_line = l.id "
                #. "WHERE (ll.status = 3 OR ll.status = 4 OR ll.status = 5) "
                . "ORDER BY date DESC, l.name ASC";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->name." - OT: ".$row->req_number;
            }            
            return $array;
        }        
        return null;
    }
    
     public function getListLoadLines(){
        $query = "SELECT ll.*,"
                . "DATE_FORMAT(ll.date,'%d/%m/%Y')as date,"
                . "DATE_FORMAT(ll.start,'%d/%m/%Y %r')as start,"
                . "DATE_FORMAT(ll.end,'%d/%m/%Y %r')as end,"
                . "DATE_FORMAT(ll.last_downTime,'%d/%m/%Y %r')as lastDowntime,"
                . "ll.status as statusLoadLine,"
                . "l.name as lineName,"
                . "fxGetStatusName(ll.status,'status','loadLine')as statusName "
                . " FROM "
                . " $this->table ll LEFT JOIN `lines` l ON ll.id_line = l.id "
                . "ORDER BY name ASC";
        $result = $this->query($query);
        
        if($result){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function getListSelectLines(){
        $query = "SELECT id,name FROM `lines` ORDER BY name ASC";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->name;
            }
            
            return $array;
        }
        
        return null;
    }
    
    public function startProduction($idLoadLine){
        $startTime = date('Y-m-d G:i:s');
        return $this->updateString(array('start'=>$startTime,'status'=>'3'), " id = '$idLoadLine'", $this->table);
    }
    
    public function pauseProduction($idLoadLine){
        $startTime = date('Y-m-d G:i:s');
        return $this->updateString(array('last_downtime'=>$startTime,'status'=>'4'), " id = '$idLoadLine'", $this->table);
    }
    
    public function restartProduction($idLoadLine,$status = null){ 
        /* Envio status cuando la uso desde esta clase en la function endProduction */
        if($status == null){$status = '3';}
        $restartTime = date('Y-m-d G:i:s');
        $originData = $this->getById($idLoadLine); 
        
        if($originData['downtime']=='' || $originData['downtime'] == null){
            $query = "UPDATE $this->table SET "
                    . "downtime = SEC_TO_TIME(TIMESTAMPDIFF(SECOND,last_downtime,'$restartTime')),"
                    . "status = '$status' "
                    . "WHERE id = '$idLoadLine'";
            return $this->query($query);
        }else{
            $query = "UPDATE $this->table SET "
                    . "downtime = ADDTIME(SEC_TO_TIME(TIMESTAMPDIFF(SECOND,last_downtime,'$restartTime')),downtime),"
                   . "status = '$status' "
                    . "WHERE id = '$idLoadLine'";
            return $this->query($query);
        }
    }
    
    public function endProduction($idLoadLine){
        $endTime = date('Y-m-d G:i:s');
        $originData = $this->getById($idLoadLine);
        
        if($originData['status']=='4'){
            #si utilizo $this->restartProduction se va restartProduction de LoadLineAjax.
            return self::restartProduction($idLoadLine,'5');
        }else{
            return $this->updateString(array('end'=>$endTime,'status'=>'5'), " id = '$idLoadLine'", $this->table);
        }       
    }
    
    public function getLoadLineByLine($line){
        $query = "SELECT id FROM $this->table "
               . "WHERE  id_line = '$line' "
               . "AND (status = '3' OR status = '4') "
               . "ORDER BY status ASC "
               . "LIMIT 1 ";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            return $result->id;
        }
        return null;
    }
    
    public function getRequisitions(){
      $query = "SELECT  * "
              . "FROM view_global_requisitions "
              . "WHERE status != 3 "
              . "AND type = 'Line'";
      $result = $this->query($query);
      
      if($result->num_rows > 0){
          $result = $this->resultToArray($result);
          $array = array();
          foreach ($result as $row){
              $array[$row['req_number'].'-'.$row['type']] = $row['req_number'];
          }
          return $array;
      }
      return null;
  }
    
    public function createFilterFecha($options,$campoFecha = null ){
        $fechaInicio = $options['startDate'];
        $fechaFin = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
}