<?php  
class StoreRequestPDF {
    private $pathfFileCreated = null; 
    public function __construct($idShipment,$createFile = null) {
        $shipment = new StoreRequestRepository();
        $shipment->setOptions($shipment->getById($idShipment));
        $shipment->setId($idShipment);
        
        $empresa = new CompanyEntity();
        $empresa->setOptions($empresa->getById(1));        
        
        //Modifique metodo AddPage para qe ricibiera un tercer parametro, dicho parametro contiene el texto para a marca de agua.
        // para crear la marca de agua agregue las funciones Header y RotatedText en pdf.php 
        $pdf = new PDF();
        if($shipment->getStatus() == '2'){
            $pdf->AddPage('','','  Cancelada');
        }else{
            $pdf->AddPage('','');
        }
        
       $pdf->SetFont('Arial','','14');
        $pdf->SetTextColor(255);
        $pdf->SetFillColor(51,153,255);
        $pdf->SetX(0);
        $pdf->Cell(90,10, "PEDIDO No: ".$idShipment, '0', 0, 'R',true);   
        $pdf->Cell(15, 10, "", '', 0, 'C'); //<== margin left 
        $pdf->SetTextColor(0);
        $pdf->Cell(95, 10, $empresa->getName(), 'L', 1, 'R');     
        
        $y = $pdf->GetY();        
        $pdf->SetFont('Arial','','9');    
        $pdf->Cell(80, 6, " ", '', 0, 'R');//<== margin
        $direccion  ="\n".$empresa->getAddress();
        $direccion .= "\n".$empresa->getCity().', '.$empresa->getState().' '.$empresa->getZipCode();
        $direccion .= "\n".$empresa->getPhone();
        $pdf->Cell(15, 15, '', '', 0, 'C'); //<== margin left 
        $pdf->Cell(95, 12, $direccion, '', 1, 'R');   
           
        $pdf->SetY($y);
        $pdf->Cell(40, 6, "STATUS: ", '', 0, 'R');
        $pdf->Cell(40, 6, $shipment->getStatusName(), '', 1, 'R');            

        $pdf->SetFont('Arial','','9');
        $pdf->Cell(40, 5, 'FECHA DE PEDIDO: ', '', 0, 'R');
        $pdf->Cell(40, 5, $shipment->getFormatedDate(), '', 1, 'R');  
        
        $sucursal = new StoreRepository();        
        $sucursal->setOptions($sucursal->getById($shipment->getStoreId()));
        $pdf->Cell(40, 5, 'SUCURSAL: ', '', 0, 'R');
        $pdf->Cell(40, 5, $sucursal->getNombre(), '', 1, 'R');       
       
        $pdf->Ln(5);        
        $pdf->SetFont('Arial','B','8');
        
        $pdf->Cell(80, 7, "Descripcion", 'B', 0, 'L');
        $pdf->Cell(30, 7, utf8_decode("Tamaño"), 'B', 0, 'L');
        $pdf->Cell(25, 7, "Existencia", 'B', 1, 'R'); 
               
        $pdf->SetFont('Arial','','8');
        $detalles = $shipment->getStoreRequestDetallesSavedPDF($idShipment,true);
        
        foreach($detalles as $detalle){            
            $pdf->Cell(80, 5, utf8_decode($detalle['description']), 'B', 0, 'L');
            $pdf->Cell(30, 5, utf8_decode($detalle['size']), 'B', 0, 'L');
            $pdf->Cell(25, 5, number_format($detalle['quantity']), 'B', 1, 'R');
        }              
        
        $pdf->Ln(5);
        $pdf->SetFont('Arial','B','8');
        $pdf->Cell(93, 7, "Notas de pedido", 'B', 1, 'L');
        $pdf->Cell(93, 2, "", '0', 1, 'L');
        $pdf->SetFont('Arial','','8');
        $pdf->Multicell(93,3,  $shipment->getComments(), '0', 1, 'L');

        if($createFile){
            if(!is_dir(PATH_TEMP_DOCS."requisitions/")){
                mkdir(PATH_TEMP_DOCS."requisitions/",0777,true);
            }
            $pdf->Output(PATH_TEMP_DOCS."requisitions/REQ-".$idShipment.".pdf","F");
            $this->pathfFileCreated = PATH_TEMP_DOCS."requisitions/REQ-".$idShipment.".pdf";
        }else{
            $pdf->Output();
            unlink(ROOT.'app/resources/docs/temp/barcodes/'.$shipment->getNumShipment().'.png');
        }
    }
    
    public function getPathFileCreated(){
        return $this->pathfFileCreated;
    }
}