<?php
class StoreAjax extends SucursalRepository {
    public $formProduct = null;
    public $formStore = null;
    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setStoreDetails(array $options) {
        $data = array();
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }

        $options = $data;
        $producto = $this->getProductById($options['product']);
        if($producto){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_product'=>$producto['id'],
                'days'=>$this->daysArrayTostring($options['days']),
                'min'=>$options['min'],
                'max'=>$options['max'],
                'token_form'=>$options["token_form"]); /*Para cuenta de inventario*/
            $this->insertDetalle($data);
            $storeDetails = $this->getStoreDetails($data['token_form']);
            $detalles = $this->listStoreDetails($storeDetails);

            $json = array(
                'response' => true,
                'storeDetails' => $detalles['storeDetails'],
                'totalItemsMin'=>number_format($detalles['totalItemsMin'],2),
                'totalItemsMax'=>number_format($detalles['totalItemsMax'],2)
            );
            
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listStoreDetails($detalles){
        $listDetalles = "";
        $cantidadItemsMin = 0;
        $cantidadItemsMax = 0;
        $daysName = $this->getListDays();
        
        foreach($detalles as $detalle){
            $cantidadItemsMin += $detalle['min'];
            $cantidadItemsMax += $detalle['max'];
            $id = $detalle['id'];
            unset($detalle['id']);
            
            $days = explode(',', $detalle['days']);
            $stringDays = '';
            foreach($days as $day){
                $stringDays .= $daysName[$day].' - ';               
            }
            $stringDays = trim(trim($stringDays),'-');        
            
            $array = json_encode($detalle);
            $listDetalles .= "<tr>  
                <td class='text-left'>                       
                    <a class='btn btn-sm btn-primary' onclick='setDetailStoreToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteStoreDetails($id);'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['code']."</td>
                <td>".$detalle['description']."</td>
                <td class='text-center'>".$detalle['size']."</td>
                <td class='text-center'>".$stringDays."</td>
                <td class='text-right'>".number_format($detalle['min'])."</td>
                <td class='text-right'>".number_format($detalle['max'])."</td>
                </tr>";
        }
        
        return array('storeDetails'=>$listDetalles,
                    'totalItemsMin'=>$cantidadItemsMin,
                    'totalItemsMax'=>$cantidadItemsMax
            );
    }
    
    public function getListStoreDetails($tokenForm){
        $storeDetails = $this->getStoreDetails($tokenForm);
        $detalles = $this->listStoreDetails($storeDetails);

            $json = array(
                'response' => true,
                'storeDetails' => $detalles['storeDetails'],
                'totalItemsMin'=>number_format($detalles['totalItemsMin'],2),
                'totalItemsMax'=>number_format($detalles['totalItemsMax'],2)
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $repository = new StoreDetailsTempRepository();
        $current_data = $repository->getById($id);
        
        if($repository->delete($id)){
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        }else{
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        
        $storeDetails = $this->getStoreDetails($current_data['token_form']);
        $detalles = $this->listStoreDetails($storeDetails);

        $json = array(
                'response' => true,
                'storeDetails' => $detalles['storeDetails'],
                'totalItemsMin'=>number_format($detalles['totalItemsMin'],2),
                'totalItemsMax'=>number_format($detalles['totalItemsMax'],2)
            ); 
            return $json;
    }
}