<?php
/**
 * Description of ClienteForm
 *
 * @author carlos
 */
class ProveedorForm extends Form {

    public function __construct() {
        $this->setActionForm('Vendor.php');
        $this->setName('proveedor');
        $this->setMethod('post');
        $this->setClass('proveedor');     
        $this->setDefaultFormLabelsColSize('4');
        $this->setDefaultFormElementsColSize('8');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'calle',
            'label'=>'Direccion',
            'required'=>false
        ));        
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'ciudad',
            'label'=>'Ciudad',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'estado',
            'label'=>'Estado',
            'required'=>false
        ));
        
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigopostal',
            'label'=>'Codigo postal',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'contacto',
            'label'=>'Contacto',
            'required'=>false
        ));        
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'telefono',
            'label'=>'Telefono',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fax',
            'label'=>'Fax',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'correo',
            'label'=>'Email',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'metodoPago',
            'label'=>'Metodo de Pago',
            'multiOptions'=>$this->listMetodosPago(),
            'optionals'=>array('onChange'=>"enabledDisabledPeriodoCredito(this.value,'proveedor')"),
            'required'=> false
        ));
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'diasCredito',
            'label'=>'Dias de credito',
            'optionals'=>array('disabled'=>'disabled',),
            'required'=>false
        ));
         
          $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comentarios',
            'label'=>'Comentarios',
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Vendor.php'"),
            'class'=>'btn btn-danger m-t-1'
        ));
    }
    
    public function listMetodosPago(){
        $repository = new FormaMetodoPagoRepository();
        $result = $repository->getListMetodosPago();
        
        if ($result) {
            $array = array(null => 'Seleccionar una opcion...');
            $i = 1;
            foreach ($result as $key => $value) {
                $array[$key] = $value;
                $i++;
            }
            return $array;
        }
    }
    
    public function populate($data) {
        if(isset($data['metodoPago']) && $data['metodoPago']=='2'){
            $this->enabledElement(array('diasCredito'));
        }
        parent::populate($data);
    }
}