<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class EstacionForm extends Form {

    public function __construct() {
        $this->setActionForm('Station.php');
        $this->setClass('producto form-horizontal');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'token',
            'label'=>'Token',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'tipo',
            'label'=>'Tipo',
            'multiOptions' => $this->getListTipos(),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'sucursal',
            'label'=>'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => $this->getListStatus(),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
            'onclick'=>"document.location = '".ROOT_HOST."/Controller/Station.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));

    }
    
    public function getListStatus(){
        $repository = new EstacionRepository();
        $list = $repository->getListStatus();
         
        $array = array();
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;        
    }
    
    public function getListTipos(){
        return array(
            '1'=>'Caja',
        );
    }
    
    public function getListSucursales(){
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales();
         
        $array = array();
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;        
    }
    
    public function populate($data){
        parent::populate($data);
    }
    
    public function isValid() {
        $valid = parent::isValid();        
        $flashmessenger = new FlashMessenger();                
        
        $idEstacion = $this->getId();
        $nombre = $this->getElement('nombre');
        $token = $this->getElement('token');
        
        $repository = new EstacionRepository();
        if($repository->existeNombre($nombre['value'],$idEstacion)){
            $flashmessenger->addMessage(array('info'=>'Ya se esta utilizando este nombre de estacion. Intente con otro nombre.'));
            return null;
        }  
        
        $token = $repository->existeToken($token['value'],$idEstacion);
        if($token){
            $message  = $this->_getTranslation('Ya se esta utilizando este token para la estacion:');
            $message .= " ".$token['nombre'];
            $flashmessenger->addMessage(array('info'=>$message));
            return null;
        }  
         
        return $valid;
    }
}